
/*Test 1: Restore with seconday log*/
USE master
GO
IF DB_ID('PersonsLots') IS NOT NULL 
    DROP DATABASE PersonsLots;
GO
CREATE DATABASE Personslots ON PRIMARY 
 (   NAME = N'PersonsLots'
   , FILENAME = N'C:\SQLData\Persons_lots.mdf'
   , SIZE = 199680KB
   , FILEGROWTH = 16384KB
)
LOG ON
(   NAME = N'PersonsLots_log'
   , FILENAME = N'D:\SQLData\Persons_lots.ldf'
   , SIZE = 2048KB 
   , FILEGROWTH = 2048KB
)
GO

ALTER DATABASE PersonsLots SET RECOVERY FULL;

USE master
go
BACKUP DATABASE PersonsLots
TO DISK ='D:\SQLBackups\PersonsLots_full.bak'
WITH INIT;
GO

USE PersonsLots
GO
IF EXISTS ( SELECT  *
            FROM    sys.objects
            WHERE   object_id = OBJECT_ID(N'dbo.Persons')
                    AND type = N'U' ) 
    DROP TABLE dbo.Persons;
go

CREATE TABLE dbo.Persons
    (
     PersonID INT NOT NULL
                 IDENTITY ,
      FName VARCHAR(20) NOT NULL ,
      LName VARCHAR(30) NOT NULL ,
      Email VARCHAR(7000) NOT NULL
    );
GO

INSERT  INTO dbo.Persons
        ( FName ,
          LName ,
          Email
        )
        SELECT TOP 1000000
          LEFT(aw1.FirstName, 20) ,
                LEFT(aw1.LastName, 30) ,
                aw1.EmailAddress
        FROM    AdventureWorks2005.Person.Contact aw1
        CROSS JOIN AdventureWorks2005.Person.Contact aw2;
GO

USE [master]
GO
ALTER DATABASE [Personslots] 
ADD LOG FILE ( NAME = N'PersonsLots_Log2', 
FILENAME = N'D:\SQLData\Persons_lots2.ldf' , SIZE = 3146000KB , FILEGROWTH = 314600KB )
GO

BACKUP LOG Personslots
TO DISK = 'D:\SQLBackups\PersonsLots.trn'
WITH init

/*Restore*/
USE master
go
RESTORE DATABASE Personslots
FROM DISK ='D:\SQLBackups\PersonsLots_full.bak'
WITH REPLACE, NORECOVERY;

RESTORE DATABASE Personslots
FROM DISK='D:\SQLBackups\PersonsLots.trn'
WITH Recovery;

/*Processed 200 pages for database 'Personslots', file 'PersonsLots' on file 1.
Processed 2 pages for database 'Personslots', file 'PersonsLots_log' on file 1.
RESTORE DATABASE successfully processed 202 pages in 0.062 seconds (25.406 MB/sec).
Processed 0 pages for database 'Personslots', file 'PersonsLots' on file 1.
Processed 18094 pages for database 'Personslots', file 'PersonsLots_log' on file 1.
Processed 0 pages for database 'Personslots', file 'PersonsLots_Log2' on file 1.
RESTORE LOG successfully processed 18094 pages in 62.141 seconds (2.274 MB/sec).*/


/*Test 2: Restore without seconday log*/
USE master
GO
IF DB_ID('PersonsLots') IS NOT NULL 
    DROP DATABASE PersonsLots;
GO
CREATE DATABASE Personslots ON PRIMARY 
 (   NAME = N'PersonsLots'
   , FILENAME = N'C:\SQLData\Persons_lots.mdf'
   , SIZE = 199680KB
   , FILEGROWTH = 16384KB
)
LOG ON
(   NAME = N'PersonsLots_log'
   , FILENAME = N'D:\SQLData\Persons_lots.ldf'
   , SIZE = 2048KB 
   , FILEGROWTH = 2048KB
)
GO

ALTER DATABASE PersonsLots SET RECOVERY FULL;

USE master
go
BACKUP DATABASE PersonsLots
TO DISK ='D:\SQLBackups\PersonsLots_full.bak'
WITH INIT;
GO

USE PersonsLots
GO
IF EXISTS ( SELECT  *
            FROM    sys.objects
            WHERE   object_id = OBJECT_ID(N'dbo.Persons')
                    AND type = N'U' ) 
    DROP TABLE dbo.Persons;
go

CREATE TABLE dbo.Persons
    (
     PersonID INT NOT NULL
                 IDENTITY ,
      FName VARCHAR(20) NOT NULL ,
      LName VARCHAR(30) NOT NULL ,
      Email VARCHAR(7000) NOT NULL
    );
GO

INSERT  INTO dbo.Persons
        ( FName ,
          LName ,
          Email
        )
        SELECT TOP 1000000
          LEFT(aw1.FirstName, 20) ,
                LEFT(aw1.LastName, 30) ,
                aw1.EmailAddress
        FROM    AdventureWorks2005.Person.Contact aw1
        CROSS JOIN AdventureWorks2005.Person.Contact aw2;
GO

BACKUP LOG Personslots
TO DISK = 'D:\SQLBackups\PersonsLots.trn'
WITH init

USE master
go
RESTORE DATABASE Personslots
FROM DISK ='D:\SQLBackups\PersonsLots_full.bak'
WITH REPLACE, NORECOVERY;

RESTORE DATABASE Personslots
FROM DISK='D:\SQLBackups\PersonsLots.trn'
WITH Recovery;
/*Processed 200 pages for database 'Personslots', file 'PersonsLots' on file 1.
Processed 2 pages for database 'Personslots', file 'PersonsLots_log' on file 1.
RESTORE DATABASE successfully processed 202 pages in 0.133 seconds (11.843 MB/sec).
Processed 0 pages for database 'Personslots', file 'PersonsLots' on file 1.
Processed 18089 pages for database 'Personslots', file 'PersonsLots_log' on file 1.
RESTORE LOG successfully processed 18089 pages in 7.980 seconds (17.709 MB/sec).
*/



USE Personslots
GO
ALTER DATABASE Personslots  REMOVE FILE PersonsLots_Log2
GO

USE Personslots
go
DBCC LOGINFO
-- 700 VLFs

DBCC SQLPERF(LOGSPACE);
--350 MB, 6.34% full

USE Personslots
GO
DBCC SHRINKFILE (N'PersonsLots_log' , 0)
GO

/*Cannot shrink log file 2 (PersonsLots_log) because the logical log file located at the end of the file is in use.

(1 row(s) affected)
DBCC execution completed. If DBCC printed error messages, contact your system administrator.*/

USE master
go
BACKUP DATABASE PersonsLots
TO DISK ='D:\SQLBackups\PersonsLots_full.bak'
WITH INIT;
GO

BACKUP LOG Personslots
TO DISK = 'D:\SQLBackups\PersonsLots.trn'
WITH init

USE Personslots
GO
DBCC SHRINKFILE (N'PersonsLots_log' , 0)
GO

USE Personslots
go
DBCC LOGINFO
-- 4 VLFs

DBCC SQLPERF(LOGSPACE);
--2 MB, 15 % used