--execute the following script on the repository (instance where data will be saved)

IF NOT EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = N'Trace_Repository')
CREATE DATABASE [Trace_Repository]  COLLATE SQL_Latin1_General_CP1_CI_AS
GO

use [Trace_Repository]
GO

/* create table to hold data */
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[tbl_trace]') and OBJECTPROPERTY(id, N'IsTable') = 1)
drop table [dbo].[tbl_trace]
GO

CREATE TABLE [dbo].[tbl_trace] (
	[TextData] [ntext] COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[BinaryData] [image] NULL ,
	[DatabaseID] [int] NULL ,
	[TransactionID] [bigint] NULL ,
	[NTUserName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[NTDomainName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[HostName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[ClientProcessID] [int] NULL ,
	[ApplicationName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[LoginName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[SPID] [int] NULL ,
	[Duration] [bigint] NULL ,
	[StartTime] [datetime] NULL ,
	[EndTime] [datetime] NULL ,
	[Reads] [bigint] NULL ,
	[Writes] [bigint] NULL ,
	[CPU] [int] NULL ,
	[Permissions] [int] NULL ,
	[Severity] [int] NULL ,
	[EventSubClass] [int] NULL ,
	[ObjectID] [int] NULL ,
	[Success] [int] NULL ,
	[IndexID] [int] NULL ,
	[IntegerData] [int] NULL ,
	[ServerName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[EventClass] [int] NOT NULL ,
	[ObjectType] [int] NULL ,
	[NestLevel] [int] NULL ,
	[State] [int] NULL ,
	[Error] [int] NULL ,
	[Mode] [int] NULL ,
	[Handle] [int] NULL ,
	[ObjectName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[DatabaseName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[FileName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[OwnerName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[RoleName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[TargetUserName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[DBUserName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[LoginSid] [image] NULL ,
	[TargetLoginName] [nvarchar] (128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL ,
	[TargetLoginSid] [image] NULL ,
	[ColumnPermissions] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

 CREATE  INDEX [IX_tbl_trace_end_time] ON [dbo].[tbl_trace]([StartTime]) WITH  FILLFACTOR = 80 ON [PRIMARY]
GO

/* create proc to load data from file to table */

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[dsp_load_trace_data]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[dsp_trace_load_data]
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO
CREATE PROCEDURE dbo.dsp_trace_load_data 
@path nvarchar(128)
AS

set @path = @path+N'.trc'
-- LOAD DATA FROM THE SQL TRACE INTO A STAGING TABLE
SELECT * INTO tbl_stage_trace FROM ::fn_trace_gettable(@PATH,default)

if (select count(*) from sysobjects where upper(name) = 'TBL_TRACE') > 0
-- MOVE THE DATA FROM THE STAGE TABLE INTO THE TRACE REPOSITORY TABLE
  INSERT INTO tbl_trace SELECT * FROM tbl_stage_trace
ELSE
  SELECT * INTO tbl_trace FROM tbl_stage_trace
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO


