--execute the following script on the traceserver (server to be traced)

IF NOT EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = N'Trace_Repository')
CREATE DATABASE [Trace_Repository]  COLLATE SQL_Latin1_General_CP1_CI_AS
GO

use [Trace_Repository]
GO

if not exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[tbl_traceconfig]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
  CREATE TABLE [dbo].[tbl_traceconfig] (
	[configkey] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL ,
	[configvalue] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL) ON [PRIMARY]
GO

-- last value is filename to use, do not add .trc to file name
if not exists (select * from [dbo].[tbl_traceconfig] where configvalue = 'path')
  insert into [dbo].[tbl_traceconfig] values ('path','c:\temp\sqltrace')

if not exists (select * from [dbo].[tbl_traceconfig] where configvalue = 'filesize')
  insert into [dbo].[tbl_traceconfig] values ('filesize','512')

if not exists (select * from [dbo].[tbl_traceconfig] where configvalue = 'currtraceid')
  insert into [dbo].[tbl_traceconfig] values ('currtraceid','0')

if not exists (select * from [dbo].[tbl_traceconfig] where configvalue = 'archive')
  insert into [dbo].[tbl_traceconfig] values ('archive','c:\temp\archive')
  
-- default is to archive files  
if not exists (select * from [dbo].[tbl_traceconfig] where configvalue = 'archivefile')
  insert into [dbo].[tbl_traceconfig] values ('archivefile','1')
  
-- number of days to keep records in tbl_trace, for purge to work endtime must be captured by trace
-- default 30 days
if not exists (select * from [dbo].[tbl_traceconfig] where configvalue = 'archivedays')
  insert into [dbo].[tbl_traceconfig] values ('archivedays','30')

/*------------------------------------------------------------------*/
-- create trace file
-- replace  sp_trace_setevent and sp_trace_setfilter statements with values specific to your install
-- these statements can be generated by setting up in profiler and then choosing script trace from the file menu


if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[dsp_trace_create_start]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[dsp_trace_create_start]
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS OFF 
GO

CREATE PROCEDURE dbo.dsp_trace_create_start
@path nvarchar(128),
@filesize bigint
AS

DECLARE @RC INT 
DECLARE @TRACEID INT 
DECLARE @ON BIT 
--DECLARE @path varchar(12)
--DECLARE @filesize int

--select @path = configvalue from tbl_traceconfig where configkey = 'path'
--select @filesize = configkey from tbl_traceconfig where configkey = 'filesize'

EXEC @RC = sp_trace_create @TRACEID OUTPUT, 2, @PATH, @filesize 

SELECT rc = @RC, TRACEID = @TRACEID 

SELECT @ON = 1 

-- load template file to view details of trace SQLProfiler_Audit.tdf

exec sp_trace_setevent @TraceID, 46, 1, @on
exec sp_trace_setevent @TraceID, 46, 3, @on
exec sp_trace_setevent @TraceID, 46, 6, @on
exec sp_trace_setevent @TraceID, 46, 7, @on
exec sp_trace_setevent @TraceID, 46, 8, @on
exec sp_trace_setevent @TraceID, 46, 10, @on
exec sp_trace_setevent @TraceID, 46, 11, @on
exec sp_trace_setevent @TraceID, 46, 12, @on
exec sp_trace_setevent @TraceID, 46, 14, @on
exec sp_trace_setevent @TraceID, 46, 15, @on
exec sp_trace_setevent @TraceID, 46, 21, @on
exec sp_trace_setevent @TraceID, 46, 22, @on
exec sp_trace_setevent @TraceID, 46, 23, @on
exec sp_trace_setevent @TraceID, 46, 24, @on
exec sp_trace_setevent @TraceID, 46, 26, @on
exec sp_trace_setevent @TraceID, 46, 28, @on
exec sp_trace_setevent @TraceID, 46, 34, @on
exec sp_trace_setevent @TraceID, 46, 35, @on
exec sp_trace_setevent @TraceID, 46, 37, @on
exec sp_trace_setevent @TraceID, 46, 40, @on
exec sp_trace_setevent @TraceID, 47, 1, @on
exec sp_trace_setevent @TraceID, 47, 3, @on
exec sp_trace_setevent @TraceID, 47, 6, @on
exec sp_trace_setevent @TraceID, 47, 7, @on
exec sp_trace_setevent @TraceID, 47, 8, @on
exec sp_trace_setevent @TraceID, 47, 10, @on
exec sp_trace_setevent @TraceID, 47, 11, @on
exec sp_trace_setevent @TraceID, 47, 12, @on
exec sp_trace_setevent @TraceID, 47, 14, @on
exec sp_trace_setevent @TraceID, 47, 15, @on
exec sp_trace_setevent @TraceID, 47, 21, @on
exec sp_trace_setevent @TraceID, 47, 22, @on
exec sp_trace_setevent @TraceID, 47, 23, @on
exec sp_trace_setevent @TraceID, 47, 24, @on
exec sp_trace_setevent @TraceID, 47, 26, @on
exec sp_trace_setevent @TraceID, 47, 28, @on
exec sp_trace_setevent @TraceID, 47, 34, @on
exec sp_trace_setevent @TraceID, 47, 35, @on
exec sp_trace_setevent @TraceID, 47, 37, @on
exec sp_trace_setevent @TraceID, 47, 40, @on
exec sp_trace_setevent @TraceID, 114, 1, @on
exec sp_trace_setevent @TraceID, 114, 3, @on
exec sp_trace_setevent @TraceID, 114, 6, @on
exec sp_trace_setevent @TraceID, 114, 7, @on
exec sp_trace_setevent @TraceID, 114, 8, @on
exec sp_trace_setevent @TraceID, 114, 10, @on
exec sp_trace_setevent @TraceID, 114, 11, @on
exec sp_trace_setevent @TraceID, 114, 12, @on
exec sp_trace_setevent @TraceID, 114, 14, @on
exec sp_trace_setevent @TraceID, 114, 15, @on
exec sp_trace_setevent @TraceID, 114, 21, @on
exec sp_trace_setevent @TraceID, 114, 22, @on
exec sp_trace_setevent @TraceID, 114, 23, @on
exec sp_trace_setevent @TraceID, 114, 24, @on
exec sp_trace_setevent @TraceID, 114, 26, @on
exec sp_trace_setevent @TraceID, 114, 28, @on
exec sp_trace_setevent @TraceID, 114, 34, @on
exec sp_trace_setevent @TraceID, 114, 35, @on
exec sp_trace_setevent @TraceID, 114, 37, @on
exec sp_trace_setevent @TraceID, 114, 40, @on
exec sp_trace_setevent @TraceID, 118, 1, @on
exec sp_trace_setevent @TraceID, 118, 3, @on
exec sp_trace_setevent @TraceID, 118, 6, @on
exec sp_trace_setevent @TraceID, 118, 7, @on
exec sp_trace_setevent @TraceID, 118, 8, @on
exec sp_trace_setevent @TraceID, 118, 10, @on
exec sp_trace_setevent @TraceID, 118, 11, @on
exec sp_trace_setevent @TraceID, 118, 12, @on
exec sp_trace_setevent @TraceID, 118, 14, @on
exec sp_trace_setevent @TraceID, 118, 15, @on
exec sp_trace_setevent @TraceID, 118, 21, @on
exec sp_trace_setevent @TraceID, 118, 22, @on
exec sp_trace_setevent @TraceID, 118, 23, @on
exec sp_trace_setevent @TraceID, 118, 24, @on
exec sp_trace_setevent @TraceID, 118, 26, @on
exec sp_trace_setevent @TraceID, 118, 28, @on
exec sp_trace_setevent @TraceID, 118, 34, @on
exec sp_trace_setevent @TraceID, 118, 35, @on
exec sp_trace_setevent @TraceID, 118, 37, @on
exec sp_trace_setevent @TraceID, 118, 40, @on


-- Set the Filters
declare @intfilter int
declare @bigintfilter bigint

exec sp_trace_setfilter @TraceID, 1, 1, 6, N'%create %'
exec sp_trace_setfilter @TraceID, 1, 1, 6, N'%alter %'
exec sp_trace_setfilter @TraceID, 1, 1, 6, N'%drop %'
exec sp_trace_setfilter @TraceID, 1, 0, 7, N'select%'
exec sp_trace_setfilter @TraceID, 1, 0, 7, N'update%'
exec sp_trace_setfilter @TraceID, 1, 0, 7, N'delete%'
exec sp_trace_setfilter @TraceID, 10, 0, 7, N'SQL Profiler'



-- START TRACE (STATUS 1 = START) 
EXEC @RC = sp_trace_setstatus @TRACEID, 1 

update tbl_traceconfig set configvalue = @TRACEID where configkey = 'currtraceid'
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

/*-------------------------------------------*/
/* create stop trace proc                    */

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[dsp_trace_stop]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[dsp_trace_stop]
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE PROCEDURE dbo.dsp_trace_stop
@traceid int
as

-- STOP THE TRACE (TRACEID 1)
DECLARE @RC INT
EXEC @RC = sp_trace_setstatus @traceid, 0
if @rc <> 0 return

-- DELETE TRACE DEFINITION (TRACEID 1)
EXEC @RC = sp_trace_setstatus @traceid, 2
if @rc <> 0 return

update tbl_traceconfig set configvalue = 0 where configkey = 'currtraceid'

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

