﻿using System;
using System.IO;
using System.Collections;
using System.Data.SqlTypes;
using Microsoft.SqlServer.Server;

public partial class UserDefinedFunctions
{
    [SqlFunction(
      Name = "os_directory_info",
      FillRowMethodName = "os_directory_info_FillRow",
      DataAccess = DataAccessKind.None,
      IsDeterministic = true,
      TableDefinition = @"name nvarchar(4000), is_directory bit, size_in_bytes bigint, create_date datetime,
                        last_written_to datetime, last_accessed datetime, attributes nvarchar(4000)")]
    public static IEnumerable os_directory_info(SqlString path, SqlString filter)
    {
        DirectoryInfo di = new DirectoryInfo(path.Value);
        if (filter.IsNull || filter.Value == string.Empty)
            return di.GetFileSystemInfos();
        else
            return di.GetFileSystemInfos(filter.Value);
    }

    private static void os_directory_info_FillRow(object obj,
                                                    out SqlString altname,
                                                    out SqlBoolean is_directory,
                                                    out SqlInt64 size,
                                                    out SqlDateTime createdatetime,
                                                    out SqlDateTime lastwritedatetime,
                                                    out SqlDateTime lastaccessdatetime,
                                                    out SqlString attrib)
    {
        if (obj is FileInfo)
        {
            FileInfo fsi = (FileInfo)obj;
            altname = fsi.Name;
            is_directory = SqlBoolean.False;
            size = fsi.Length;
            createdatetime = fsi.CreationTime;
            lastwritedatetime = fsi.LastWriteTime;
            lastaccessdatetime = fsi.LastAccessTime;
            attrib = fsi.Attributes.ToString();
        }
        else
        {
            FileSystemInfo fsi = (FileSystemInfo)obj;
            altname = fsi.Name;
            is_directory = SqlBoolean.True;
            size = SqlInt64.Null;
            createdatetime = fsi.CreationTime;
            lastwritedatetime = fsi.LastWriteTime;
            lastaccessdatetime = fsi.LastAccessTime;
            attrib = fsi.Attributes.ToString();
        }
    }
};
