﻿Imports System
Imports System.Data
Imports System.Data.SqlClient
Imports System.Data.SqlTypes
Imports Microsoft.SqlServer.Server
Imports System.IO
Imports System.Text


Partial Public Class StoredProcedures
    <Microsoft.SqlServer.Server.SqlProcedure()> _
    Public Shared Sub WriteResultsToTabFile(ByVal sqlcmd As String, ByVal filename As String, ByVal includeheaders As Boolean, ByVal quoteall As Boolean, ByVal provideoutput As Boolean)
        ' Used to track the number of rows written to the file. 
        Dim rowcount As Integer = 0
        ' Default error handling to None for Error Message. 
        Dim [error] As New Exception("None")
        'Open Try/Catch for Error Trapping 
        Try
            ' Create a SqlConnection object to the context connection 
            Using conn As New SqlConnection("context connection=true;")
                ' Create a SqlCommand object to pass the query into 
                Using cmd As New SqlCommand(sqlcmd, conn)
                    ' Open the connection to the database 
                    conn.Open()

                    ' Retrieve a SqlDataReader to process the results of the SqlCommand 
                    Using dr As SqlDataReader = cmd.ExecuteReader()
                        ' Create a TextWriter to stream the results to the file using Unicode Encoding 
                        Using stream As TextWriter = New StreamWriter(filename, False, Encoding.Unicode)
                            ' Write the Header Row to the file if required. 
                            If includeheaders Then
                                DelimitedFileWriter.WriteHeadersToStream(stream, dr, vbTab, quoteall)
                            End If
                            ' Loop over each row returned and write it to the file 
                            While dr.Read()
                                rowcount += 1
                                DelimitedFileWriter.WriteRowToStream(stream, dr, vbTab, quoteall)
                            End While
                            ' Clean up by closing the open SqlDataReader and SqlConnection. 
                            dr.Close()
                            conn.Close()

                            ' Flush the stream buffer to the File and close the stream. 
                            stream.Flush()
                            stream.Close()
                        End Using
                    End Using
                End Using
            End Using
        Catch ex As Exception
            ' Catch block to handle Exceptions Raise 
            [error] = ex
            'SqlContext.Pipe.Send(ex.Message); 
        Finally
            ' End code to provide output including error messages if needed. 
            If provideoutput Then
                Dim sdr As New SqlDataRecord(New SqlMetaData("RowsWritten", SqlDbType.Int), New SqlMetaData("FileName", SqlDbType.NVarChar, 480), New SqlMetaData("Errors", SqlDbType.NVarChar, 4000))

                sdr.SetValue(0, rowcount)
                sdr.SetValue(1, filename)
                sdr.SetValue(2, [error].Message)
                SqlContext.Pipe.Send(sdr)
            End If
        End Try
    End Sub
End Class