﻿Imports System
Imports System.Collections.Generic
Imports System.Text
Imports System.IO
Imports System.Data
Imports System.Data.SqlClient


' This is a modified version of Andreas Knab's CSVWriter that can be found 
' on his blog at http://knab.ws/blog/index.php?/archives/3-CSV-file-parser-and-writer-in-C-Part-1.html 
Public Class DelimitedFileWriter
    Public Shared Function WriteToString(ByVal dr As SqlDataReader, ByVal delimeter As String, ByVal header As Boolean, ByVal quoteall As Boolean) As String
        Dim writer As New StringWriter()
        If header Then
            WriteHeadersToStream(writer, dr, delimeter, quoteall)
        End If
        While dr.Read()
            WriteRowToStream(writer, dr, delimeter, quoteall)
        End While
        Return writer.ToString()
    End Function

    Public Shared Sub WriteHeadersToStream(ByVal stream As TextWriter, ByVal dr As SqlDataReader, ByVal delimeter As String, ByVal quoteall As Boolean)
        For i As Integer = 0 To dr.FieldCount - 1
            WriteItem(stream, dr.GetName(i), quoteall)
            If i < dr.FieldCount - 1 Then
                stream.Write(delimeter)
            Else
                stream.Write(vbCr & vbLf)
            End If
        Next
    End Sub

    Public Shared Sub WriteRowToStream(ByVal stream As TextWriter, ByVal dr As SqlDataReader, ByVal delimeter As String, ByVal quoteall As Boolean)
        For i As Integer = 0 To dr.FieldCount - 1
            WriteItem(stream, dr.GetValue(i).ToString(), quoteall)
            If i < dr.FieldCount - 1 Then
                stream.Write(delimeter)
            Else
                stream.Write(vbCr & vbLf)
            End If
        Next
    End Sub

    Private Shared Sub WriteItem(ByVal stream As TextWriter, ByVal item As Object, ByVal quoteall As Boolean)
        If item Is Nothing Then
            Exit Sub
        End If
        Dim s As String = item.ToString()

        If (quoteall Or (s.IndexOfAny("""".ToCharArray()) > -1) Or (s.IndexOfAny(vbCr.ToCharArray()) > -1) Or (s.IndexOfAny(vbLf.ToCharArray()) > -1)) Then
            stream.Write("""" & s.Replace("""", """""") & """")
        Else
            stream.Write(s)
        End If
    End Sub
End Class