using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Data;
using System.Data.SqlClient;

public class CsvWriter
{
    public static string WriteToString(SqlDataReader dr, bool header, bool quoteall)
    {
        StringWriter writer = new StringWriter();
        if (header)
        {
            WriteHeadersToStream(writer, dr, quoteall);
        }
        while (dr.Read())
        {
            WriteRowToStream(writer, dr, quoteall);
        }
        return writer.ToString();
    }

    public static void WriteHeadersToStream(TextWriter stream, SqlDataReader dr, bool quoteall)
    {
        for (int i = 0; i < dr.FieldCount; i++)
        {
            WriteItem(stream, dr.GetName(i), quoteall);
            if (i < dr.FieldCount - 1)
                stream.Write(',');
            else
            {
                stream.Write("\r\n");
            }
        }
    }

    public static void WriteRowToStream(TextWriter stream, SqlDataReader dr, bool quoteall)
    {
        for (int i = 0; i < dr.FieldCount; i++)
        {
            WriteItem(stream, dr.GetString(i), quoteall);
            if (i < dr.FieldCount - 1)
                stream.Write(',');
            else
            {
                stream.Write("\r\n");
            }
        }
    }

    private static void WriteItem(TextWriter stream, object item, bool quoteall)
    {
        if (item == null)
            return;
        string s = item.ToString();
        if (quoteall || s.IndexOfAny("\",\x0A\x0D".ToCharArray()) > -1)
            stream.Write("\"" + s.Replace("\"", "\"\"") + "\"");
        else
            stream.Write(s);
    }
}