﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Data;
using System.Data.SqlClient;


// This is a modified version of Andreas Knab's CSVWriter that can be found
// on his blog at http://knab.ws/blog/index.php?/archives/3-CSV-file-parser-and-writer-in-C-Part-1.html
public class DelimitedFileWriter
{
    public static string WriteToString(SqlDataReader dr, string delimeter, bool header, bool quoteall)
    {
        StringWriter writer = new StringWriter();
        if (header)
        {
            WriteHeadersToStream(writer, dr, delimeter, quoteall);
        }
        while (dr.Read())
        {
            WriteRowToStream(writer, dr, delimeter, quoteall);
        }
        return writer.ToString();
    }

    public static void WriteHeadersToStream(TextWriter stream, SqlDataReader dr, string delimeter, bool quoteall)
    {
        for (int i = 0; i < dr.FieldCount; i++)
        {
            WriteItem(stream, dr.GetName(i), quoteall);
            if (i < dr.FieldCount - 1)
                stream.Write(delimeter);
            else
            {
                stream.Write("\r\n");
            }
        }
    }

    public static void WriteRowToStream(TextWriter stream, SqlDataReader dr, string delimeter, bool quoteall)
    {
        for (int i = 0; i < dr.FieldCount; i++)
        {
            WriteItem(stream, dr.GetValue(i).ToString(), quoteall);
            if (i < dr.FieldCount - 1)
                stream.Write(delimeter);
            else
            {
                stream.Write("\r\n");
            }
        }
    }

    private static void WriteItem(TextWriter stream, object item, bool quoteall)
    {
        if (item == null)
            return;
        string s = item.ToString();
        if (quoteall || s.IndexOfAny("\",\x0A\x0D".ToCharArray()) > -1)
            stream.Write("\"" + s.Replace("\"", "\"\"") + "\"");
        else
            stream.Write(s);
    }
}
