﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Data.SqlTypes;
using Microsoft.SqlServer.Server;
using System.IO;
using System.Text;


public partial class StoredProcedures
{
    [Microsoft.SqlServer.Server.SqlProcedure]
    public static void WriteResultsToCsvFile(string sqlcmd, string filename, bool includeheaders, bool quoteall, bool provideoutput)
    {
        // Used to track the number of rows written to the file.
        int rowcount = 0;
        // Default error handling to None for Error Message.
        Exception error = new Exception("None");
        //Open Try/Catch for Error Trapping
        try
        {
            // Create a SqlConnection object to the context connection
            using (SqlConnection conn = new SqlConnection("context connection=true;"))
            {
                // Create a SqlCommand object to pass the query into
                using (SqlCommand cmd = new SqlCommand(sqlcmd, conn))
                {
                    // Open the connection to the database
                    conn.Open();

                    // Retrieve a SqlDataReader to process the results of the SqlCommand
                    using (SqlDataReader dr = cmd.ExecuteReader())
                    {
                        // Create a TextWriter to stream the results to the file using Unicode Encoding
                        using (TextWriter stream = new StreamWriter(filename, false, Encoding.Unicode))
                        {
                            // Write the Header Row to the file if required.
                            if (includeheaders)
                            {
                                DelimitedFileWriter.WriteHeadersToStream(stream, dr, ",", quoteall);
                            }
                            // Loop over each row returned and write it to the file
                            while (dr.Read())
                            {
                                rowcount++;
                                DelimitedFileWriter.WriteRowToStream(stream, dr, ",", quoteall);
                            }
                            // Clean up by closing the open SqlDataReader and SqlConnection.
                            dr.Close();
                            conn.Close();

                            // Flush the stream buffer to the File and close the stream.
                            stream.Flush();
                            stream.Close();
                        }
                    }
                }
            }
        }
        // Catch block to handle Exceptions Raise
        catch (Exception ex)
        {
            error = ex; //SqlContext.Pipe.Send(ex.Message);
        }
        // End code to provide output including error messages if needed.
        finally
        {
            if (provideoutput)
            {
                SqlDataRecord sdr = new SqlDataRecord(
                    new SqlMetaData("RowsWritten", SqlDbType.Int),
                    new SqlMetaData("FileName", SqlDbType.NVarChar, 480),
                    new SqlMetaData("Errors", SqlDbType.NVarChar, 4000)
                    );

                sdr.SetValue(0, rowcount);
                sdr.SetValue(1, filename);
                sdr.SetValue(2, error.Message);
                SqlContext.Pipe.Send(sdr);
            }
        }
    }

}
