
CREATE PROCEDURE [dbo].[createReportExampleWithAS4] 
as
BEGIN
	declare @sesGuid uniqueidentifier
	set @sesGuid = newId()

	/* basic crosstable data */
	
	declare @mdx as nvarchar(4000)
	set @mdx = 'select [Measures].[Article Sold] on columns,
	non empty [Customer].[Customer].[Customer].members * [Month].[Month].[Month].members dimension Properties MEMBER_CAPTION, MEMBER_KEY on rows
	from [Article_Sales] '
	declare @columns as nvarchar(4000)
	set @columns = 'convert(int, convert(nvarchar(10), "[Customer].[Customer].[Customer].[MEMBER_KEY]")) as CustomerID, 
	convert(nvarchar(50), "[Customer].[Customer].[Customer].[MEMBER_CAPTION]") as CustomerName, 
	convert(int, convert(nvarchar(10), "[Month].[Month].[Month].[MEMBER_KEY]")) as MonthID, 
	convert(nvarchar(50), "[Month].[Month].[Month].[MEMBER_CAPTION]") as MonthName, 
	convert(int, convert(nvarchar(10), "[Measures].[Article Sold]")) as ArticlesSold'
	declare @sql as nvarchar (4000)
	set @sql = 'INSERT INTO ExampleReport (sessionGuid, rowSort, rowDesc, colSort, colDesc, value) select ''' + convert(nvarchar(100), @sesGuid) + ''', ' + @columns + ' from OPENQUERY(MyCube, ''' + @mdx + ''')'
	BEGIN TRY
	exec sp_executesql @sql
	END TRY
	BEGIN CATCH
		/* An error would arise if the MDX does not return any rows */
		/* In this case we do not need to do anything */
	END CATCH

	/* add total column */
	INSERT INTO ExampleReport (sessionGuid, rowSort, rowDesc, colSort, colDesc, value)
	SELECT @sesGuid, rowSort, rowDesc, 300000 as colSort, 'Total' as colDesc, sum(value)
	FROM ExampleReport WHERE sessionGuid = @sesGuid 
	Group by rowSort, rowDesc

	/* add target column */
	INSERT INTO ExampleReport (sessionguid, rowSort, rowDesc, colSort, colDesc, value)
	SELECT @SesGuid, ArticleSalesTarget.CustomerID, Customers.CustomerName, 300010, 'Target', Target
	FROM ArticleSalesTarget INNER JOIN Customers ON ArticleSalesTarget.CustomerID = Customers.CustomerID

	/* add delta column */
	INSERT INTO ExampleReport (sessionGuid, rowSort, rowDesc, colSort, colDesc, value)
	SELECT @sesGuid, isnull(total.rowSort, target.rowSort), isnull(total.rowDesc, target.rowDesc), 300020 as colSort, 'Delta' as colDesc, isnull(total.value, 0) - isnull(target.value, 0)
	FROM (SELECT * FROM ExampleReport where colSort = 300000 and SessionGuid = @sesGuid) as total
	FULL OUTER JOIN 
	(SELECT * FROM ExampleReport where colSort = 300010 and SessionGuid = @sesGuid) as target ON total.rowSort = target.rowSort

	/* add total row*/
	INSERT INTO ExampleReport (sessionGuid, rowSort, rowDesc, colSort, colDesc, value)
	SELECT @SesGuid, 1000 as rowSort, 'Total' as rowDesc, colSort, colDesc, sum(value)
	FROM ExampleReport where SessionGuid = @sesGuid
	Group by colSort, colDesc

    SELECT * FROM ExampleReport WHERE SessionGuid = @sesGuid

    DELETE FROM ExampleReport WHERE SessionGuid = @sesGuid
END
