using SpreadsheetGear;
using System;
using System.Data;
using System.Globalization;

namespace QueryToExcelSreadSheetGear
{
    public class ExcelMaker
    {
        public static bool ExportToExcel(DataSet ds, string mFile,  string title,ref string errorString)
        {
            bool retValue = true;

            try
            {
                SpreadsheetGear.IWorkbook workbook = SpreadsheetGear.Factory.GetWorkbook(CultureInfo.CurrentCulture);
                int i = 0;
                string[] tm = title.Split(';');
                int i1 = 0;
                string errorMessage = string.Empty;
                string dataSource = DataAccess.GetResult("SELECT @@servername + '(' + DB_NAME() + ')';");
                string userName = DataAccess.GetResult("SELECT SYSTEM_USER");

                int counter2 = ds.Tables.Count;
                foreach (DataTable t in ds.Tables)
                {

                    int startRow = 2;
                    SpreadsheetGear.IWorksheets worksheets = workbook.Worksheets;
                    worksheets.Add();
                    worksheets[i].Name = t.TableName;
                    SpreadsheetGear.IWorksheet workSheet = worksheets[i];

                    //make a decoration
                    try
                    {
                        workSheet.WindowInfo.ScrollRow = 0;
                        //
                        //try
                        //{
                        //    //workSheet.WindowInfo.SplitRows = startRow;
                        //    workSheet.WindowInfo.SplitRows = startRow;
                        //}
                        //catch ( Exception ex)
                        //{

                        //}
                        workSheet.WindowInfo.ScrollColumn = 0;
                        workSheet.WindowInfo.SplitColumns = 1;
                        workSheet.WindowInfo.FreezePanes = true;
                    }
                    catch ( Exception ex)
                    {
                        errorMessage = ex.Message;
                    }
                    //The title 
                    string localTitle = tm.Length > i1 ? tm[i1] : "unknown";
                    SpreadsheetGear.IRange rangeTitle = workSheet.Cells[0, 0, 0, t.Columns.Count - 1];
                    ApplyFirstRow(rangeTitle, localTitle);
                    SpreadsheetGear.IRange rangeSecondRow = workSheet.Cells[1, 0, 1, t.Columns.Count - 1];
                    ApplySecondRow(rangeSecondRow, mFile, dataSource, userName);





                    SpreadsheetGear.IRange range2 = workSheet.Cells[startRow, 0, startRow, t.Columns.Count - 1];
                    //range2.AutoFilter();
                    int endIndex = t.Rows.Count + startRow + 1;
                    int counter = 0;


                    IRange header = workSheet.Cells[startRow, 0, startRow, t.Columns.Count-1];
                    header.Interior.ColorIndex = 34;

                    for (int j = 0; j <= t.Columns.Count - 1; j++)
                    {

                        workSheet.Cells[startRow, counter].NumberFormat = "@";

                        workSheet.Cells[startRow, counter].Value = t.Columns[j].ColumnName.Trim();
                        //try
                        //{
                        //    workSheet.Cells[startRow, counter].EntireColumn.AutoFit();
                        //}
                        //catch (Exception ex)
                        //{

                        //}
                        //workSheet.Cells[startRow, counter].AutoFilter(1, Type.Missing, AutoFilterOperator.And, Type.Missing, true);



                        //Napravi output format
                        if (((DataColumn)t.Columns[j]).DataType.Name.ToUpper().Contains(cDATE))
                        {
                            workSheet.Cells[startRow + 1, counter, endIndex, counter].NumberFormat = CultureInfo.CurrentCulture.DateTimeFormat.ShortDatePattern;
                            

                        }
                        else if (((DataColumn)t.Columns[j]).DataType.Name.ToUpper().Contains(cDECIMAL) || ((DataColumn)t.Columns[j]).DataType.Name.ToUpper().Contains(cINT))
                        {
                            if (((DataColumn)t.Columns[j]).DataType.Name.ToUpper().Contains(cDECIMAL))
                            {
                                workSheet.Cells[startRow + 1, counter, endIndex, counter].NumberFormat = "#,##0.00";
                            }
                            else
                            {
                                workSheet.Cells[startRow + 1, counter, endIndex, counter].NumberFormat = "#,##0";
                            }
                        }
                        else
                        {
                            workSheet.Cells[startRow + 1, counter, endIndex, counter].NumberFormat = "@";
                        }
                        counter += 1;
                    }

                    i += 1;


                    //Sadraj
                    for (int j = 0; j <= t.Rows.Count - 1; j++)
                    {
                        DataRow currRow = t.Rows[j];
                        counter = 0;
                        //
                        SpreadsheetGear.IRange rangeRow = workSheet.Cells[j + startRow + 1, 0, j + startRow + 1, t.Columns.Count - 1];
                        //rangeRow.AutoFit();

                        //SpreadsheetGear.IInterior interiorRowColor = rangeRow.Interior;
                        //interiorRowColor.Color = System.Drawing.Color.WhiteSmoke;


                        //

                        for (int k = 0; k <= t.Columns.Count - 1; k++)
                        {

                            if (((DataColumn)t.Columns[k]).DataType.Name.ToUpper().Contains(cDATE))
                            {
                                workSheet.Cells[j + startRow + 1, counter].Value = object.ReferenceEquals(t.Rows[j][k], DBNull.Value) ?
                                    string.Empty : Convert.ToDateTime(t.Rows[j][k]).Hour.Equals(0) ?
                                    Convert.ToDateTime(t.Rows[j][k]).ToString(CultureInfo.CurrentCulture.DateTimeFormat.ShortDatePattern) :
                                    Convert.ToDateTime(t.Rows[j][k]).ToString(System.Globalization.CultureInfo.CurrentCulture.DateTimeFormat.ShortDatePattern + " " + System.Globalization.CultureInfo.CurrentCulture.DateTimeFormat.LongTimePattern);
                            }
                            else if (((DataColumn)t.Columns[k]).DataType.Name.ToUpper().Contains(cBOOL))
                            {
                                if (!object.ReferenceEquals(t.Rows[j][k], DBNull.Value))
                                {
                                    workSheet.Cells[j + startRow + 1, counter].Value = Convert.ToBoolean(t.Rows[j][k]) == true ? "Yes" : "No";
                                }
                                else
                                {
                                    workSheet.Cells[j + startRow + 1, counter].Value = "NULL";
                                }
                            }
                            else if (((DataColumn)t.Columns[k]).DataType.Name.ToUpper().Contains(cDECIMAL) || ((DataColumn)t.Columns[k]).DataType.Name.ToUpper().Contains(cINT))
                            {
                                if (!object.ReferenceEquals(t.Rows[j][k], DBNull.Value))
                                {
                                    if (((DataColumn)t.Columns[k]).DataType.Name.ToUpper().Contains(cDECIMAL))
                                    {
                                        workSheet.Cells[j + startRow + 1, counter].Value = Convert.ToDecimal(t.Rows[j][k]);
                                    }
                                    else
                                    {
                                        workSheet.Cells[j + startRow + 1, counter].Value = Convert.ToInt32(t.Rows[j][k]);
                                    }
                                }
                            }
                            else
                            {
                                workSheet.Cells[j + startRow + 1, counter].Value = t.Rows[j][k].ToString().Trim();
                            }
                            counter += 1;
                        }
                    }
                    i1++;
                    workSheet.Cells[startRow, 0].EntireRow.AutoFilter(0, Type.Missing, AutoFilterOperator.And, Type.Missing, true);
                    for (int j = 0; j <= t.Columns.Count - 1; j++)
                    {
                        workSheet.Cells[startRow, j].ColumnWidth = workSheet.Cells[startRow, j].ColumnWidth * 2;
                    }
                            
                    

                }

                workbook.Sheets[0].Select();
                workbook.Sheets[workbook.Sheets.Count-1].Delete();
                workbook.FullName = mFile;
                
                workbook.Save();
                //workbook.SaveAs(mFile, SpreadsheetGear.FileFormat.OpenXMLWorkbook);


            }
            catch (Exception ex)
            {
                retValue = false;
                errorString = ex.Message;
            }
            return retValue;


        }

        private const string cDECIMAL = "DECIMAL";
        private const string cINT = "INT";
        private const string cDATE = "DATE";
        private const string cBOOL = "BOOL";

        private static void ApplyFirstRow(IRange newRng, string title)
        {
            newRng.Merge();
            newRng.HorizontalAlignment = HAlign.Center;
            newRng.VerticalAlignment = VAlign.Center;
            newRng.Font.Bold = true;
            newRng.Font.ColorIndex = 32;
            newRng.Font.Size = 14;
            newRng.Value = title;
            IBorders border = newRng.Borders;
            border.LineStyle = LineStyle.Continous;
            border.Weight = BorderWeight.Thick;
            border.ColorIndex = 31;
        }
        private static void ApplySecondRow(IRange newRng, string mFile, string dataSource, string userName)
        {
            newRng.Merge();
            newRng.HorizontalAlignment = HAlign.Center;
            newRng.VerticalAlignment = VAlign.Center;
            newRng.Font.ColorIndex = 15;
            newRng.Value = "created by the user : " + userName + ";on the host : " +
                Environment.MachineName + "; processing date : " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss") + ";file name : " + mFile + ";"
                + "data source : " + dataSource;
        }



    }

}
