﻿/*
 Pre-Deployment Script Template							
--------------------------------------------------------------------------------------
 This file contains SQL statements that will be executed before the build script.	
 Use SQLCMD syntax to include a file in the pre-deployment script.			
 Example:      :r .\myfile.sql								
 Use SQLCMD syntax to reference a variable in the pre-deployment script.		
 Example:      :setvar TableName MyTable							
               SELECT * FROM [$(TableName)]					
--------------------------------------------------------------------------------------
*/
--Create schema if not exists

IF NOT EXISTS (
	SELECT schema_name
	FROM information_schema.schemata
	WHERE schema_name = 'EXCEL' )

BEGIN
	EXEC sp_executesql N'CREATE SCHEMA EXCEL'
END

--Create asymetric key 
IF ( SELECT
		Count(*)
	FROM master.sys.asymmetric_keys
	WHERE name LIKE 'keyQueryToExcelSSG%')
= 0
BEGIN
EXEC sp_executesql N'USE MASTER;
CREATE ASYMMETRIC KEY [keyQueryToExcelSSG]
FROM FILE = ''D:\VS2017_PROJECTS\QueryToExcelSpreadSheetGear\QueryToExcelSpreadSheetGear\QeuryToExcelSSG.snk''
ENCRYPTION BY PASSWORD = ''Sql@1Central#'''
END

IF NOT EXISTS (SELECT loginname FROM master.dbo.syslogins 
    WHERE name =  'loginQueryToExcelSSG' )
BEGIN
DECLARE @sqlStatement as nvarchar(1000)
Select @SqlStatement = 'CREATE LOGIN [loginQueryToExcelSSG] 
FROM ASYMMETRIC KEY keyQueryToExcelSSG'

EXEC sp_executesql @SqlStatement

EXEC sp_executesql N'USE MASTER;
GRANT UNSAFE ASSEMBLY TO [loginQueryToExcelSSG];'
END

IF NOT EXISTS(SELECT name FROM sys.database_principals WHERE name = 'UserQueryToExcelSSG')
BEGIN 
CREATE USER [userQueryToExcelSSG] FOR LOGIN [loginQueryToExcelSSG] 
END
--ALTER AUTHORIZATION ON ASSEMBLY::[SpreadsheetGear2012.Core] TO [dbo]

