﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using QRCoder;

namespace QRCoderImageToByteArray
{
    public class QRCoderImageToByteArrayClass
    {
        public static byte[] renderBmpToByteArray(string inputString)
        {
            using (var stream = new System.IO.MemoryStream())
            {
                QRCodeGenerator qrGenerator = new QRCodeGenerator();
                QRCodeData qrCodeData = qrGenerator.CreateQrCode(inputString, QRCodeGenerator.ECCLevel.Q);

                BitmapByteQRCode qrCode = new BitmapByteQRCode(qrCodeData);
                byte[] qrCodeAsBitmapByteArr = qrCode.GetGraphic(20);
                return qrCodeAsBitmapByteArr;
            }
        }
        public static byte[] renderPngToByteArray(string inputString)
        {
            using (var stream = new System.IO.MemoryStream())
            {
                QRCodeGenerator qrGenerator = new QRCodeGenerator();
                QRCodeData qrCodeData = qrGenerator.CreateQrCode(inputString, QRCodeGenerator.ECCLevel.Q);

                PngByteQRCode qrCode = new PngByteQRCode(qrCodeData);
                byte[] qrCodeAsPngByteArr = qrCode.GetGraphic(20);
                return qrCodeAsPngByteArr;
            }
        }
    }
}
