drop table [dbo].[order_items];
drop table [dbo].[orders];
drop SEQUENCE [dbo].[invoice];
drop procedure dbo.create_some_order;
go

create table dbo.orders(
id uniqueidentifier NOT NULL DEFAULT newsequentialid(),
invoice int NOT NULL,
some_data char(200) NOT NULL,
some_vardata varchar(200),
order_date datetime,
constraint PK_orders PRIMARY KEY CLUSTERED (id)
);

create table dbo.order_items(
id uniqueidentifier NOT NULL DEFAULT newsequentialid(),
order_id uniqueidentifier NOT NULL,
some_data char(50) NOT NULL,
some_vardata varchar(100),
constraint PK_order_items PRIMARY KEY CLUSTERED (id),
constraint FK_order_items_orders FOREIGN KEY (order_id) references dbo.orders(id)
);

CREATE SEQUENCE [dbo].[invoice] AS [int] start with 1;

go

create procedure dbo.create_some_order
as

set nocount on;

declare @tmp as table (id uniqueidentifier);

insert dbo.orders(invoice, some_data, some_vardata, order_date)
OUTPUT inserted.id into @tmp
	values(NEXT VALUE FOR dbo.invoice ,'', replicate('a',abs(checksum(NEWID()))%200),
	 DATEADD(MINUTE, -1*abs(checksum(NEWID())%20000), getdate()));

with c(i) as 
(select 1
union all select i+1 from c where i<abs(checksum(NEWID()))%10
)
insert dbo.order_items(order_id, some_data, some_vardata)
select id, '', replicate('b',abs(checksum(NEWID()))%100)
from c cross join @tmp;

go