﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Data;
using System.Xml;

namespace PhoneticsTests
{
    /// <summary>
    /// Summary description for SoundexTests
    /// </summary>
    [TestClass]
    public class SoundexTests
    {
        public SoundexTests()
        {
            //
            // TODO: Add constructor logic here
            //
        }

        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        //
        // You can use the following additional attributes as you write your tests:
        //
        // Use ClassInitialize to run code before running the first test in the class
        // [ClassInitialize()]
        // public static void MyClassInitialize(TestContext testContext) { }
        //
        // Use ClassCleanup to run code after all tests in a class have run
        // [ClassCleanup()]
        // public static void MyClassCleanup() { }
        //
        // Use TestInitialize to run code before running each test 
        // [TestInitialize()]
        // public void MyTestInitialize() { }
        //
        // Use TestCleanup to run code after each test has run
        // [TestCleanup()]
        // public void MyTestCleanup() { }
        //
        #endregion

        #region SoundexLong() tests
        [TestMethod]
        public void StartUpTest()
        {
            Assert.AreEqual("D", Phonetics.SoundexLong("D"));
        }
        [TestMethod]
        public void ZeroLengthStringTest()
        {
            Assert.AreEqual("", Phonetics.SoundexLong(""));
        }
        [TestMethod]
        public void NullStringTest()
        {
            Assert.AreEqual("", Phonetics.SoundexLong(null));
        }
        [TestMethod]
        public void SoundexCharTest()
        {
            Assert.AreEqual("D1", Phonetics.SoundexLong("Dave"));
        }
        [TestMethod]
        public void LetterOneNotAlphaTest()
        {
            Assert.AreEqual("D1", Phonetics.SoundexLong("12Dave"));
        }
        [TestMethod]
        public void TwoWordTest()
        {
            Assert.AreEqual("D1 P4", Phonetics.SoundexLong("Dave Poole"));
        }
        [TestMethod]
        public void LlangollenTest()
        {
            Assert.AreEqual("L5245", Phonetics.SoundexLong("llangollen"));
        }
        [TestMethod]
        public void LlangollenHeritageRailwayTest()
        {
            Assert.AreEqual("L5245 H632 R4", Phonetics.SoundexLong("llangollen heritage railway"));
        }
        [TestMethod]
        public void AllAlphabeticsTest()
        {
            int TotalLength = 0;
            for (int i = Convert.ToInt32('A'); i <= Convert.ToInt32('Z'); i++)
            {
                TotalLength += Phonetics.SoundexLong("A" + Convert.ToChar(i)).ToString().Length;
            }
            Assert.AreEqual(44, TotalLength);
        }
        #endregion
    }
}
