﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Data.SqlTypes;
using Microsoft.SqlServer.Server;

public partial class Phonetics
{
    [Microsoft.SqlServer.Server.SqlFunction]
    public static SqlString SoundexLong(string InputString)
    {
        if (String.IsNullOrEmpty(InputString))
        {
            InputString = " ";
        }
        char[] inputArray = InputString.ToUpper().ToCharArray();
        int currentCharacterPosition = 0;
        int validCharacterPosition = 0;




        if (!IsLetter(inputArray[0]))
        {
            inputArray[0] = ' ';
        }

        currentCharacterPosition++;

        while (currentCharacterPosition < inputArray.Length)
        {

            if (inputArray[validCharacterPosition] == ' ')
            {
                if (IsLetter(inputArray[currentCharacterPosition]))
                {
                    inputArray[++validCharacterPosition] = inputArray[currentCharacterPosition];
                }
            }
            else
            {
                if (!((inputArray[validCharacterPosition] == inputArray[currentCharacterPosition]) ||
                    inputArray[validCharacterPosition] == SoundexChar(inputArray[currentCharacterPosition])))
                {
                    // Only increment the validCharacterPosition if it is not a vowel
                    if (inputArray[validCharacterPosition] != '0')
                    {
                        validCharacterPosition++;
                    }
                    inputArray[validCharacterPosition] = SoundexChar(inputArray[currentCharacterPosition]);
                }
            }
            currentCharacterPosition++;
        }

        //  Blank out any trailing vowel
        if (inputArray[validCharacterPosition] == '0')
        {
            inputArray[validCharacterPosition] = ' ';
        }

        validCharacterPosition++;

        while (validCharacterPosition < currentCharacterPosition)
        {
            inputArray[validCharacterPosition++] = ' ';
        }

        return new string(inputArray).Trim();
    }

    /// <summary>
    /// Determines whether a character passed to the function is an alphabetic character or not.
    /// </summary>
    /// <param name="a">The character in question</param>
    /// <returns>TRUE if an alphabetic character, FALSE otherwise.</returns>
    private static bool IsLetter(char a)
    {
        bool returnValue = false;
        int i = Convert.ToInt32(a);
        if ((i >= Convert.ToInt32('A') && i <= Convert.ToInt32('Z')))
        {
            returnValue = true;
        }

        return returnValue;
    }

    /// <summary>
    /// For a given character return the raw SOUNDEX value.  If the argument is not a letter then return a space.
    /// </summary>
    /// <param name="a">The character to be evalutated.</param>
    /// <returns></returns>
    private static Char SoundexChar(Char a)
    {

        switch (a)
        {
            case 'A':
            case 'E':
            case 'I':
            case 'O':
            case 'U':
            case 'W':
            case 'H':
            case 'Y':
                a = '0';
                break;
            case 'B':
            case 'F':
            case 'P':
            case 'V':
                a = '1';
                break;
            case 'C':
            case 'G':
            case 'J':
            case 'K':
            case 'Q':
            case 'S':
            case 'X':
            case 'Z':
                a = '2';
                break;
            case 'D':
            case 'T':
                a = '3';
                break;
            case 'L':
                a = '4';
                break;
            case 'N':
            case 'M':
                a = '5';
                break;
            case 'R':
                a = '6';
                break;
            default:
                a = ' ';
                break;
        }

        return a;
    }
    /// <summary>
    /// For a given character return the raw SOUNDEX value.  If the argument is not a letter then return a space.
    /// </summary>
    /// <param name="a">The character to be evalutated.</param>
    /// <returns></returns>
    private static void ReplaceSoundexChar(ref Char a)
    {

        switch (a)
        {
            case 'A':
            case 'E':
            case 'I':
            case 'O':
            case 'U':
            case 'W':
            case 'H':
            case 'Y':
                a = '0';
                break;
            case 'B':
            case 'F':
            case 'P':
            case 'V':
                a = '1';
                break;
            case 'C':
            case 'G':
            case 'J':
            case 'K':
            case 'Q':
            case 'S':
            case 'X':
            case 'Z':
                a = '2';
                break;
            case 'D':
            case 'T':
                a = '3';
                break;
            case 'L':
                a = '4';
                break;
            case 'N':
            case 'M':
                a = '5';
                break;
            case 'R':
                a = '6';
                break;
            default:
                a = ' ';
                break;
        }


    }


    [Microsoft.SqlServer.Server.SqlFunction]
    public static SqlString SoundexOptimise(string InputString)
    {
        if (String.IsNullOrEmpty(InputString))
        {
            InputString = " ";
        }
        char[] inputArray = InputString.ToUpper().ToCharArray();
        int currentCharacterPosition = 0;
        int validCharacterPosition = 0;




        if (!IsLetter(inputArray[0]))
        {
            inputArray[0] = ' ';
        }

        currentCharacterPosition++;

        while (currentCharacterPosition < inputArray.Length)
        {

            if ((inputArray[currentCharacterPosition-1] == ' ')){
                if (!IsLetter(inputArray[currentCharacterPosition]))
                {
                    ReplaceSoundexChar(ref inputArray[currentCharacterPosition]);
                }
            }
            else
            {
                if (inputArray[currentCharacterPosition - 1] != inputArray[currentCharacterPosition])
                {

                    ReplaceSoundexChar(ref inputArray[currentCharacterPosition]);
                }
           }
            currentCharacterPosition++;
        }

        currentCharacterPosition=1;

        while (currentCharacterPosition < inputArray.Length)
        {
            if(inputArray[validCharacterPosition]!=inputArray[currentCharacterPosition] && inputArray[currentCharacterPosition]!='0')
            {
                inputArray[++validCharacterPosition]=inputArray[currentCharacterPosition];
            }
            
            currentCharacterPosition++;
        }

        validCharacterPosition++;

        while (validCharacterPosition < currentCharacterPosition)
        {
            inputArray[validCharacterPosition++] = ' ';
        }

        return new string(inputArray).Trim();
    }

}


