USE [tempdb]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[tempWorkLoadLocalMethod]') AND type in (N'U'))
BEGIN
     DROP TABLE [dbo].[tempWorkLoadLocalMethod]
END
GO

CREATE TABLE [dbo].[tempWorkLoadLocalMethod](
     [ClientId] [int] NOT NULL,
     [ProcessId] [int] NULL,
     [ProcessDt] [datetime] NULL,
     CONSTRAINT [PK_tempWorkLoadLocalMethod] PRIMARY KEY CLUSTERED ( [ClientId] ASC )
)
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[tempWorkLoadParentMultiChildMethod]') AND type in (N'U'))
BEGIN
     DROP TABLE [dbo].[tempWorkLoadParentMultiChildMethod]
END
GO

CREATE TABLE [dbo].[tempWorkLoadParentMultiChildMethod](
     [ClientId] [int] NOT NULL,
     [ProcessId] [int] NULL,
     [ProcessDt] [datetime] NULL,
     CONSTRAINT [PK_tempWorkLoadParentMultiChildMethod] PRIMARY KEY CLUSTERED ( [ClientId] ASC )
)
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[tempWorkLoadParentSingleChildMethod]') AND type in (N'U'))
BEGIN
     DROP TABLE [dbo].[tempWorkLoadParentSingleChildMethod]
END
GO

CREATE TABLE [dbo].[tempWorkLoadParentSingleChildMethod](
     [ClientId] [int] NOT NULL,
     [LockStartDt] [datetime] NULL,
     [ProcessDt] [datetime] NULL,
     CONSTRAINT [PK_tempWorkLoadParentSingleChildMethod] PRIMARY KEY CLUSTERED ( [ClientId] ASC )
)
GO

INSERT tempdb.dbo.tempWorkLoadLocalMethod 
     ( ClientId )
SELECT RAND() * 10000
GO 55

INSERT tempdb.dbo.tempWorkLoadParentMultiChildMethod 
     ( ClientId )
SELECT ClientId
FROM   tempdb.dbo.tempWorkLoadLocalMethod 
GO

INSERT tempdb.dbo.tempWorkLoadParentSingleChildMethod 
     ( ClientId )
SELECT ClientId
FROM   tempdb.dbo.tempWorkLoadLocalMethod 
GO

SELECT tempWorkLoadLocalMethod_Count = COUNT(*) FROM dbo.tempWorkLoadLocalMethod 
GO

PRINT '-----------------------------------------------------------------------------------'
PRINT 'You may see:'
PRINT '** An error was encountered during execution of batch. Continuing.'
PRINT ''
PRINT 'This can be ignored, it is likely due to a Primary Key violation during data load.'
PRINT '-----------------------------------------------------------------------------------'
GO
