--create the table

use DBA_Reports
go
CREATE TABLE [dbo].[ServerList](
 [Server] [varchar](128) NOT NULL,
 [Server_email] [varchar](50) NULL,
 CONSTRAINT [PK_ServerList] PRIMARY KEY CLUSTERED 
( [Server] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 99) ON [PRIMARY]) 
ON [PRIMARY]


---create the get servers job
USE [msdb]
GO

BEGIN TRANSACTION
DECLARE @ReturnCode INT
SELECT @ReturnCode = 0
IF NOT EXISTS (SELECT name FROM msdb.dbo.syscategories WHERE name=N'DBA Monitoring' AND category_class=1)
BEGIN
EXEC @ReturnCode = msdb.dbo.sp_add_category @class=N'JOB', @type=N'LOCAL', @name=N'DBA Monitoring'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
END
DECLARE @jobId BINARY(16)
EXEC @ReturnCode = msdb.dbo.sp_add_job @job_name=N'DBA_Reports - Get New Servers', 
 @enabled=1, 
 @notify_level_eventlog=2, 
 @notify_level_email=2, 
 @notify_level_netsend=0, 
 @notify_level_page=0, 
 @delete_level=0, 
 @description=N'Gets the new servers that are not in the table and sends out an email for new servers', 
 @category_name=N'DBA Monitoring', 
 @owner_login_name=N'sa', 
 @notify_email_operator_name=N'<ADD YOUR INFO HERE>', @job_id = @jobId OUTPUT
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobstep @job_id=@jobId, @step_name=N'step1', 
 @step_id=1, 
 @cmdexec_success_code=0, 
 @on_success_action=1, 
 @on_success_step_id=0, 
 @on_fail_action=2, 
 @on_fail_step_id=0, 
 @retry_attempts=0, 
 @retry_interval=0, 
 @os_run_priority=0, @subsystem=N'TSQL', 
 @command=N'USE [DBA_Reports]
GO
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[ServerList_Stage]'') AND type in (N''U''))
DROP TABLE [dbo].[ServerList_Stage]
GO
USE [DBA_Reports]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[ServerList_Stage](
 [Server] [varchar](128) NOT NULL,

 CONSTRAINT [PK_ServerList_Stage] PRIMARY KEY CLUSTERED 
(
 [Server] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 99) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
-- Load table with server names
-- This will only work if XP_CMDSHELL is Enabled
USE DBA_Reports
GO
Create table #Server ( [Server] [varchar](128) )
Insert Into #Server 
 Exec xp_cmdshell ''sqlcmd /Lc'' 
Insert Into ServerList_Stage ([Server])
 select [Server] from #Server where [Server] is not null
DROP Table #Server
GO
--Send email to with new servers found
SET nocount ON
--
DECLARE @Subject VARCHAR (100)
SET @Subject=''SQL Server - New Servers Found Today''
DECLARE @Count AS INT
SELECT @Count=COUNT(*) FROM DBA_Reports.dbo.ServerList_Stage where [Server] not in (select [Server] from [ServerList])
PRINT @Count
IF @Count > 0
BEGIN
DECLARE @tableHTML NVARCHAR(MAX) ;
SET @tableHTML =
N''<table border="1">'' +
N''<tr>'' +
N''<th>Server</th>'' +
N''</tr>'' +
CAST ( ( SELECT td=[server],''''
FROM [ServerList_Stage]
where [Server] not in (select [Server] from [ServerList])
FOR XML PATH(''tr''), TYPE
) AS NVARCHAR(MAX) ) +
N''</table>'' ;
EXEC msdb.dbo.sp_send_dbmail
@profile_name = ''<ADD YOUR INFO HERE>'',
@recipients = ''<ADD YOUR INFO HERE>'',
@subject = @Subject,
@body = @tableHTML,
@body_format = ''HTML'' ;
END
INSERT INTO [DBA_Reports].[dbo].[ServerList]
 ([Server])
 SELECT [Server] 
 FROM [DBA_Reports].[dbo].[ServerList_Stage]
 where [Server] not in (select [Server] from [DBA_Reports].[dbo].[ServerList])
GO
', 
 @database_name=N'DBA_Reports', 
 @flags=0
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_update_job @job_id = @jobId, @start_step_id = 1
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobschedule @job_id=@jobId, @name=N'Daily 3 times', 
 @enabled=1, 
 @freq_type=4, 
 @freq_interval=1, 
 @freq_subday_type=8, 
 @freq_subday_interval=3, 
 @freq_relative_interval=0, 
 @freq_recurrence_factor=0, 
 @active_start_date=20110512, 
 @active_end_date=99991231, 
 @active_start_time=63000, 
 @active_end_time=220000 

IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
EXEC @ReturnCode = msdb.dbo.sp_add_jobserver @job_id = @jobId, @server_name = N'(local)'
IF (@@ERROR <> 0 OR @ReturnCode <> 0) GOTO QuitWithRollback
COMMIT TRANSACTION
GOTO EndSave
QuitWithRollback:
 IF (@@TRANCOUNT > 0) ROLLBACK TRANSACTION
EndSave:
GO


--create the stored procedure
USE [DBA_Reports]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- ======================================================================
-- Author: Kimberly Killian
-- Create date: 7/29/11
-- Description:	Push scripts to servers
=========================================================================
CREATE PROCEDURE [dbo].[push_changes_to_servers]
AS

 SET NOCOUNT ON;

 Declare	@DatabaseName varchar(128), 
			@ServerName varchar(128),
			@cmdmail	varchar(50)			
 
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ServerList_update]') AND type in (N'U'))
DROP TABLE [dbo].[ServerList_update]

CREATE TABLE [dbo].[ ServerList_update](
	[Server] [varchar](128) NOT NULL,
	 CONSTRAINT [PK_ServerList_update] PRIMARY KEY CLUSTERED 
(	[Server] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 99) ON [PRIMARY]
) ON [PRIMARY]

-- Load table with server names
-- This will only work if XP_CMDSHELL is Enabled

Create table #Server ( [Server] [varchar](128) )
Insert Into #Server  
    Exec xp_cmdshell 'sqlcmd /Lc' 
Insert Into ServerList_update  ([Server])
    select [Server] from #Server where SERVER in (select [SERVER] from dbo.ServerList)
DROP Table #Server 

-- Loop on Server list and run the update

	Declare SrvCurs CURSOR FORWARD_ONLY FOR
	select Server from dbo.ServerList_update
	 
	open SrvCurs
	fetch SrvCurs into @ServerName
	 
	while @@FETCH_STATUS = 0
	BEGIN
	
--send warning email to remote servers
 Declare @email varchar(25)			
 select @email = Server_email from dbo.SSIS_ServerList where Server = @ServerName

--send the email
 Declare @body varchar (1000)
 SET @body = '<html><body><font face=verdana size=2>                                                             
  <p><strong>Database Maintenance has started on ' + @ServerName + '.  Please do not disconnect your machine from the network.  This may take some time. </strong><br>
  An email will be sent upon completion.</p>
  <p><i>We apologize for any inconvenience this may cause.  Please contact me if you experience any issues or need to disconnect.</i></p>                                
  <p>Thank you,<br><br>                               
  <strong><Add your name here>  <br>                              
  <add your title><br> 
  <Add your company here> </strong><br>
  <add your phone # here><br/>                                
  <add your email here>
  </p>                                
  </body></html>'
 
   --send warning email do not remove from network			        
	
	EXEC msdb.dbo.sp_send_dbmail
	@profile_name	= '<add your profile here>',
	@recipients		=@email,
	@copy_recipients = '<add your email here>',
	@subject		='AUTOMATED SEND: Database Maintenance Started Please Do not disconnect',
	@body			=@body,
	@body_format	='HTML';		
                    	
 --Set the query to be used to update each server
 Declare @query varchar(max)
 SET @query = '<put your query here>'   

--Run the query on each server  
 Declare @OpenServerRunQuery varchar(8000)
 SET @OpenServerRunQuery =  'sqlcmd -E -S "' + @ServerName + '" -q "' + @query + '"'
 
 --exec queries for each server
 
 exec master..xp_cmdshell @OpenServerRunQuery
 
 --send completion email to remote servers
  SET @body = '<html><body><font face=verdana size=2>                                                             
  <p><strong>Database Maintenance has completed on ' + @ServerName + '. </strong><br></p>
  <p>Thank you,<br><br>                               
  <strong><Add your name here>  <br>                              
  <add your title><br> 
  <Add your company here> </strong><br>
  <add your phone # here><br/>                                
  <add your email here>
  </p>                              
  </body></html>'
 
 --send all clear email 		        	
	EXEC msdb.dbo.sp_send_dbmail
	@profile_name	= '<add your profile here>',
	@recipients		=@email,
	@copy_recipients = '<add your email here>',
	@subject		='AUTOMATED SEND: Database Maintenance has completed',
	@body			=@body,
	@body_format	='HTML';		
 
fetch SrvCurs into @ServerName

END

--Send email of who was updated
SET nocount ON
--
DECLARE @Subject VARCHAR (100)
SET @Subject='SQL Server - Servers Updated Today'

DECLARE @Count AS INT
SELECT @Count=COUNT(*) FROM ServerList_Update

PRINT @Count

IF @Count > 0
BEGIN

DECLARE @tableHTML NVARCHAR(MAX) ;
SET @tableHTML =
N'<table border="1">' +
N'<tr>' +
N'<th>Server</th>' +
N'</tr>' +
CAST ( ( SELECT td=[server],''
FROM [ServerList_Update]
ORDER BY Server
FOR XML PATH('tr'), TYPE
) AS NVARCHAR(MAX) ) +
'<br><br><hr>
Patch installed: <br>' + @query + '<br><br><hr>' +
N'</table>' ;

EXEC msdb.dbo.sp_send_dbmail
@profile_name = '<add your profile here>',
@recipients = '<Add your email here>',
@subject = @Subject,
@body = @tableHTML,
@body_format = 'HTML'; 

END

--clean up
close SrvCurs
deallocate SrvCurs

GO



