USE [MapDemo]
GO

IF OBJECT_ID ( 'usp_GetErrorInfo', 'P' ) IS NOT NULL 
    DROP PROCEDURE usp_GetErrorInfo;
GO

-- Create procedure to retrieve error information.
CREATE PROCEDURE usp_GetErrorInfo
AS
SELECT
    ERROR_NUMBER() AS ErrorNumber
    ,ERROR_SEVERITY() AS ErrorSeverity
    ,ERROR_STATE() AS ErrorState
    ,ERROR_PROCEDURE() AS ErrorProcedure
    ,ERROR_LINE() AS ErrorLine
    ,ERROR_MESSAGE() AS ErrorMessage;
GO

IF EXISTS(
SELECT * 
FROM [tempdb].sys.tables
WHERE Name LIKE '#CalloutBox%')
	DROP TABLE #CalloutBox

SELECT  'RI' AS StateUSPS, 1 AS Ordinal, -71.5 AS Cx, 41.5 AS Cy, -67 AS Lon, 42.5 AS Lat, 'WS' AS Ori INTO #CalloutBox
INSERT  #CalloutBox SELECT 'CT', 2, -72.7, 41.6, -68, 41, 'WN'
INSERT  #CalloutBox SELECT 'NJ', 3, -74.5, 40.2, -72, 37.5, 'WN'
INSERT  #CalloutBox SELECT 'DE', 4, -75.4, 39, -72, 34, 'WN'
INSERT  #CalloutBox SELECT 'FL', 5, -82, 29.5, -78, 30.5, 'WS'
INSERT  #CalloutBox SELECT 'VI', 6, -67.7, 22.2, -71, 26, 'SE'

DECLARE @iCount INT
SET @iCount = 1

BEGIN TRY
WHILE @iCount < 8
BEGIN
INSERT  dbo.[StateMap]
SELECT  S.StateFP,
        S.StateUSPS,
        S.StateName,
        dbo.MapCalloutBox(c.Cx, c.Cy, c.Lon, c.Lat, 6, 2, c.Ori) AS BoundaryGeog,
        3 AS MapSetId
FROM    dbo.[StateMap] S
INNER JOIN #CalloutBox c ON c.Ordinal = @iCount 
AND c.StateUSPS = S.StateUSPS

SET @iCount = @iCount + 1
END
END TRY
BEGIN CATCH
EXECUTE usp_GetErrorInfo
END CATCH

SELECT * FROM StateMap 
