USE [MapDemo]
GO

IF OBJECT_ID (N'dbo.MapCalloutBox', N'FN') IS NOT NULL
    DROP FUNCTION dbo.MapCalloutBox;
GO

CREATE FUNCTION dbo.MapCalloutBox(
@centerX FLOAT,
@centerY FLOAT,
@startptX FLOAT,
@startptY FLOAT,
@width FLOAT,
@height FLOAT,
@orientation CHAR(2))
RETURNS GEOGRAPHY
WITH EXECUTE AS CALLER
AS
BEGIN
DECLARE @wktpts VARCHAR(1024)
DECLARE @ltbrk CHAR(9)
DECLARE @rtbrk CHAR(2)
DECLARE @space CHAR(1)
DECLARE @comma CHAR(1)
DECLARE @ratio FLOAT

SET @ltbrk = 'POLYGON((';
SET @rtbrk = '))';
SET @space = ' ';
SET @comma = ',';
SET @ratio = 0.2;

SET @wktpts = 
CASE 
WHEN @orientation = 'NW' THEN
@ltbrk
+ CONVERT(VARCHAR, @centerX) + @space
+ CONVERT(VARCHAR, @centerY) + @comma
+ CONVERT(VARCHAR, @startptX) + @space 
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @startptX) + @space
+ CONVERT(VARCHAR, @startptY - @height) + @comma
+ CONVERT(VARCHAR, @startptX + @width) + @space
+ CONVERT(VARCHAR, @startptY - @height) + @comma
+ CONVERT(VARCHAR, @startptX + @width) + @space
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @startptX + @width*@ratio) + @space
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @centerX) + @space
+ CONVERT(VARCHAR, @centerY)
+ @rtbrk
WHEN @orientation = 'NE' THEN
@ltbrk
+ CONVERT(VARCHAR, @centerX) + @space
+ CONVERT(VARCHAR, @centerY) + @comma
+ CONVERT(VARCHAR, @startptX - @width*@ratio) + @space 
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @startptX - @width) + @space
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @startptX - @width) + @space
+ CONVERT(VARCHAR, @startptY - @height) + @comma
+ CONVERT(VARCHAR, @startptX) + @space
+ CONVERT(VARCHAR, @startptY - @height) + @comma
+ CONVERT(VARCHAR, @startptX) + @space
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @centerX) + @space
+ CONVERT(VARCHAR, @centerY)
+ @rtbrk
WHEN @orientation = 'SW' THEN
@ltbrk
+ CONVERT(VARCHAR, @centerX) + @space
+ CONVERT(VARCHAR, @centerY) + @comma
+ CONVERT(VARCHAR, @startptX + @width*@ratio) + @space 
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @startptX + @width) + @space
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @startptX + @width) + @space
+ CONVERT(VARCHAR, @startptY + @height) + @comma
+ CONVERT(VARCHAR, @startptX) + @space
+ CONVERT(VARCHAR, @startptY + @height) + @comma
+ CONVERT(VARCHAR, @startptX) + @space
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @centerX) + @space
+ CONVERT(VARCHAR, @centerY)
+ @rtbrk
WHEN @orientation = 'SE' THEN
@ltbrk
+ CONVERT(VARCHAR, @centerX) + @space
+ CONVERT(VARCHAR, @centerY) + @comma
+ CONVERT(VARCHAR, @startptX) + @space 
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @startptX) + @space
+ CONVERT(VARCHAR, @startptY + @height) + @comma
+ CONVERT(VARCHAR, @startptX - @width) + @space
+ CONVERT(VARCHAR, @startptY + @height) + @comma
+ CONVERT(VARCHAR, @startptX - @width) + @space
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @startptX - @width*@ratio) + @space
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @centerX) + @space
+ CONVERT(VARCHAR, @centerY)
+ @rtbrk
WHEN @orientation = 'WN' THEN
@ltbrk
+ CONVERT(VARCHAR, @centerX) + @space
+ CONVERT(VARCHAR, @centerY) + @comma
+ CONVERT(VARCHAR, @startptX) + @space 
+ CONVERT(VARCHAR, @startptY - @height*@ratio) + @comma
+ CONVERT(VARCHAR, @startptX) + @space
+ CONVERT(VARCHAR, @startptY - @height) + @comma
+ CONVERT(VARCHAR, @startptX + @width) + @space
+ CONVERT(VARCHAR, @startptY - @height) + @comma
+ CONVERT(VARCHAR, @startptX + @width) + @space
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @startptX) + @space
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @centerX) + @space
+ CONVERT(VARCHAR, @centerY)
+ @rtbrk
WHEN @orientation = 'WS' THEN
@ltbrk
+ CONVERT(VARCHAR, @centerX) + @space
+ CONVERT(VARCHAR, @centerY) + @comma
+ CONVERT(VARCHAR, @startptX) + @space 
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @startptX + @width) + @space
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @startptX + @width) + @space
+ CONVERT(VARCHAR, @startptY + @height) + @comma
+ CONVERT(VARCHAR, @startptX) + @space
+ CONVERT(VARCHAR, @startptY + @height) + @comma
+ CONVERT(VARCHAR, @startptX) + @space
+ CONVERT(VARCHAR, @startptY + @height*@ratio) + @comma
+ CONVERT(VARCHAR, @centerX) + @space
+ CONVERT(VARCHAR, @centerY)
+ @rtbrk
WHEN @orientation = 'EN' THEN
@ltbrk
+ CONVERT(VARCHAR, @centerX) + @space
+ CONVERT(VARCHAR, @centerY) + @comma
+ CONVERT(VARCHAR, @startptX) + @space 
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @startptX - @width) + @space
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @startptX - @width) + @space
+ CONVERT(VARCHAR, @startptY - @height) + @comma
+ CONVERT(VARCHAR, @startptX) + @space
+ CONVERT(VARCHAR, @startptY - @height) + @comma
+ CONVERT(VARCHAR, @startptX) + @space
+ CONVERT(VARCHAR, @startptY - @height*@ratio) + @comma
+ CONVERT(VARCHAR, @centerX) + @space
+ CONVERT(VARCHAR, @centerY)
+ @rtbrk
WHEN @orientation = 'ES' THEN
@ltbrk
+ CONVERT(VARCHAR, @centerX) + @space
+ CONVERT(VARCHAR, @centerY) + @comma
+ CONVERT(VARCHAR, @startptX) + @space 
+ CONVERT(VARCHAR, @startptY + @height*@ratio) + @comma
+ CONVERT(VARCHAR, @startptX) + @space
+ CONVERT(VARCHAR, @startptY + @height) + @comma
+ CONVERT(VARCHAR, @startptX - @width) + @space
+ CONVERT(VARCHAR, @startptY + @height) + @comma
+ CONVERT(VARCHAR, @startptX - @width) + @space
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @startptX) + @space
+ CONVERT(VARCHAR, @startptY) + @comma
+ CONVERT(VARCHAR, @centerX) + @space
+ CONVERT(VARCHAR, @centerY)
+ @rtbrk
END;

RETURN GEOGRAPHY::STGeomFromText(@wktpts, 4326);
END;