@echo off

REM Program:	Save Images
REM Author:	R Glen Cooper
REM Date:	3 Jan 10
REM Purpose:	Save images from SQL Server into specified directory
REM Comments:	

echo.
echo -------------------
echo Save Images
echo -------------------
echo.

REM Get parameters (abort if parameter file missing)
if not exist "SaveImagesParameters.bat" goto Error1
if exist "SaveImagesParameters.bat" call "SaveImagesParameters.bat"

REM Abort if a parameter is missing
if "%Server%"=="" goto error2
if "%Database%"=="" goto error2
if "%Directory%"=="" goto error2

REM Insure that some parameters are enclosed with []
if not "%Database:~0,1%"=="[" set Database=[%Database%]

REM Display parameters to user before proceeding
echo.
echo Save images will use these parameters:
echo.
echo Server = %Server%
echo Database = %Database%
echo Directory = %Directory%
echo. 
pause

REM Save images
echo.
sqlcmd -S %Server% -Q "use %Database% set nocount on exec dbo.spSaveImages @Directory = '%Directory%'"
echo.
goto exitProgram

REM Error processing
:error1
echo The parameter file SaveImagesParameters.bat is missing
echo.
goto exitProgram

REM Error processing
:error2
echo Some parameters are missing from SaveImagesParameters.bat
echo The following parameters are required:
echo.
echo Server
echo Database
echo Directory
echo.
goto exitProgram

REM Exit
:exitProgram
pause
exit

