@echo off

REM Program:	Load Images
REM Author:	R Glen Cooper
REM Date:	3 Jan 10
REM Purpose:	Load images into SQL Server from specified directory
REM Comments:	

echo.
echo -------------------
echo Load Images
echo -------------------
echo.

REM Get parameters (abort if parameter file missing)
if not exist "LoadImagesParameters.bat" goto Error1
if exist "LoadImagesParameters.bat" call "LoadImagesParameters.bat"

REM Abort if a parameter is missing
if "%Server%"=="" goto error2
if "%Database%"=="" goto error2
if "%Directory%"=="" goto error2
if "%Files%"=="" goto error2

REM Insure that some parameters are enclosed with []
if not "%Database:~0,1%"=="[" set Database=[%Database%]

REM Display parameters to user before proceeding
echo.
echo Load images will use these parameters:
echo.
echo Server = %Server%
echo Database = %Database%
echo Directory = %Directory%
echo Files = %Files%
echo. 
pause

REM Load images
echo.
sqlcmd -S %Server% -Q "use %Database% set nocount on exec dbo.spLoadImages @Directory = '%Directory%', @Files = '%Files%'"
echo.
goto exitProgram

REM Error processing
:error1
echo The parameter file LoadImagesParameters.bat is missing
echo.
goto exitProgram

REM Error processing
:error2
echo Some parameters are missing from LoadImagesParameters.bat
echo The following parameters are required:
echo.
echo Server
echo Database
echo Directory
echo Files
echo.
goto exitProgram

REM Exit
:exitProgram
pause
exit

