@echo off

REM Program:	Delete Images
REM Author:	R Glen Cooper
REM Date:	8 Jan 10
REM Purpose:	Delete images from SQL Server
REM Comments:	

echo.
echo -------------------
echo Delete Images
echo -------------------
echo.

REM Get parameters (abort if parameter file missing)
if not exist "DeleteImagesParameters.bat" goto Error1
if exist "DeleteImagesParameters.bat" call "DeleteImagesParameters.bat"

REM Abort if a parameter is missing
if "%Server%"=="" goto error2
if "%Database%"=="" goto error2
if "%Files%"=="" goto error2
if "%Table%"=="" goto error2
if "%Column%"=="" goto error2

REM Insure that some parameters are enclosed with []
if not "%Database:~0,1%"=="[" set Database=[%Database%]

REM Display parameters to user before proceeding
echo.
echo Delete images will use these parameters:
echo.
echo Server = %Server%
echo Database = %Database%
echo Files = %Files%
echo Table = %Table%
echo Column = %Column%
echo. 
pause

REM Delete images
echo.
if "%Files%"=="*.*" sqlcmd -S %Server% -Q "use %Database% set nocount on delete from %Table%"
if NOT "%Files%"=="*.*" sqlcmd -S %Server% -Q "use %Database% set nocount on delete from %Table% where right(%Column%,len('%Files%')) = '%Files%'"
echo.
goto exitProgram

REM Error processing
:error1
echo The parameter file DeleteImagesParameters.bat is missing
echo.
goto exitProgram

REM Error processing
:error2
echo Some parameters are missing from DeleteImagesParameters.bat
echo The following parameters are required:
echo.
echo Server
echo Database
echo Files
echo Table
echo Column
echo.
goto exitProgram

REM Exit
:exitProgram
pause
exit

