
IF (EXISTS(SELECT * FROM sys.objects WHERE [object_id] = OBJECT_ID(N'[dbo].[Holidays]') AND [type]='U'))
DROP TABLE [dbo].[Holidays]
GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Holidays] (
		[SysID]            [int] IDENTITY(1, 1) NOT NULL,
		[HolidayID]        [int] NOT NULL DEFAULT ((0)),
		[Title]            [varchar](100) NOT NULL DEFAULT '',
		[ReportFlag]       [bit] NOT NULL DEFAULT ((0)),
		[DayOffFlag]       [bit] NOT NULL DEFAULT ((0)),
		[StartYear]        [int] NOT NULL DEFAULT ((0)),
		[EndYear]          [int] NOT NULL DEFAULT ((0)),
		[DaysPrior]        [int] NOT NULL DEFAULT ((0)),
		[DaysAfter]        [int] NOT NULL DEFAULT ((0)),
		[MonthOf]          [int] NOT NULL DEFAULT ((0)),
		[DayOf]            [int] NOT NULL DEFAULT ((0)),
		[NameDay]          [int] NOT NULL DEFAULT ((0)),
		[WeekNumber]       [int] NOT NULL DEFAULT ((0)),
		[LastDayFlag]      [bit] NOT NULL DEFAULT ((0)),
		[FullWeekFlag]     [bit] NOT NULL DEFAULT ((0)),
		[BaseHoliday]      [int] NOT NULL DEFAULT ((0)),
		[DaysVariance]     [int] NOT NULL DEFAULT ((0)),
		[SpecialCalc]      [int] NOT NULL DEFAULT ((0)),
		[SlideDate]        [int] NOT NULL DEFAULT ((0))
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [Idx_HolidayID]
	ON [dbo].[Holidays] ([HolidayID])
	ON [PRIMARY]
GO

