
IF (EXISTS(SELECT * FROM sys.objects WHERE [object_id] = OBJECT_ID(N'[dbo].[HolidayDates]') AND [type]='U'))
DROP TABLE [dbo].[HolidayDates]
GO
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET ANSI_PADDING OFF
GO
CREATE TABLE [dbo].[HolidayDates] (
		[SysID]         [int] IDENTITY(1, 1) NOT NULL,
		[HolidayID]     [int] NOT NULL,
		[Year]          [int] NOT NULL,
		[DayStart]      [datetime] NOT NULL,
		[DayEnd]        [datetime] NOT NULL
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [HolidayID_Year]
	ON [dbo].[HolidayDates] ([HolidayID], [Year])
	INCLUDE ([DayStart], [DayEnd])
	ON [PRIMARY]
GO

