
IF (EXISTS(SELECT * FROM sys.objects WHERE [object_id] = OBJECT_ID(N'[dbo].[fn_ActivityForDay]') AND ([type]='IF' OR [type]='FN' OR [type]='TF')))
DROP FUNCTION [dbo].[fn_ActivityForDay]
GO

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
GO

CREATE FUNCTION [dbo].[fn_ActivityForDay]
  (
    @DateIn    datetime
  )
  
  RETURNS @DaysActivities TABLE
  (
    Title      varchar(100),
    StartDate  datetime,
    EndDate    datetime
  )
  AS
  BEGIN

    INSERT INTO @DaysActivities
      SELECT
        h.Title AS Title,
        hd.DayStart AS StartDate,
        hd.DayEnd AS EndDate
      FROM HolidayDates AS hd
      JOIN Holidays AS h ON
        hd.HolidayID = h.HolidayID
      WHERE
        @DateIn BETWEEN hd.DayStart AND hd.DayEnd
        
    RETURN
  END
GO

