
IF (EXISTS(SELECT * FROM sys.objects WHERE [object_id] = OBJECT_ID(N'[dbo].[fn_WhatDate]') AND ([type]='IF' OR [type]='FN' OR [type]='TF')))
DROP FUNCTION [dbo].[fn_WhatDate]
GO

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[fn_WhatDate]
(
  @YearIn        int,
  @MonthIn       int,
  @DayOfHoliday  int,
  @WeekNumber    int,
  @FullWeekFlag  bit
)
/*
  
  @StartOfMonth  - Start Of Month (0 to 6) Sun to Sat
  @YearIn        - Year Of Holiday Check
  @MonthIn       - Month Of Holiday Check
  @DayOfHoliday  - Day Of Holiday (0 to 6) Sun to Sat
  @WeekNumber    - Week Number (1 to 5)
  @FullWeekFlag  - Based on full week
  
  ex: 3rd fri of april 2004 = WhatDate(2004, 4, 5, 3, False)
  
*/
  RETURNS int
  AS
  BEGIN
    DECLARE @ReturnDay    int
    DECLARE @StartOfMonth int
    DECLARE @DayOfWeek    int
    
    /*
      
      Find the name day of the first day of the month and year specified.
      
    */
    SELECT
      @StartOfMonth = DATEPART(dw, CAST(CAST(@YearIn AS char(4)) + '-' + CAST(@MonthIn AS char(2)) + '-01' AS datetime)) - 1
    /*
      
      Figure the DayOfWeek difference by name day that the holiday falls on compared to the start of the month name day.
      Check if the holiday falls on the same name day as the start of the month name day.
      Adjust the DayOfWeek if needed.
      
    */
    SELECT
      @DayOfWeek = ((7 + (( @DayOfHoliday + 1) - @StartOfMonth)) % 7)
    
    /*
      
       If DayOfWeek is 0 then the holiday is 7 days offset from the start of the month.
        ex. month starts on tuesday and the holiday is on a monday is 7 day spread.
        The 0 needs to be changed to a 7 or else the holiday would be 1 week early.
      
    */
    
    IF @DayOfWeek = 0
      BEGIN
        SELECT
          @DayOfWeek = 7
      END
    /*
      
      Calculate the number day based on the week desired and DayOfWeek.
      
    */
    SELECT
      @ReturnDay = (@WeekNumber - 1) * 7 + @DayOfWeek
    /*
      
      If the FullWeekFlag is set (Start counting from first monday) then adjust the number day
      if necessary.
      
    */
    IF @FullWeekFlag = 1 AND @DayOfWeek < (7 - @StartOfMonth)
      BEGIN
        SELECT
          @ReturnDay = @ReturnDay + 7
      END
    /*
      
      Return the number day of the holiday for the specified year and month requested.
      
    */
    RETURN(@ReturnDay)
 END
GO

