
IF (EXISTS(SELECT * FROM sys.objects WHERE [object_id] = OBJECT_ID(N'[dbo].[fn_GetEaster]') AND ([type]='IF' OR [type]='FN' OR [type]='TF')))
DROP FUNCTION [dbo].[fn_GetEaster]
GO

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[fn_GetEaster]
(
  @YearIn  int
)
/*
  
  Calculate easter for the specified year.  This calculation was based on a GWBasic program I had used
  and kept for a very long time.  The program was not very detailed for the different parts and their
  meanings so I am not able to detail and document this function very well.
  
*/
  RETURNS datetime
  AS
  BEGIN
    DECLARE @ReturnDate datetime
    DECLARE @A int
    DECLARE @B int
    DECLARE @C int
    DECLARE @D int
    DECLARE @E int
    DECLARE @F int
    DECLARE @G int
    DECLARE @H int
    DECLARE @I int
    DECLARE @K int
    DECLARE @L int
    DECLARE @M int
    DECLARE @P int
    DECLARE @EM int
    DECLARE @ED int
    
    SELECT
      @A = @YearIn % 19,
      @B = (@YearIn / 100), --INT(@YearIn / 100),
      @C = @YearIn % 100
    
    SELECT
      @D = (@B / 4), --INT(@B / 4),
      @E = @B % 4,
      @F = ((@B + 8) / 25) --INT((@B + 8) / 25)
    
    SELECT
      @G = ((@B - @F + 1) / 3) --INT((@B - @F + 1) / 3)
    
    SELECT
      @H = (19 * @A + @B - @D - @G + 15) % 30,
      @I = (@C / 4), -- INT(@C / 4),
      @K = @C % 4
    
    SELECT
      @L = (32 + 2 * @E + 2 * @I - @H - @K) % 7
    
    SELECT
      @M = ((@A + 11 * @H + 22 * @L) / 451) --INT((@A + 11 * @H + 22 * @L) / 451)
    
    SELECT
      @EM = (( @H + @L - 7 * @M + 114) / 31), --  [3=March, 4=April] -- INT(( @H + l - 7 * @M + 114) / 31), --  [3=March, 4=April]
      @P  = (@H + @L - 7 * @M + 114) % 31
    
    SELECT
      @ED = @P + 1 -- (date in Easter Month)
    
    SELECT
      @ReturnDate = CAST(CAST(@YearIn AS CHAR(4)) + '-' + CAST(@EM AS CHAR(2)) + '-' + CAST(@ED AS CHAR(2)) AS datetime)
    
    RETURN(@ReturnDate)
 END
GO

