/*
	SampleObjects.SQL
	=================
	These are objects used to test the mechanisms used in the article

*/
DECLARE @SchemaName SYSNAME='SqlServerCentral'

DECLARE @SQL VARCHAR(MAX),
	@CRLF CHAR(2)=CHAR(13)+CHAR(10)

SELECT @SQL=COALESCE(@SQL+';'+@CRLF,'')
+	'ALTER TABLE '
+	OBJECT_SCHEMA_NAME(parent_object_id)+'.'+OBJECT_NAME(parent_object_id)
+	' DROP CONSTRAINT '
+	name
FROM sys.objects 
where type='F'
and OBJECT_SCHEMA_NAME(parent_object_id)=@SchemaName

SELECT @SQL=COALESCE(@SQL+';'+@CRLF,'')
+	'DROP TABLE '
+	OBJECT_SCHEMA_NAME(object_id)+'.'+name
FROM sys.objects 
where type='U'
and OBJECT_SCHEMA_NAME(object_id)=@SchemaName

PRINT @SQL
EXEC(@SQL)
GO
CREATE TABLE SqlServerCentral.Member(
	Id int NOT NULL,
	OtherFields varchar(50) NOT NULL,
 CONSTRAINT PK_Members PRIMARY KEY CLUSTERED (Id ASC)
)
GO

CREATE TABLE SqlServerCentral.tbl_Hobby(
	Code int NOT NULL,
	OtherFields varchar(50) NOT NULL,
 CONSTRAINT PK_Hobbies PRIMARY KEY CLUSTERED 
(
	Code ASC
)
)

GO

CREATE TABLE SqlServerCentral.MemberHobby(
	MemberId int NOT NULL,
	HobbyCode int NOT NULL,
	OtherFields varchar(50) NOT NULL,
 CONSTRAINT PK_MemberHobbies PRIMARY KEY CLUSTERED 
(
	MemberId ASC,
	HobbyCode ASC
)
)

GO
CREATE TABLE SqlServerCentral.MemberHobbyAttendance(
	MemberId int NOT NULL,
	HobbyCode int NOT NULL,
	AttendanceDate date NOT NULL,
	OtherFields varchar(50) NOT NULL,
 CONSTRAINT PK_MemberHobbyAttendance PRIMARY KEY CLUSTERED 
(
	MemberId ASC,
	HobbyCode ASC,
	AttendanceDate ASC
)
)

GO
GO

ALTER TABLE SqlServerCentral.MemberHobbyAttendance  ADD  CONSTRAINT FK_MemberHobbyAttendance FOREIGN KEY(MemberId, HobbyCode)
REFERENCES SqlServerCentral.MemberHobby (MemberId, HobbyCode)

ALTER TABLE SqlServerCentral.MemberHobby ADD CONSTRAINT FK_MemberHobby_Hobby FOREIGN KEY (HobbyCode)
REFERENCES SqlServerCentral.tbl_Hobby(Code)
ALTER TABLE SqlServerCentral.MemberHobby ADD CONSTRAINT FK_MemberHobby_Member FOREIGN KEY (MemberId)
REFERENCES SqlServerCentral.Member(ID)
GO




