/*
	SCRIPT:  04_GenerateSupportingTypes.sql

	DESCRIPTION
	===========
	Generate the user defined types necessary to pass around values.
	
*/
DECLARE 
	@DBName SYSNAME = DB_NAME()
RAISERROR('DATABASE: %s, SCRIPT: 04_GenerateSupportingTypes.sql',10,1,@DBName) WITH NOWAIT
PRINT '=============================================================='
GO
-------------------------------------------------------------------------------------------------
IF EXISTS(SELECT * FROM sys.types WHERE NAME='FieldListType')
	BEGIN
		DROP TYPE dbo.FieldListType
		PRINT 'TYPE DROPPED: dbo.FieldListType'
	END
GO
CREATE TYPE dbo.FieldListType AS TABLE (
	Object_id INT NOT NULL,
	ColumnId INT NOT NULL,
	StandardisedObjectName SYSNAME NOT NULL ,
	OriginalColumnName SYSNAME NOT NULL ,
	StandardisedColumnName SYSNAME NOT NULL
)
IF @@ERROR=0 
	PRINT 'TYPE CREATED: dbo.FieldListType'
GO