/*
	SCRIPT:  03_GenerateSupportingViews.sql

	DESCRIPTION
	===========
	Build views to keep track of the candidate keys
	
*/
DECLARE 
	@DBName SYSNAME = DB_NAME()
RAISERROR('DATABASE: %s, SCRIPT: 03_GenerateSupportingViews.sql',10,1,@DBName) WITH NOWAIT
PRINT '=============================================================='
GO
-------------------------------------------------------------------------------------------------
DECLARE 
	@SQL VARCHAR(MAX),
	@CRLF CHAR(2)=CHAR(13)+CHAR(10)

SELECT @SQL = COALESCE(@SQL+';'+@CRLF,'')
+	'DROP VIEW '
+	OBJECT_SCHEMA_NAME(O.object_id) + '.' + O.name
FROM sys.objects AS O
WHERE OBJECT_SCHEMA_NAME(O.object_id)='CandidateKey'
AND O.Type='V'
PRINT @SQL
EXEC(@SQL)
GO
-------------------------------------------------------------------------------------------------------------------
CREATE VIEW CandidateKey.CandidatePrimaryKeys
AS
WITH CleanTables AS (
	SELECT 
		TableId=O.object_id,
		TableName=O.name,
		CleanTableName=CASE WHEN LEFT(O.name,3)='tbl' THEN REPLACE(SUBSTRING(O.name,4,LEN(O.name)),'_','')
		ELSE O.name
		END
	FROM sys.objects AS O
		INNER JOIN sys.schemas AS S
		ON O.schema_id = S.schema_id
	WHERE O.type='U'
	AND S.name NOT IN ('CandidateKey','dba','Validate')
),
PriorityFields AS (
	SELECT 
		O.TableId,
		ColumnName=C.name,
		KeyPriority=CASE
			WHEN C.name='ID' THEN 3
			WHEN C.name='Code' THEN 4
			WHEN CleanTableName+'ID'=REPLACE(C.name,'_','') THEN 5
			WHEN CleanTableName+'Code'=REPLACE(C.name,'_','') THEN 6
			WHEN C.column_id=1 THEN 7
			WHEN C.system_type_id=36 THEN 8
			END,
			C.is_nullable
	FROM sys.columns AS C
		INNER JOIN CleanTables AS O
		ON C.object_id = O.TableId
	WHERE C.column_id=1 or C.name like '%id' OR C.name like '%code' or C.system_type_id=36
)
	SELECT TableID,
		ColumnName,
		KeyPriority,
		is_nullable
	FROM PriorityFields
	WHERE KeyPriority IS NOT NULL
GO
IF @@ERROR = 0
		PRINT 'VIEW CREATED: CandidateKey.CandidatePrimaryKeys'
GO
-------------------------------------------------------------------------------------------------------------------
CREATE VIEW CandidateKey.PKFieldCount
AS
SELECT Object_id, PKFieldCount=COUNT(*)
FROM CandidateKey.StandardisedPKItems
GROUP BY Object_id
GO
IF @@ERROR = 0
		PRINT 'VIEW CREATED: CandidateKey.PKFieldCount'
GO
