/*
	SCRIPT:  02_GenerateSupportingTables.sql

	DESCRIPTION
	===========
	Build tables to keep track of the candidate keys
	
*/
DECLARE 
	@DBName SYSNAME = DB_NAME()
RAISERROR('DATABASE: %s, SCRIPT: 02_GenerateSupportingTables.sql',10,1,@DBName) WITH NOWAIT
PRINT '=============================================================='
GO
-------------------------------------------------------------------------------------------------
IF EXISTS(SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('CandidateKey.CandidateUniqueConstraints'))
	BEGIN
		DROP TABLE CandidateKey.CandidateUniqueConstraints
		PRINT 'TABLE DROPPED: CandidateKey.CandidateUniqueConstraints'
	END
GO

CREATE TABLE CandidateKey.CandidateUniqueConstraints (
	TableID INT NOT NULL,
	KeyPriority TINYINT NOT NULL,
	IsValidated BIT NOT NULL
		CONSTRAINT DF_CandidateUniqueConstraints_IsValidated DEFAULT(0),
	Is_Nullable BIT NOT NULL,
	ValidationTable AS 'T'+CAST(TableId AS SYSNAME),
	ColumnName SYSNAME NOT NULL,
	CONSTRAINT PK_CandidateUniqueConstraints
		PRIMARY KEY CLUSTERED (TableID, ColumnName)
)
GO
IF @@ERROR=0
	PRINT 'TABLE CREATED: CandidateKey.CandidateUniqueConstraints'
GO
IF EXISTS(SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('Validate.CandidateUniqueConstraints'))
	BEGIN
		DROP TABLE Validate.CandidateUniqueConstraints
		PRINT 'TABLE DROPPED: Validate.CandidateUniqueConstraints'
	END
GO

CREATE TABLE Validate.CandidateUniqueConstraints (
	TableID INT NOT NULL,
	ColumnName SYSNAME NOT NULL,
	IsValidated BIT NOT NULL,
	CONSTRAINT PK_Validate_CandidateUniqueConstraints
		PRIMARY KEY CLUSTERED (TableID, ColumnName)
)
GO
IF @@ERROR=0
	PRINT 'TABLE CREATED: Validate.CandidateUniqueConstraints'
GO
IF EXISTS(SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('CandidateKey.StandardisedPKItems'))
	BEGIN
		DROP TABLE CandidateKey.StandardisedPKItems
		PRINT 'TABLE DROPPED: CandidateKey.StandardisedPKItems'
	END
GO
CREATE TABLE CandidateKey.StandardisedPKItems (
	Object_id INT NOT NULL ,
	ColumnId INT NOT NULL,
	SchemaName SYSNAME NOT NULL,
	OriginalObjectName SYSNAME NOT NULL,
	StandardisedObjectName SYSNAME NOT NULL,
	OriginalColumnName SYSNAME NOT NULL,
	StandardisedColumnName SYSNAME NOT NULL,
	CONSTRAINT PK_StandardisedPKItems PRIMARY KEY CLUSTERED (Object_id,OriginalColumnName)
)
GO
IF @@ERROR=0
	PRINT 'TABLE CREATED: CandidateKey.StandardisedPKItems'
GO
IF EXISTS(SELECT * FROM sys.objects WHERE object_id=OBJECT_ID('CandidateKey.PKOneToOneZero'))
	BEGIN
		DROP TABLE CandidateKey.PKOneToOneZero
		PRINT 'TABLE DROPPED: CandidateKey.PKOneToOneZero'
	END
GO
CREATE TABLE CandidateKey.PKOneToOneZero (
	Object_Id INT NOT NULL 
		CONSTRAINT PK_PKOneToOneZero PRIMARY KEY CLUSTERED,
	TablePriority TINYINT NOT NULL,
	SchemaName SYSNAME NOT NULL,
	TableName SYSNAME NOT NULL,
	StandardisedTableName SYSNAME NOT NULL,
	OriginalColumnName SYSNAME NOT NULL,
	StandardisedColumnName SYSNAME NOT NULL
)
GO
IF @@ERROR=0
	PRINT 'TABLE CREATED: CandidateKey.PKOneToOneZero'
