/*
	SCRIPT:  01_GenerateSupportingSchemas.sql

	DESCRIPTION
	===========
	Build database schemas to hold the objects used to identify candidate keys
	
*/
DECLARE 
	@DBName SYSNAME = DB_NAME()
RAISERROR('DATABASE: %s, SCRIPT: 01_GenerateSupportingSchemas.sql',10,1,@DBName) WITH NOWAIT
PRINT '=============================================================='
GO
-------------------------------------------------------------------------------------------------
IF NOT EXISTS(SELECT * FROM sys.schemas WHERE name='dba')
	BEGIN
		EXEC('CREATE SCHEMA dba')
		PRINT 'SCHEMA CREATED: dba'
	END
ELSE
	PRINT 'SCHEMA EXISTS: dba'
GO
IF NOT EXISTS(SELECT * FROM sys.schemas WHERE name='CandidateKey')
	BEGIN
		EXEC('CREATE SCHEMA CandidateKey')
		PRINT 'SCHEMA CREATED: CandidateKey'
	END
ELSE
	PRINT 'SCHEMA EXISTS: CandidateKey'
GO
IF NOT EXISTS(SELECT * FROM sys.schemas WHERE name='Validate')
	BEGIN
		EXEC('CREATE SCHEMA Validate')
		PRINT 'SCHEMA CREATED: Validate'
	END
ELSE
	PRINT 'SCHEMA EXISTS: Validate'
GO
IF NOT EXISTS(SELECT * FROM sys.schemas WHERE name='SQLServerCentral')
	BEGIN
		EXEC('CREATE SCHEMA SQLServerCentral')
		PRINT 'SCHEMA CREATED: SQLServerCentral'
	END
ELSE
	PRINT 'SCHEMA EXISTS: SQLServerCentral'
GO