use AdventureWorks2014
go
-- Flush out existing tables
exec CandidateKey.FlushValidateSchema

-- Grab a list of potential candidates
exec CandidateKey.GetCandidateKeys

-- Evaluate the uniqueness of the candidate fields
exec CandidateKey.ExecuteCandidateUniqueness 0,999999

-- Unpivot the results and flag the potential candidates
exec CandidateKey.SetCandidateValidity

-- List the SQL to generate the candidate keys
;WITH PotentialKeys(Likelihood,SchemaName,TableName,ColumnName,KeyPriority) AS (
	SELECT 
		ROW_NUMBER() OVER(PARTITION BY TableID ORDER BY KeyPriority),
		SchemaName=OBJECT_SCHEMA_NAME(TableID),
		TableName=OBJECT_NAME(TableID),
		ColumnName,
		KeyPriority
	FROM CandidateKey.CandidateUniqueConstraints
)
SELECT 
	'ALTER TABLE ' + SchemaName + '.' + TableName
+	' ADD CONSTRAINT PKCandidate_' + SchemaName + '_' + TableName
+	' PRIMARY KEY (' + ColumnName +')'
FROM PotentialKeys
WHERE Likelihood=1
AND ColumnName<>'rowguid' 
ORDER BY SchemaName,TableName

;WITH PotentialKeys(Likelihood,SchemaName,TableName,ColumnName,KeyPriority) AS (
	SELECT 
		ROW_NUMBER() OVER(PARTITION BY TableID ORDER BY KeyPriority),
		SchemaName=OBJECT_SCHEMA_NAME(TableID),
		TableName=OBJECT_NAME(TableID),
		ColumnName,
		KeyPriority
	FROM CandidateKey.CandidateUniqueConstraints
)
SELECT 
	'ALTER TABLE ' + SchemaName + '.' + TableName
+	' ADD CONSTRAINT UQCandidate_' + SchemaName + '_' + TableName+'_'+ColumnName
+	' UNIQUE (' + ColumnName +')'
FROM PotentialKeys
WHERE Likelihood>1 
and ColumnName<>'rowguid'
ORDER BY SchemaName,TableName

