use AW2014
GO
-------------------------------------------------------------------------------------------------
exec dba.FlushForeignKeys

exec	CandidateKey.GetStandardisedPKItems
exec	CandidateKey.GetPKOneToOneZeroPriority 
exec	CandidateKey.GeneratePKOneToOneZeroHierarchy
exec	CandidateKey.GenerateMultiFieldFK
exec	CandidateKey.GenerateSchemaSpecificFK
exec	CandidateKey.GenerateFinalSingleFieldFK


SELECT DatabaseName='Adventureworks2014',NumberOfRelationships=count(*) from Adventureworks2014..sysreferences
UNION ALL
SELECT DatabaseName='Aw2014',NumberOfRelationships=count(*) from Aw2014..sysreferences

SELECT 	DISTINCT
	OriginalParentName=Original.ParentName,
	OriginalChildName=Original.ChildName,
	NewParentName=NewR.ParentName,
	NewChildName=NewR.ChildName

FROM
 (
	select 
		ParentName=PS.name+'.'+P.name,
		ChildName=CS.name+'.'+C.name
	from Adventureworks2014..sysreferences AS R
		INNER JOIN Adventureworks2014.sys.objects AS P
		ON R.rkeyId = P.object_id
		INNER JOIN Adventureworks2014.sys.schemas AS PS
		ON P.schema_id = PS.schema_id
		INNER JOIN Adventureworks2014.sys.objects AS C
		ON R.fkeyId = C.object_id
		INNER JOIN Adventureworks2014.sys.schemas AS CS
		ON C.schema_id = CS.schema_id
) AS Original
	FULL OUTER JOIN(
	select 
		ParentName=PS.name+'.'+P.name,
		ChildName=CS.name+'.'+C.name
	from AW2014..sysreferences AS R
		INNER JOIN AW2014.sys.objects AS P
		ON R.rkeyId = P.object_id
		INNER JOIN AW2014.sys.schemas AS PS
		ON P.schema_id = PS.schema_id
		INNER JOIN AW2014.sys.objects AS C
		ON R.fkeyId = C.object_id
		INNER JOIN AW2014.sys.schemas AS CS
		ON C.schema_id = CS.schema_id
)  NewR
ON Original.ParentName = NewR.ParentName
AND Original.ChildName = NewR.ChildName
where Original.ParentName IS NULL
OR NewR.ParentName IS NULL

