using System;
using System.Data;
using System.Data.SqlClient;
using System.Data.SqlTypes;
using Microsoft.SqlServer.Server;
using ExcelExport;

public partial class StoredProcedures
{
    [Microsoft.SqlServer.Server.SqlProcedure]
    public static void ExportToExcel(SqlString procName, SqlString filePath, SqlString fileName)
    {
        DataSet exportData = new DataSet();

        if (procName.Value == string.Empty)
            throw new Exception("Procedure name value is missing.");

        if (filePath.Value == string.Empty)
            throw new Exception("Missing file path location.");

        if (fileName.Value == string.Empty)
            throw new Exception("Missing name of file.");

        using (SqlConnection conn = new SqlConnection("context connection=true"))
        {
            SqlCommand getOutput = new SqlCommand();

            getOutput.CommandText = procName.ToString(); ;
            getOutput.CommandType = CommandType.StoredProcedure;
            getOutput.CommandTimeout = 120;
            getOutput.Connection = conn;

            conn.Open();
            SqlDataAdapter da = new SqlDataAdapter(getOutput);
            da.Fill(exportData);
            conn.Close();
        }

        ExcelExportUtility exportUtil = new ExcelExportUtility(fileName.ToString(),filePath.ToString());
        exportUtil.SheetNameColumnOrdinal = 0;
        exportUtil.Export(exportData);
    }
}
