﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Data.SqlTypes;
using Microsoft.SqlServer.Server;
using System.Collections; // needed for both functions; contains IEnumerable
using System.Collections.Generic; // needed for TVF_Standard function; contains List<>

public partial class TestFunctions
{
	private struct ReturnValues
	{
		public int Value;
	}

	private static void FillValues(object obj, out SqlInt32 TheValue)
	{
		ReturnValues ReturnVals = (ReturnValues)obj;
		TheValue = ReturnVals.Value;
	}
	
	[Microsoft.SqlServer.Server.SqlFunction(DataAccess = DataAccessKind.None, IsDeterministic = true,
		IsPrecise = true, SystemDataAccess = SystemDataAccessKind.None, FillRowMethodName = "FillValues",
		TableDefinition = "IntValue INT")]
	public static IEnumerable TVF_Standard(SqlInt32 MaxValue)
	{
		if (MaxValue.IsNull)
		{
			return new List<ReturnValues>(); // return no rows
		}

		List<ReturnValues> AllVals = new List<ReturnValues>(); // container for the Result Set
		ReturnValues Vals = new ReturnValues(); // each row

		for (int index = 1; index <= MaxValue.Value; index++)
		{
			Vals.Value = index;
			AllVals.Add(Vals); // add row to the Result Set container
		}

		return AllVals; // return all data at once
	}


	[Microsoft.SqlServer.Server.SqlFunction(DataAccess = DataAccessKind.None, IsDeterministic = true,
		IsPrecise = true, SystemDataAccess = SystemDataAccessKind.None, FillRowMethodName = "FillValues",
		TableDefinition = "IntValue INT")]
	public static IEnumerable TVF_Streaming(SqlInt32 MaxValue)
	{
		if (MaxValue.IsNull)
		{
			yield break; // return no rows
		}

		// we do not need the Generic List of <ReturnValues>
		ReturnValues Vals = new ReturnValues(); // each row

		for (int index = 1; index <= MaxValue.Value; index++)
		{
			Vals.Value = index;
			yield return Vals; // return row per each itteration
		}

		// we do not need to return everything at once
	}


};

