﻿-- DoubleM_Query_Demo.sql
-- Double Metaphone Demonstration
-- SQL 2005 Express Demo by Michael Coles, MCDBA

-- Here we declare a DoubleMetaphoneResult UDT variable
-- and encode 'ATKIN'.  You can encode any name you want
-- here, just replace 'ATKIN' with the name of your
-- choice.

DECLARE @r DoubleMetaphoneResult
SET @r = dbo.DoubleMetaphoneEncode (N'ATKIN')

-- Here we are selecting only those matches with a score >= 1
-- which is the weakest match.  You can raise this value to
-- >= 2 for a medium to strong match or = 3 for only the best
-- matches.
--
-- We are using the previously created People table for this
-- query.

SELECT dbo.DoubleMetaphoneCompare(DMEncoding, @r) AS SCORE, *
FROM People
WHERE dbo.DoubleMetaphoneCompare(DMEncoding, @r) >= 1
ORDER BY SCORE DESC, SURNAME ASC


