﻿-- DoubleM_Install.sql
-- Double Metaphone Demonstration
-- SQL 2005 Express Demo by Michael Coles, MCDBA

-- This script installs the DoubleMetaphone assembly as well as the
-- UDT's and UDF's.

-- Create the assembly.  Note that you may have to change the Directory
-- Path below to point at your correct SQL 2005 install directory.

CREATE ASSEMBLY DoubleMetaphone
FROM 'C:\Program Files\Microsoft SQL Server\MSSQL.1\MSSQL\Binn\DoubleMetaphone.dll'
GO

-- Here we install the DoubleMetaphoneResult UDT

CREATE TYPE DoubleMetaphoneResult
EXTERNAL NAME DoubleMetaphone.[Phonetic.Tools.DoubleMetaphoneResult]
GO

-- Here we install the DoubleMetaphoneCompare() UDF

CREATE FUNCTION DoubleMetaphoneCompare (@r1 DoubleMetaphoneResult, @r2 DoubleMetaphoneResult)
RETURNS Integer
AS
EXTERNAL NAME DoubleMetaphone.[Phonetic.Tools.DoubleMetaphone].DoubleMetaphoneCompare
GO

-- And finally we install the DoubleMetaphoneEncode UDF

CREATE FUNCTION DoubleMetaphoneEncode (@string NVARCHAR(256))
RETURNS DoubleMetaphoneResult
AS
EXTERNAL NAME DoubleMetaphone.[Phonetic.Tools.DoubleMetaphone].DoubleMetaphoneEncode
GO

-- Just to make sure the "clr enabled" option is configured
-- correctly

sp_configure "clr enabled", 1
go
reconfigure
go
