Imports System.Data.SqlTypes
Imports Microsoft.SqlServer.Server
Imports System.Runtime.InteropServices
Imports System.Text

Namespace Phonetic.Tools
    ' Test

    <Serializable(), _
        SqlUserDefinedType(Format.UserDefined, IsByteOrdered:=True, MaxByteSize:=16), _
        StructLayout(LayoutKind.Sequential)> _
    Public Class DoubleMetaphoneResult
        Implements INullable, IBinarySerialize

        Public Sub Write(ByVal w As System.IO.BinaryWriter) Implements IBinarySerialize.Write
            If Me.IsNull Then
                w.Write("")
            Else
                w.Write(Me.First.PadRight(4, " ").Substring(0, 4) & Me.Second.PadRight(4, " ").Substring(0, 4))
            End If
        End Sub

        Public Sub Read(ByVal r As System.IO.BinaryReader) Implements IBinarySerialize.Read
            Dim s As String = r.ReadString()
            If (s.Length <> 8) Then
                Me._IsNull = True
            Else
                Me.First = s.Substring(0, 4).ToUpper()
                Me.Second = s.Substring(4, 4).ToUpper()
            End If
        End Sub

        Private _First As String
        Private _Second As String
        Private _IsNull As Boolean

        Public Shared Function Parse(ByVal data As SqlString) As DoubleMetaphoneResult
            Dim result As New DoubleMetaphoneResult
            If (data.Value.Length <> 8) Then
                result._IsNull = True
            Else
                result.First = data.Value.Substring(0, 4).ToUpper()
                result.Second = data.Value.Substring(4, 4).ToUpper()
            End If
            Return result
        End Function

        Public Overrides Function ToString() As String
            Dim sb As New StringBuilder(16)
            If (Me.IsNull) Then
                sb.Append("NULL")
            Else
                sb.Append(_First.PadRight(4, " ").Substring(0, 4))
                sb.Append(_Second.PadRight(4, " ").Substring(0, 4))
            End If
            Return sb.ToString()
        End Function

        Public Shared ReadOnly Property Null() As DoubleMetaphoneResult
            Get
                Dim result As New DoubleMetaphoneResult
                result._IsNull = True
                Return result
            End Get
        End Property

        Public ReadOnly Property IsNull() As Boolean Implements INullable.IsNull
            Get
                Return (_IsNull)
            End Get
        End Property

        Public Property First() As String
            Get
                Return (_First)
            End Get
            Set(ByVal value As String)
                _First = value
            End Set
        End Property

        Public Property Second() As String
            Get
                Return (_Second)
            End Get
            Set(ByVal value As String)
                _Second = value
            End Set
        End Property
    End Class
End Namespace