Imports System.Data.SqlTypes
Imports Microsoft.SqlServer.Server
Imports Microsoft.SqlServer
Imports System.Data.SqlClient
Imports System.Text
Namespace Phonetic.Tools
    Public Class DoubleMetaphone
        '////////////////////////////////////////////////////////////////////////////////
        '// Double Metaphone (c) 1998, 1999 by Lawrence Philips
        '//
        '// Slightly modified by Kevin Atkinson to fix several bugs AndAlso 
        '// to allow it to give back more than 4 characters.
        '//
        '//
        '////////////////////////////////////////////////////////////////////////////////

        Private Shared Function IsSlavoGermanic(ByVal _RawText As String) As Boolean
            Dim f As Boolean = False
            If ((_RawText.Contains("W")) _
            OrElse (_RawText.Contains("K")) _
            OrElse (_RawText.Contains("CZ")) _
            OrElse (_RawText.Contains("WITZ"))) Then
                f = True
            End If
            Return f
        End Function

        Private Shared Sub MetaphAdd(ByRef _Primary As StringBuilder, ByRef _Alternate As StringBuilder, ByVal main As String)
            _Primary.Append(main)
            _Alternate.Append(main)
        End Sub

        Private Shared Sub MetaphAdd(ByRef _Primary As StringBuilder, ByRef _Alternate As StringBuilder, ByVal main As String, ByVal alt As String, ByRef _AlternateFlag As Boolean)
            _Primary.Append(main)
            _AlternateFlag = True
            _Alternate.Append(alt)
        End Sub

        Private Shared Function IsVowel(ByRef _RawText As String, ByVal at As Integer) As Boolean
            Dim f As Boolean = False
            If ((at >= 0) AndAlso (at < _RawText.Length)) Then
                If ((_RawText.Substring(at, 1) = "A") _
                OrElse (_RawText.Substring(at, 1) = "E") _
                OrElse (_RawText.Substring(at, 1) = "I") _
                OrElse (_RawText.Substring(at, 1) = "O") _
                OrElse (_RawText.Substring(at, 1) = "U") _
                OrElse (_RawText.Substring(at, 1) = "Y")) Then
                    f = True
                End If
            End If
            Return f
        End Function

        Private Shared Function StringAt(ByRef _RawText As String, ByVal start As Integer, ByVal ParamArray sstring As String()) As Boolean
            Dim f As Boolean = False
            Dim i As Integer = 0
            If (start >= 0) Then
                Do While (i < sstring.Length AndAlso Not (f))
                    If (_RawText.Substring(start, sstring(i).Length) = sstring(i)) Then
                        f = True
                    End If
                    i += 1
                Loop
            End If
            Return f
        End Function

        Private Shared Function GetAt(ByRef _RawText As String, ByVal at As Integer) As String
            Dim s As String = ""
            If (at >= 0 AndAlso at < _RawText.Length) Then
                s = _RawText.Substring(at, 1)
            End If
            Return s
        End Function

        <SqlFunction(IsDeterministic:=True)> _
        Public Shared Function DoubleMetaphoneEncode(ByVal RawText As String) As DoubleMetaphoneResult
            Dim r As New DoubleMetaphoneResult
            Dim current As Integer = 0
            Dim last As Integer = 0
            Dim SlavoGermanic = IsSlavoGermanic(RawText)

            Dim _Primary As New StringBuilder(32)
            Dim _Alternate As New StringBuilder(32)
            Dim _AlternateFlag As Boolean = False

            r.First = ""
            r.Second = ""
            Dim length As Integer = RawText.Length

            If (length >= 1) Then
                last = length - 1 'zero based index
                'pad the original string so that we can index beyond the edge of the word 

                RawText = RawText.ToUpper() & "      "
                'skip these when at start of word
                If (StringAt(RawText, 0, "GN", "KN", "PN", "WR", "PS")) Then
                    current += 1
                End If

                'Initial 'X' is pronounced 'Z' e.g. 'Xavier'
                If (GetAt(RawText, 0) = "X") Then
                    MetaphAdd(_Primary, _Alternate, "S") ' Z ==> S
                    current += 1
                End If

                Do While (current < length AndAlso _Primary.Length < 4)
                    Select Case GetAt(RawText, current)
                        Case "A", "E", "I", "O", "U", "Y"
                            If (current = 0) Then
                                ' [init vowels] ==> A
                                MetaphAdd(_Primary, _Alternate, "A")
                            End If
                            current += 1
                        Case "B"
                            ' B ==> P
                            MetaphAdd(_Primary, _Alternate, "P")
                            If (GetAt(RawText, current + 1) = "B") Then
                                current += 2
                            Else
                                current += 1
                            End If
                        Case ""
                            MetaphAdd(_Primary, _Alternate, "S") '  ==> S
                            current += 1
                        Case "C"
                            ' various germanic
                            If ((current > 1) _
                                AndAlso Not (IsVowel(RawText, current - 2)) _
                                AndAlso StringAt(RawText, (current - 1), "ACH") _
                                AndAlso ((GetAt(RawText, current + 2) <> "I") AndAlso ((GetAt(RawText, current + 2) <> "E") _
                                OrElse StringAt(RawText, (current - 2), "BACHER", "MACHER")))) Then
                                MetaphAdd(_Primary, _Alternate, "K")
                                current += 2
                                Exit Select
                            End If

                            ' special case 'caesar'
                            If ((current = 0) AndAlso StringAt(RawText, current, "CAESAR")) Then
                                MetaphAdd(_Primary, _Alternate, "S")
                                current += 2
                                Exit Select
                            End If

                            ' italian 'chianti'
                            If (StringAt(RawText, current, "CHIA")) Then
                                MetaphAdd(_Primary, _Alternate, "K")
                                current += 2
                                Exit Select
                            End If

                            If (StringAt(RawText, current, "CH")) Then
                                ' find 'michael'
                                If ((current > 0) AndAlso StringAt(RawText, current, "CHAE")) Then
                                    MetaphAdd(_Primary, _Alternate, "K", "X", _AlternateFlag)
                                    current += 2
                                    Exit Select
                                End If

                                ' greek roots e.g. 'chemistry', 'chorus'
                                If ((current = 0) _
                                    AndAlso (StringAt(RawText, (current + 1), "HARAC", "HARIS") _
                                    OrElse StringAt(RawText, (current + 1), "HOR", "HYM", "HIA", "HEM")) _
                                    AndAlso Not (StringAt(RawText, 0, "CHORE"))) Then
                                    MetaphAdd(_Primary, _Alternate, "K")
                                    current += 2
                                    Exit Select
                                End If

                                ' germanic, greek, OrElse otherwise 'ch' for 'kh' sound
                                ' 'architect but not 'arch', 'orchestra', 'orchid'
                                ' e.g., 'wachtler', 'wechsler', but not 'tichner'
                                If ((StringAt(RawText, 0, "VAN ", "VON ") OrElse StringAt(RawText, 0, "SCH")) _
                                    OrElse StringAt(RawText, (current - 2), "ORCHES", "ARCHIT", "ORCHID") _
                                    OrElse StringAt(RawText, (current + 2), "T", "S") _
                                    OrElse ((StringAt(RawText, (current - 1), "A", "O", "U", "E") OrElse (current = 0)) _
                                    AndAlso StringAt(RawText, (current + 2), "L", "R", "N", "M", "B", "H", "F", "V", "W", " "))) Then
                                    MetaphAdd(_Primary, _Alternate, "K")
                                Else
                                    If (current > 0) Then
                                        If (StringAt(RawText, 0, "MC")) Then
                                            ' e.g., "McHugh"
                                            MetaphAdd(_Primary, _Alternate, "K")
                                        Else
                                            MetaphAdd(_Primary, _Alternate, "X", "K", _AlternateFlag)
                                        End If
                                    Else
                                        MetaphAdd(_Primary, _Alternate, "X")
                                    End If
                                    current += 2
                                    Exit Select
                                End If
                                ' e.g, 'czerny'
                                If (StringAt(RawText, current, "CZ") AndAlso StringAt(RawText, (current - 2), "WICZ")) Then
                                    MetaphAdd(_Primary, _Alternate, "S", "X", _AlternateFlag)
                                    current += 2
                                    Exit Select
                                End If

                                ' e.g., 'focaccia'
                                If (StringAt(RawText, (current + 1), "CIA")) Then
                                    MetaphAdd(_Primary, _Alternate, "X")
                                    current += 3
                                    Exit Select
                                End If

                                ' double 'C', but not if e.g. 'McClellan'
                                If (StringAt(RawText, current, "CC") AndAlso Not ((current = 1) AndAlso (GetAt(RawText, 0) = "M"))) Then
                                    ' 'bellocchio' but not 'bacchus'
                                    If (StringAt(RawText, (current + 2), "I", "E", "H") AndAlso Not (StringAt(RawText, (current + 2), "HU"))) Then

                                        ' 'accident', 'accede' 'succeed'
                                        If (((current = 1) AndAlso (GetAt(RawText, current - 1) = "A")) _
                                                        OrElse StringAt(RawText, (current - 1), "UCCEE", "UCCES")) Then
                                            MetaphAdd(_Primary, _Alternate, "KS")
                                            ' 'bacci', 'bertucci', other italian
                                        Else
                                            MetaphAdd(_Primary, _Alternate, "X")
                                            current += 3
                                            Exit Select
                                        End If
                                    Else ' Pierce's rule
                                        MetaphAdd(_Primary, _Alternate, "K")
                                        current += 2
                                        Exit Select
                                    End If

                                    If (StringAt(RawText, current, "CK", "CG", "CQ")) Then
                                        MetaphAdd(_Primary, _Alternate, "K")
                                        current += 2
                                        Exit Select
                                    End If

                                    If (StringAt(RawText, current, "CI", "CE", "CY")) Then

                                        ' italian vs. english
                                        If (StringAt(RawText, current, "CIO", "CIE", "CIA")) Then
                                            MetaphAdd(_Primary, _Alternate, "S", "X", _AlternateFlag)
                                        Else
                                            MetaphAdd(_Primary, _Alternate, "S")
                                        End If
                                        current += 2
                                        Exit Select
                                    End If
                                    MetaphAdd(_Primary, _Alternate, "K")
                                    Exit Select
                                End If
                            End If

                            ' name sent in 'mac caffrey', 'mac gregor
                            If (StringAt(RawText, (current + 1), " C", " Q", " G")) Then
                                current += 3
                            Else
                                If (StringAt(RawText, (current + 1), "C", "K", "Q") _
                                    AndAlso Not (StringAt(RawText, (current + 1), "CE", "CI"))) Then
                                    current += 2
                                Else
                                    current += 1
                                End If
                                MetaphAdd(_Primary, _Alternate, "K")
                            End If
                        Case "D"
                            If (StringAt(RawText, current, "DG")) Then
                                If (StringAt(RawText, (current + 2), "I", "E", "Y")) Then
                                    ' e.g. 'edge'
                                    MetaphAdd(_Primary, _Alternate, "J")
                                    current += 3
                                    Exit Select
                                Else
                                    ' e.g. 'edgar'
                                    MetaphAdd(_Primary, _Alternate, "TK")
                                    current += 2
                                    Exit Select
                                End If

                                If (StringAt(RawText, current, "DT", "DD")) Then
                                    MetaphAdd(_Primary, _Alternate, "T")
                                    current += 2
                                    Exit Select
                                End If
                            End If
                            MetaphAdd(_Primary, _Alternate, "T")
                            current += 1
                        Case "F"
                            If (GetAt(RawText, current + 1) = "F") Then
                                current += 2
                            Else
                                current += 1
                            End If
                            MetaphAdd(_Primary, _Alternate, "F")
                        Case "G"
                            If (GetAt(RawText, current + 1) = "H") Then
                                If ((current > 0) AndAlso Not (IsVowel(RawText, current - 1))) Then
                                    MetaphAdd(_Primary, _Alternate, "K")
                                    current += 2
                                    Exit Select
                                End If

                                If (current < 3) Then
                                    ' 'ghislane', ghiradelli
                                    If (current = 0) Then
                                        If (GetAt(RawText, current + 2) = "I") Then
                                            MetaphAdd(_Primary, _Alternate, "J")
                                        Else
                                            MetaphAdd(_Primary, _Alternate, "K")
                                        End If
                                        current += 2
                                        Exit Select
                                    End If
                                End If
                                ' Parker's rule (with some further refinements) - e.g., 'hugh'
                                ' e.g., 'bough'  
                                ' e.g., 'broughton' 
                                If (((current > 1) AndAlso StringAt(RawText, (current - 2), "B", "H", "D")) _
                                    OrElse ((current > 2) AndAlso StringAt(RawText, (current - 3), "B", "H", "D")) _
                                    OrElse ((current > 3) AndAlso StringAt(RawText, (current - 4), "B", "H"))) Then
                                    current += 2
                                    Exit Select
                                Else
                                    ' e.g., 'laugh', 'McLaughlin', 'cough', 'gough', 'rough', 'tough'
                                    If ((current > 2) _
                                            AndAlso (GetAt(RawText, current - 1) = "U") _
                                            AndAlso StringAt(RawText, (current - 3), "C", "G", "L", "R", "T")) Then
                                        MetaphAdd(_Primary, _Alternate, "F")
                                    Else
                                        If ((current > 0) AndAlso GetAt(RawText, current - 1) <> "I") Then
                                            MetaphAdd(_Primary, _Alternate, "K")
                                        End If
                                    End If
                                    current += 2
                                    Exit Select
                                End If
                            End If

                            If (GetAt(RawText, current + 1) = "N") Then
                                If ((current = 1) AndAlso IsVowel(RawText, 0) AndAlso Not (SlavoGermanic)) Then
                                    MetaphAdd(_Primary, _Alternate, "KN", "N", _AlternateFlag)
                                Else
                                    ' not e.g. 'cagney'
                                    If (Not (StringAt(RawText, (current + 2), "EY")) _
                                        AndAlso (GetAt(RawText, current + 1) <> "Y") AndAlso Not (SlavoGermanic)) Then
                                        MetaphAdd(_Primary, _Alternate, "N", "KN", _AlternateFlag)
                                    Else
                                        MetaphAdd(_Primary, _Alternate, "KN")
                                    End If
                                End If
                                current += 2
                                Exit Select
                            End If

                            ' 'tagliaro'
                            If (StringAt(RawText, (current + 1), "LI") AndAlso Not (SlavoGermanic)) Then
                                MetaphAdd(_Primary, _Alternate, "KL", "L", _AlternateFlag)
                                current += 2
                                Exit Select
                            End If

                            ' -ges-,-gep-,-gel-, -gie- at beginning
                            If ((current = 0) _
                                AndAlso ((GetAt(RawText, current + 1) = "Y") _
                                OrElse StringAt(RawText, (current + 1), "ES", "EP", "EB", "EL", "EY", "IB", "IL", "IN", "IE", "EI", "ER"))) Then
                                MetaphAdd(_Primary, _Alternate, "K", "J", _AlternateFlag)
                                current += 2
                                Exit Select
                            End If

                            ' -ger-,  -gy-
                            If ((StringAt(RawText, (current + 1), "ER") OrElse (GetAt(RawText, current + 1) = "Y")) _
                                AndAlso Not (StringAt(RawText, 0, "DANGER", "RANGER", "MANGER")) _
                                AndAlso Not (StringAt(RawText, (current - 1), "E", "I")) _
                                AndAlso Not (StringAt(RawText, (current - 1), "RGY", "OGY"))) Then
                                MetaphAdd(_Primary, _Alternate, "K", "J", _AlternateFlag)
                                current += 2
                                Exit Select
                            End If

                            ' italian e.g, 'biaggi'
                            If (StringAt(RawText, (current + 1), "E", "I", "Y") OrElse StringAt(RawText, (current - 1), "AGGI", "OGGI")) Then
                                ' obvious germanic
                                If ((StringAt(RawText, 0, "VAN ", "VON ") OrElse StringAt(RawText, 0, "SCH")) _
                                    OrElse StringAt(RawText, (current + 1), "ET")) Then
                                    MetaphAdd(_Primary, _Alternate, "K")
                                Else
                                    ' always soft if french ending
                                    If (StringAt(RawText, (current + 1), "IER ")) Then
                                        MetaphAdd(_Primary, _Alternate, "J")
                                    Else
                                        MetaphAdd(_Primary, _Alternate, "J", "K", _AlternateFlag)
                                    End If
                                End If
                                current += 2
                                Exit Select
                            End If

                            If (GetAt(RawText, current + 1) = "G") Then
                                current += 2
                            Else
                                current += 1
                            End If
                            MetaphAdd(_Primary, _Alternate, "K")
                        Case "H"
                            ' only keep if first & before vowel OrElse btw. 2 vowels
                            If (((current = 0) OrElse IsVowel(RawText, current - 1)) _
                                AndAlso IsVowel(RawText, current + 1)) Then
                                MetaphAdd(_Primary, _Alternate, "H")
                                current += 2
                            Else ' also takes care of 'HH'
                                current += 1
                            End If
                        Case "J"
                            'obvious spanish, 'jose', 'san jacinto'
                            If (StringAt(RawText, current, "JOSE") OrElse StringAt(RawText, 0, "SAN ")) Then
                                If (((current = 0) AndAlso (GetAt(RawText, current + 4) = " ")) OrElse StringAt(RawText, 0, "SAN ")) Then
                                    MetaphAdd(_Primary, _Alternate, "H")
                                Else
                                    MetaphAdd(_Primary, _Alternate, "J", "H", _AlternateFlag)
                                End If
                                current += 1
                                Exit Select
                            End If
                            If ((current = 0) AndAlso Not (StringAt(RawText, current, "JOSE"))) Then
                                MetaphAdd(_Primary, _Alternate, "J", "A", _AlternateFlag) ' Yankelovich/Jankelowicz
                            Else
                                'spanish pron. of e.g. 'bajador'
                                If (IsVowel(RawText, current - 1) _
                                    AndAlso Not (SlavoGermanic) _
                                    AndAlso ((GetAt(RawText, current + 1) = "A") OrElse (GetAt(RawText, current + 1) = "O"))) Then
                                    MetaphAdd(_Primary, _Alternate, "J", "H", _AlternateFlag)
                                Else
                                    If (current = last) Then
                                        MetaphAdd(_Primary, _Alternate, "J", " ", _AlternateFlag)
                                    Else
                                        If (Not (StringAt(RawText, (current + 1), "L", "T", "K", "S", "N", "M", "B", "Z")) _
                                            AndAlso Not (StringAt(RawText, (current - 1), "S", "K", "L"))) Then
                                            MetaphAdd(_Primary, _Alternate, "J")
                                        End If
                                    End If
                                End If
                            End If
                            If (GetAt(RawText, current + 1) = "J") Then ' it could happen!
                                current += 2
                            Else
                                current += 1
                            End If
                        Case "K"
                            If (GetAt(RawText, current + 1) = "K") Then
                                current += 2
                            Else
                                current += 1
                            End If
                            MetaphAdd(_Primary, _Alternate, "K")
                        Case "L"
                            If (GetAt(RawText, current + 1) = "L") Then
                                ' spanish e.g. 'cabrillo', 'gallegos'
                                If (((current = (length - 3)) _
                                    AndAlso StringAt(RawText, (current - 1), "ILLO", "ILLA", "ALLE")) _
                                    OrElse ((StringAt(RawText, (last - 1), "AS", "OS") OrElse StringAt(RawText, last, "A", "O")) _
                                    AndAlso StringAt(RawText, (current - 1), "ALLE"))) Then
                                    MetaphAdd(_Primary, _Alternate, "L", "", _AlternateFlag)
                                    current += 2
                                    Exit Select
                                End If
                                current += 2
                            Else
                                current += 1
                            End If
                            MetaphAdd(_Primary, _Alternate, "L")
                        Case "M"
                            ' 'dumb','thumb' 
                            If ((StringAt(RawText, (current - 1), "UMB") _
                                AndAlso (((current + 1) = last) OrElse StringAt(RawText, (current + 2), "ER"))) _
                                OrElse (GetAt(RawText, current + 1) = "M")) Then
                                current += 2
                            Else
                                current += 1
                            End If
                            MetaphAdd(_Primary, _Alternate, "M")
                        Case "N"
                            If (GetAt(RawText, current + 1) = "N") Then
                                current += 2
                            Else
                                current += 1
                            End If
                            MetaphAdd(_Primary, _Alternate, "N")
                        Case ""
                            current += 1
                            MetaphAdd(_Primary, _Alternate, "N")
                        Case "P"
                            If (GetAt(RawText, current + 1) = "H") Then
                                MetaphAdd(_Primary, _Alternate, "F")
                                current += 2
                                Exit Select
                            End If

                            ' also account for "campbell", "raspberry"
                            If (StringAt(RawText, (current + 1), "P", "B")) Then
                                current += 2
                            Else
                                current += 1
                            End If
                            MetaphAdd(_Primary, _Alternate, "P")
                        Case "Q"
                            If (GetAt(RawText, current + 1) = "Q") Then
                                current += 2
                            Else
                                current += 1
                            End If
                            MetaphAdd(_Primary, _Alternate, "K")
                        Case "R"
                            ' french e.g. 'rogier', but exclude 'hochmeier'
                            If ((current = last) _
                                AndAlso Not (SlavoGermanic) _
                                AndAlso StringAt(RawText, (current - 2), "IE") _
                                AndAlso Not (StringAt(RawText, (current - 4), "ME", "MA"))) Then
                                MetaphAdd(_Primary, _Alternate, "", "R", _AlternateFlag)
                            Else
                                MetaphAdd(_Primary, _Alternate, "R")
                            End If
                            If (GetAt(RawText, current + 1) = "R") Then
                                current += 2
                            Else
                                current += 1
                            End If
                        Case "S"
                            ' special cases 'island', 'isle', 'carlisle', 'carlysle'
                            If (StringAt(RawText, (current - 1), "ISL", "YSL")) Then
                                current += 1
                                Exit Select
                            End If
                            ' special case 'sugar-'
                            If ((current = 0) AndAlso StringAt(RawText, current, "SUGAR")) Then
                                MetaphAdd(_Primary, _Alternate, "X", "S", _AlternateFlag)
                                current += 1
                                Exit Select
                            End If

                            If (StringAt(RawText, current, 2, "SH")) Then
                                ' germanic
                                If (StringAt(RawText, (current + 1), "HEIM", "HOEK", "HOLM", "HOLZ")) Then
                                    MetaphAdd(_Primary, _Alternate, "S")
                                Else
                                    MetaphAdd(_Primary, _Alternate, "X")
                                End If
                                current += 2
                                Exit Select
                            End If

                            ' italian & armenian
                            If (StringAt(RawText, current, "SIO", "SIA") OrElse StringAt(RawText, current, "SIAN")) Then
                                If (Not (SlavoGermanic)) Then
                                    MetaphAdd(_Primary, _Alternate, "S", "X", _AlternateFlag)
                                Else
                                    MetaphAdd(_Primary, _Alternate, "S")
                                End If
                                current += 3
                                Exit Select
                            End If

                            ' german & anglicisations, e.g. 'smith' match 'schmidt', 'snider' match 'schneider'
                            ' also, -sz- in slavic language altho in hungarian it is pronounced 's'
                            If (((current = 0) _
                                AndAlso StringAt(RawText, (current + 1), "M", "N", "L", "W")) _
                                OrElse StringAt(RawText, (current + 1), "Z")) Then
                                MetaphAdd(_Primary, _Alternate, "S", "X", _AlternateFlag)
                                If (StringAt(RawText, (current + 1), "Z")) Then
                                    current += 2
                                Else
                                    current += 1
                                End If
                                Exit Select
                            End If

                            If (StringAt(RawText, current, "SC")) Then
                                ' Schlesinger's rule
                                If (GetAt(RawText, current + 2) = "H") Then
                                    ' dutch origin, e.g. 'school', 'schooner'
                                    If (StringAt(RawText, (current + 3), "OO", "ER", "EN", "UY", "ED", "EM")) Then
                                        ' 'schermerhorn', 'schenker'
                                        If (StringAt(RawText, (current + 3), "ER", "EN")) Then
                                            MetaphAdd(_Primary, _Alternate, "X", "SK", _AlternateFlag)
                                        Else
                                            MetaphAdd(_Primary, _Alternate, "SK")
                                        End If
                                        current += 3
                                        Exit Select
                                    Else
                                        If ((current = 0) AndAlso Not (IsVowel(RawText, 3)) AndAlso (GetAt(RawText, 3) <> "W")) Then
                                            MetaphAdd(_Primary, _Alternate, "X", "S", _AlternateFlag)
                                        Else
                                            MetaphAdd(_Primary, _Alternate, "X")
                                        End If
                                        current += 3
                                        Exit Select
                                    End If
                                End If

                                If (StringAt(RawText, (current + 2), "I", "E", "Y")) Then
                                    MetaphAdd(_Primary, _Alternate, "S")
                                    current += 3
                                    Exit Select
                                End If

                                MetaphAdd(_Primary, _Alternate, "SK")
                                current += 3
                                Exit Select
                            End If

                            ' french e.g. 'resnais', 'artois'
                            If ((current = last) AndAlso StringAt(RawText, (current - 2), "AI", "OI")) Then
                                MetaphAdd(_Primary, _Alternate, "", "S", _AlternateFlag)
                            Else
                                MetaphAdd(_Primary, _Alternate, "S")
                            End If

                            If (StringAt(RawText, (current + 1), "S", "Z")) Then
                                current += 2
                            Else
                                current += 1
                            End If
                        Case "T"
                            If (StringAt(RawText, current, "TION")) Then
                                MetaphAdd(_Primary, _Alternate, "X")
                                current += 3
                                Exit Select
                            End If

                            If (StringAt(RawText, current, "TIA", "TCH")) Then
                                MetaphAdd(_Primary, _Alternate, "X")
                                current += 3
                                Exit Select
                            End If

                            If (StringAt(RawText, current, "TH") _
                                OrElse StringAt(RawText, current, "TTH")) Then
                                ' special case 'thomas', 'thames' OrElse germanic
                                If (StringAt(RawText, (current + 2), "OM", "AM") _
                                        OrElse StringAt(RawText, 0, "VAN ", "VON ") _
                                        OrElse StringAt(RawText, 0, "SCH")) Then
                                    MetaphAdd(_Primary, _Alternate, "T")
                                Else
                                    MetaphAdd(_Primary, _Alternate, "0", "T", _AlternateFlag)
                                End If
                                current += 2
                                Exit Select
                            End If

                            If (StringAt(RawText, (current + 1), "T", "D")) Then
                                current += 2
                            Else
                                current += 1
                            End If
                            MetaphAdd(_Primary, _Alternate, "T")
                        Case "V"
                            If (GetAt(RawText, current + 1) = "V") Then
                                current += 2
                            Else
                                current += 1
                            End If
                            MetaphAdd(_Primary, _Alternate, "F")
                        Case "W"
                            ' can also be in middle of word
                            If (StringAt(RawText, current, "WR")) Then
                                MetaphAdd(_Primary, _Alternate, "R")
                                current += 2
                                Exit Select
                            End If

                            If ((current = 0) _
                            AndAlso (IsVowel(RawText, current + 1) OrElse StringAt(RawText, current, "WH"))) Then
                                ' Wasserman should match Vasserman
                                If (IsVowel(RawText, current + 1)) Then
                                    MetaphAdd(_Primary, _Alternate, "A", "F", _AlternateFlag)
                                Else
                                    ' need Uomo to match Womo
                                    MetaphAdd(_Primary, _Alternate, "A")
                                End If
                                current += 1
                                Exit Select
                            End If

                            ' Arnow should match Arnoff
                            If (((current = last) AndAlso IsVowel(RawText, current - 1)) _
                                   OrElse StringAt(RawText, (current - 1), "EWSKI", "EWSKY", "OWSKI", "OWSKY") _
                                   OrElse StringAt(RawText, 0, "SCH")) Then
                                MetaphAdd(_Primary, _Alternate, "", "F", _AlternateFlag)
                                current += 1
                                Exit Select
                            End If

                            ' polish e.g. 'filipowicz'
                            If (StringAt(RawText, current, "WICZ", "WITZ")) Then
                                MetaphAdd(_Primary, _Alternate, "TS", "FX", _AlternateFlag)
                                current += 4
                                Exit Select
                            End If

                            ' else skip it
                            current += 1
                        Case "X"
                            ' french e.g. breaux
                            If (Not ((current = last) _
                                AndAlso (StringAt(RawText, (current - 3), "IAU", "EAU") _
                                OrElse StringAt(RawText, (current - 2), "AU", "OU")))) Then
                                MetaphAdd(_Primary, _Alternate, "KS")
                            End If
                            If (StringAt(RawText, (current + 1), "C", "X")) Then
                                current += 2
                            Else
                                current += 1
                            End If
                        Case "Z"
                            ' chinese pinyin e.g. 'zhao'
                            If (GetAt(RawText, current + 1) = "H") Then
                                MetaphAdd(_Primary, _Alternate, "J")
                                current += 2
                                Exit Select
                            Else
                                If (StringAt(RawText, (current + 1), "ZO", "ZI", "ZA") _
                                    OrElse (SlavoGermanic AndAlso ((current > 0) AndAlso GetAt(RawText, current - 1) <> "T"))) Then
                                    MetaphAdd(_Primary, _Alternate, "S", "TS", _AlternateFlag)
                                Else
                                    MetaphAdd(_Primary, _Alternate, "S")
                                End If

                                If (GetAt(RawText, current + 1) = "Z") Then
                                    current += 2
                                Else
                                    current += 1
                                End If
                            End If
                        Case Else
                            current += 1
                    End Select
                Loop
            End If
            r.First = _Primary.ToString().PadRight(4, " ").Substring(0, 4)
            r.Second = _Alternate.ToString().PadRight(4, " ").Substring(0, 4)
            Return r
        End Function

        <SqlFunction(IsDeterministic:=True)> _
        Public Shared Function DoubleMetaphoneCompare(ByVal r1 As DoubleMetaphoneResult, ByVal r2 As DoubleMetaphoneResult) As Integer
            Dim i As Integer = 0
            If (r1.First = r2.First) Then
                i = 3
            ElseIf (r1.First = r2.Second AndAlso r2.Second <> "    ") Then
                i = 2
            ElseIf (r1.Second = r2.First AndAlso r1.Second <> "    ") Then
                i = 2
            ElseIf (r1.Second = r2.Second AndAlso r1.Second <> "    " AndAlso r2.Second <> "    ") Then
                i = 1
            End If
            Return i
        End Function

    End Class
End Namespace