CREATE TABLE [dbo].[ServersToCheckDiskStats](
	[PK] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [varchar](128) NOT NULL,
	[PersistLink] [bit] NOT NULL,
	[SQLServerVersion] [char](4) NOT NULL,
	[TrackTotalDiskSpace] [bit] NULL,
 CONSTRAINT [PK_ServersToCheckDiskStats] PRIMARY KEY CLUSTERED 
(
	[PK] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY],
 CONSTRAINT [IX_ServersToCheckDiskStats] UNIQUE NONCLUSTERED 
(
	[ServerName] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

ALTER TABLE [dbo].[ServersToCheckDiskStats] ADD  CONSTRAINT [DF_ServersToCheckDiskStats_PersistLink]  DEFAULT ((0)) FOR [PersistLink]
GO

ALTER TABLE [dbo].[ServersToCheckDiskStats] ADD  CONSTRAINT [DF_ServersToCheckDiskStats_TrackTotalDiskSpace]  DEFAULT ((1)) FOR [TrackTotalDiskSpace]
GO




CREATE TABLE [dbo].[DatabaseDiskStats](
	[PK] [int] IDENTITY(1,1) NOT NULL,
	[ServersToCheckPK] [int] NOT NULL,
	[Server_name] [varchar](128) NOT NULL,
	[Database_name] [varchar](128) NOT NULL,
	[Filename] [varchar](260) NOT NULL,
	[Drive_letter] [char](2) NOT NULL,
	[Size_in_MB] [int] NULL,
	[MaxDriveSize_in_MB] [int] NULL,
	[StatDate] [smalldatetime] NULL,
 CONSTRAINT [PK_DatabaseDiskStats] PRIMARY KEY CLUSTERED 
(
	[PK] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO


CREATE NONCLUSTERED INDEX [IX_StatDate] ON [dbo].[DatabaseDiskStats] 
(
	[StatDate] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
GO



CREATE NONCLUSTERED INDEX [IX_SvrNameDBName] ON [dbo].[DatabaseDiskStats] 
(
	[Server_name] ASC,
	[Database_name] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
GO

ALTER TABLE [dbo].[DatabaseDiskStats]  WITH CHECK ADD  CONSTRAINT [FK_DatabaseDiskStats_ServersToCheckDiskStats] FOREIGN KEY([ServersToCheckPK])
REFERENCES [dbo].[ServersToCheckDiskStats] ([PK])
GO

ALTER TABLE [dbo].[DatabaseDiskStats] CHECK CONSTRAINT [FK_DatabaseDiskStats_ServersToCheckDiskStats]
GO

ALTER TABLE [dbo].[DatabaseDiskStats]  WITH CHECK ADD  CONSTRAINT [FK_DatabaseDiskStats_ServersToCheckDiskStats1] FOREIGN KEY([Server_name])
REFERENCES [dbo].[ServersToCheckDiskStats] ([ServerName])
GO

ALTER TABLE [dbo].[DatabaseDiskStats] CHECK CONSTRAINT [FK_DatabaseDiskStats_ServersToCheckDiskStats1]
GO

ALTER TABLE [dbo].[DatabaseDiskStats] ADD  CONSTRAINT [DF_DatabaseDiskStats_StatDate]  DEFAULT (CONVERT([date],getdate(),(0))) FOR [StatDate]
GO


