# ---------------------------------------------------------------------------
### Author:
### Shaun Stuart
### www.shaunjstuart.com
# ---------------------------------------------------------------------------

$DiskStatsServer = '<your servername here>'
$DiskStatsDB = '<your db name here>'
$SelectQuery = "SELECT DISTINCT server_name, Drive_letter FROM DatabaseDiskStats WHERE MaxDriveSize_in_MB is NULL"

#######################
## MAIN             ##
#######################

$SqlConnection = New-Object System.Data.SqlClient.SqlConnection
$SqlConnection.ConnectionString = "Server=$DiskStatsServer;Database=$DiskStatsDB;Integrated Security=True"


# Can't issue the update command via the same connection as the SELECT because of the DataReader loop, so we need a new connection

$SqlUpdConnection = New-Object System.Data.SqlClient.SqlConnection
$SqlUpdConnection.ConnectionString = "Server=$DiskStatsServer;Database=$DiskStatsDB;Integrated Security=True"

$SqlConnection.open()
$SQLUpdConnection.open()

$SqlCmd = New-Object System.Data.SqlClient.SqlCommand
$SqlCmd.CommandText = $SelectQuery
$SqlCmd.Connection = $SqlConnection


$SqlUpdCmd = New-Object System.Data.SqlClient.SqlCommand
$SqlUpdCmd.Connection = $SqlUpdConnection

$SqlAdapter = New-Object System.Data.SqlClient.SqlDataAdapter
$SqlAdapter.SelectCommand = $SqlCmd


$ds = $SqlCmd.ExecuteReader()
while ($ds.Read()) {
	$Servername = $ds.GetValue(0)
	$DriveLetter = $ds.GetValue(1)

	$Driveobject=gwmi  win32_logicaldisk -computername $servername -filter "DeviceID='$DriveLetter'"
	$DriveSize=$Driveobject.size
	$DriveSize=[int64]$DriveSize/[int64]1024/[int64]1000
	$DriveSize = [math]::Round($DriveSize,0)
	#echo "The server $Servername drive $DriveLetter is $DriveSize MB"


	$UpdateQuery = @"
	UPDATE DatabaseDiskStats
	SET MaxDriveSize_in_MB = '$DriveSize'
	WHERE Server_name = '$ServerName'
		AND Drive_letter = '$DriveLetter'
		AND MaxDriveSize_in_MB is NULL
"@

	$SqlUpdCmd.CommandText = $UpdateQuery
	$SqlUpdCmd.ExecuteNonQuery()


}


$ds.Close()
$SqlConnection.Close()
$SqlUpdConnection.Close()

