@echo off

echo **************************************************************************
echo * Web Server Directory Comparison                                   v1.0 *
echo * Written by Ed Wagner                                          May 2015 *
echo **************************************************************************
echo.

:Initialization
set strServer55=\\172.16.123.55\sites$
set strServer57=\\172.16.123.57\sites$
set strOutput=Z:\Temp

:PerformDirectoryComparison
echo Folder Comparison Started
for /f %%g in ('dir %strServer55% /ad /b ^| findstr /v psdeletions') do (
  <nul (set /p x=  Processing %%g...)
  uc -r -dmb -vert -ne "%strServer55%\%%g" "%strServer57%\%%g" -o "%strOutput%\%%g.uc.txt"
  echo Done
)
echo Folder Comparison Completed

:ConsolidateFiles
echo Post-Comparision Started
<nul (set /p x=  Deleting Consolidated File...)
if exist "%strOutput%\web_compare.txt" del "%strOutput%\web_compare.txt" /f /q
echo Done

<nul (set /p x=  Consolidating Comparison Files...)
for /f %%g in ('dir %strOutput%\*.uc.txt /a-d /b ^| findstr /v web_compare.txt') do (
  type "%strOutput%\%%g" >> "%strOutput%\web_compare.txt"
)
echo Done

:CleanUp
<nul (set /p x=  Deleting Comparison Files...)
for /f %%g in ('dir %strOutput%\*.uc.txt /a-d /b') do (
  del "%strOutput%\%%g" > nul
)
echo Done

<nul (set /p x=  Copying to SQL Server for Processing...)
copy "%strOutput%\web_compare.txt" "\\mysqlserver\myshare$\temp\dba\web_compare.txt" /y > nul
echo Done

:Termination
echo.
echo Processing Terminated Normally
set strServer55=
set strServer57=
set strOutput=
