﻿using System;
using System.Data;
using System.Data.SqlClient;

namespace SchemaToDataSet
{
    class SchemaTest
    {
        public void TestSchemaData()
        {
            // Demonstrates basic techniques for opening a connection to a database and retrieving schema information
            //  and how to use the schema information to build and fill a DataSet at run-time based on the schema information.

            using (SqlConnection conn = new SqlConnection())   // This will dispose of the connection at the end of the using block.
            {
                conn.ConnectionString = "Data Source=(local);Initial Catalog=testDBExamples;Integrated Security=True";
                conn.Open();

                // This gets the collections available for SqlConnection.GetSchema
                DataTable info = conn.GetSchema();
                // This variation gets the same collection of meta-data:
                //   info = conn.GetSchema("MetaDataCollections");

                foreach (DataColumn dc in info.Columns)  // Display the columns in the collection
                {
                    Console.WriteLine("Column Name: {0}  Type: {1}", dc.ColumnName, dc.DataType);
                }
                foreach (DataRow dr in info.Rows)   // Display the collections
                {
                    Console.WriteLine("Collection Name: {0}  Restrictions: {1} ID Parts: {2}",
                        dr["CollectionName"], dr["NumberOfRestrictions"], dr["NumberOfIdentifierParts"]);
                }


                DataTable restrictions = conn.GetSchema("Restrictions");
                foreach (DataColumn dc in restrictions.Columns)
                {
                    Console.WriteLine("Column Name: {0}  Type: {1}", dc.ColumnName, dc.DataType);
                }

                foreach (DataRow dr in restrictions.Rows)
                {
                    Console.WriteLine("{0}  {1}  ", dr["CollectionName"], dr["RestrictionName"]);
                    Console.WriteLine("{0}  {1}  ", dr["ParameterName"], dr["RestrictionDefault"]);
                    Console.WriteLine("{0}  {1}", dr["RestrictionNumber"], "");
                }

                DataRow[] tableRestrictions = restrictions.Select("CollectionName='Tables'");  // This selects only the restrictions for the Tables collection.


                // Using a restriction to limit the rows returned for the Tables collection
                string[] filters = new string[4];
                filters[2] = "Catalog";  // Third parameter is TABLE_NAME. Filter for table name "Catalog"
                DataTable filteredTables = conn.GetSchema("Tables", filters);

                // Return the schema from a DataReader for this query:
                /*  
  Select o.order_id, cust.first_name, cust.last_name, order_date, item_name, quantity, unit_price, unit_price * quantity As total_price From Orders o
  Join Customers cust On o.customer_id = cust.customer_id
  Join OrderDetail d On o.order_id = d.order_id
  Join [Catalog] cat on d.item_id = cat.item_id  */

                SqlCommand cmd = new SqlCommand("Select o.order_id, cust.first_name, cust.last_name, order_date, item_name, quantity, "
                    + " unit_price, unit_price * quantity As total_price From Orders o Join Customers cust On o.customer_id = cust.customer_id "
                    + " Join OrderDetail d On o.order_id = d.order_id Join [Catalog] cat on d.item_id = cat.item_id", conn);

                SqlDataReader rdr = cmd.ExecuteReader();

                DataTable joinSchema = rdr.GetSchemaTable();

                foreach (DataRow dr in joinSchema.Rows)
                {
                    Console.WriteLine("{0}, {1}, {2}", dr["ColumnName"].ToString(), dr["DataTypeName"].ToString(), dr["ColumnSize"].ToString());
                }
                Console.ReadLine();
            }  // end using conn
        }
    }
}
