USE [utildb]
GO

create default [DF_GETDATE] as getdate()
go

/****** Object:  UserDefinedDataType [dbo].[UDT_RECORDTIMESTAMP]    Script Date: 02/10/2011 05:42:35 ******/
CREATE TYPE [dbo].[UDT_RECORDTIMESTAMP] FROM [datetime] NOT NULL
GO

Exec sp_bindefault 'DF_GETDATE', 'UDT_RECORDTIMESTAMP'
go

/****** Object:  Table [dbo].[drsync_databasePermissions]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_databasePermissions](
	[drsync_databasePermissions_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[Database] [sysname] NOT NULL,
	[Object] [sysname] NOT NULL,
	[Grantee] [sysname] NOT NULL,
	[Action] [sysname] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_databasePermissions] PRIMARY KEY CLUSTERED 
(
	[drsync_databasePermissions_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_databasePermissions_compare]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_databasePermissions_compare](
	[drsync_databasePermissions_compare_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[Database] [sysname] NOT NULL,
	[Object] [sysname] NOT NULL,
	[Grantee] [sysname] NOT NULL,
	[Action] [sysname] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_databasePermissions_compare] PRIMARY KEY CLUSTERED 
(
	[drsync_databasePermissions_compare_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_databaseRoles_systemDBs]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_databaseRoles_systemDBs](
	[drsync_databaseRoles_systemDBs_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[Database] [sysname] NOT NULL,
	[DatabaseRole] [sysname] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_databaseRoles_systemDBs] PRIMARY KEY CLUSTERED 
(
	[drsync_databaseRoles_systemDBs_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_databaseRoles_systemDBs_compare]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_databaseRoles_systemDBs_compare](
	[drsync_databaseRoles_systemDBs_compare_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[Database] [sysname] NOT NULL,
	[DatabaseRole] [sysname] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_databaseRoles_systemDBs_compare] PRIMARY KEY CLUSTERED 
(
	[drsync_databaseRoles_systemDBs_compare_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_databases]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_databases](
	[drsync_databases_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[Database] [sysname] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_databases] PRIMARY KEY CLUSTERED 
(
	[drsync_databases_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_databases_compare]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_databases_compare](
	[drsync_databases_compare_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[Database] [sysname] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_databases_compare] PRIMARY KEY CLUSTERED 
(
	[drsync_databases_compare_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_dbmailConfig]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[drsync_dbmailConfig](
	[drsync_dbmailConfig_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[ParamName] [sysname] NOT NULL,
	[ParamValue] [varchar](20) NOT NULL,
	[Description] [varchar](100) NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_dbmailConfig] PRIMARY KEY CLUSTERED 
(
	[drsync_dbmailConfig_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_dbmailConfig_compare]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[drsync_dbmailConfig_compare](
	[drsync_dbmailConfig_compare_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[ParamName] [sysname] NOT NULL,
	[ParamValue] [varchar](20) NOT NULL,
	[Description] [varchar](100) NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_dbmailConfig_compare] PRIMARY KEY CLUSTERED 
(
	[drsync_dbmailConfig_compare_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_jobs]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_jobs](
	[drsync_jobs_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[JobName] [sysname] NOT NULL,
	[JobEnabled] [tinyint] NOT NULL,
	[JobDescription] [nvarchar](512) NULL,
	[JobNotifyLevelEmail] [int] NOT NULL,
	[JobNotifyLevelEventlog] [int] NOT NULL,
	[JobNotifyLevelNetsend] [int] NOT NULL,
	[JobNotifyLevelPage] [int] NOT NULL,
	[JobStartStepId] [int] NOT NULL,
	[CategoryName] [sysname] NOT NULL,
	[OperatorName] [sysname] NULL,
	[OperatorEmail] [nvarchar](100) NULL,
	[OperatorEnabled] [tinyint] NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_jobs] PRIMARY KEY CLUSTERED 
(
	[drsync_jobs_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_jobs_compare]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_jobs_compare](
	[drsync_jobs_compare_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NOT NULL,
	[JobName] [sysname] NOT NULL,
	[JobDescription] [nvarchar](512) NULL,
	[JobNotifyLevelEmail] [int] NOT NULL,
	[JobNotifyLevelEventlog] [int] NOT NULL,
	[JobNotifyLevelNetsend] [int] NOT NULL,
	[JobNotifyLevelPage] [int] NOT NULL,
	[JobStartStepId] [int] NOT NULL,
	[CategoryName] [sysname] NOT NULL,
	[OperatorName] [sysname] NULL,
	[OperatorEmail] [nvarchar](100) NULL,
	[OperatorEnabled] [tinyint] NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_jobs_compare] PRIMARY KEY CLUSTERED 
(
	[drsync_jobs_compare_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_jobschedules]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_jobschedules](
	[drsync_jobschedules_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[JobName] [sysname] NOT NULL,
	[ScheduleEnabled] [int] NOT NULL,
	[ScheduleActiveStartDate] [int] NOT NULL,
	[ScheduleFreqInterval] [int] NOT NULL,
	[ScheduleFreqRecurrenceFactor] [int] NOT NULL,
	[ScheduleFreqRelativeInterval] [int] NOT NULL,
	[ScheduleFreqSubdayInterval] [int] NOT NULL,
	[ScheduleFreqSubdayType] [int] NOT NULL,
	[ScheduleFreqType] [int] NOT NULL,
	[ScheduleName] [sysname] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_jobschedules] PRIMARY KEY CLUSTERED 
(
	[drsync_jobschedules_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_jobschedules_compare]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_jobschedules_compare](
	[drsync_jobschedules_compare_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[JobName] [sysname] NOT NULL,
	[ScheduleEnabled] [int] NOT NULL,
	[ScheduleActiveStartDate] [int] NOT NULL,
	[ScheduleFreqInterval] [int] NOT NULL,
	[ScheduleFreqRecurrenceFactor] [int] NOT NULL,
	[ScheduleFreqRelativeInterval] [int] NOT NULL,
	[ScheduleFreqSubdayInterval] [int] NOT NULL,
	[ScheduleFreqSubdayType] [int] NOT NULL,
	[ScheduleFreqType] [int] NOT NULL,
	[ScheduleName] [sysname] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_jobschedules_compare] PRIMARY KEY CLUSTERED 
(
	[drsync_jobschedules_compare_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_jobsteps]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_jobsteps](
	[drsync_jobsteps_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[JobName] [sysname] NOT NULL,
	[StepId] [int] NOT NULL,
	[StepName] [sysname] NOT NULL,
	[StepCommand] [nvarchar](max) NULL,
	[StepDatabaseName] [sysname] NULL,
	[StepSubsystem] [nvarchar](40) NOT NULL,
	[StepOutputFileName] [nvarchar](200) NULL,
	[StepCmdexecSuccessCode] [int] NULL,
	[StepOnFailAction] [tinyint] NOT NULL,
	[StepOnFailStepId] [int] NOT NULL,
	[StepOnSuccessAction] [tinyint] NOT NULL,
	[StepOnSuccessStepId] [int] NOT NULL,
	[StepProxyId] [int] NULL,
	[StepRetryAttempts] [int] NOT NULL,
	[StepRetryInterval] [int] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_jobsteps] PRIMARY KEY CLUSTERED 
(
	[drsync_jobsteps_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_jobsteps_compare]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_jobsteps_compare](
	[drsync_jobsteps_compare_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[JobName] [sysname] NOT NULL,
	[StepId] [int] NOT NULL,
	[StepName] [sysname] NOT NULL,
	[StepCommand] [nvarchar](max) NULL,
	[StepDatabaseName] [sysname] NULL,
	[StepSubsystem] [nvarchar](40) NOT NULL,
	[StepOutputFileName] [nvarchar](200) NULL,
	[StepCmdexecSuccessCode] [int] NULL,
	[StepOnFailAction] [tinyint] NOT NULL,
	[StepOnFailStepId] [int] NOT NULL,
	[StepOnSuccessAction] [tinyint] NOT NULL,
	[StepOnSuccessStepId] [int] NOT NULL,
	[StepProxyId] [int] NULL,
	[StepRetryAttempts] [int] NOT NULL,
	[StepRetryInterval] [int] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_jobsteps_compare] PRIMARY KEY CLUSTERED 
(
	[drsync_jobsteps_compare_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_linked_servers]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_linked_servers](
	[drsync_linked_servers_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[LinkedServerName] [sysname] NOT NULL,
	[Product] [sysname] NOT NULL,
	[Provider] [sysname] NOT NULL,
	[DataSource] [nvarchar](4000) NOT NULL,
	[Location] [nvarchar](4000) NULL,
	[ProviderString] [nvarchar](4000) NULL,
	[Catalog] [sysname] NULL,
	[ConnectTimeout] [int] NOT NULL,
	[QueryTimeout] [int] NOT NULL,
	[IsRemoteLoginEnabled] [bit] NOT NULL,
	[IsRPC-OutEnabled] [bit] NOT NULL,
	[IsDataAccessEnabled] [bit] NOT NULL,
	[IsCollationCompatible] [bit] NOT NULL,
	[UsesRemoteCollation] [bit] NOT NULL,
	[CollationName] [sysname] NULL,
	[LazySchemaValidation] [bit] NOT NULL,
	[IsSystem] [bit] NOT NULL,
	[IsPublisher] [bit] NOT NULL,
	[IsSubscriber] [bit] NOT NULL,
	[IsDistributor] [bit] NOT NULL,
	[IsNonSqlSubscriber] [bit] NOT NULL,
	[IsRemoteProcTransactionPromotionEnabled] [bit] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_linked_servers] PRIMARY KEY CLUSTERED 
(
	[drsync_linked_servers_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_linked_servers_compare]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_linked_servers_compare](
	[drsync_linked_servers_compare_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[LinkedServerName] [sysname] NOT NULL,
	[Product] [sysname] NOT NULL,
	[Provider] [sysname] NOT NULL,
	[DataSource] [nvarchar](4000) NOT NULL,
	[Location] [nvarchar](4000) NULL,
	[ProviderString] [nvarchar](4000) NULL,
	[Catalog] [sysname] NULL,
	[ConnectTimeout] [int] NOT NULL,
	[QueryTimeout] [int] NOT NULL,
	[IsRemoteLoginEnabled] [bit] NOT NULL,
	[IsRPC-OutEnabled] [bit] NOT NULL,
	[IsDataAccessEnabled] [bit] NOT NULL,
	[IsCollationCompatible] [bit] NOT NULL,
	[UsesRemoteCollation] [bit] NOT NULL,
	[CollationName] [sysname] NULL,
	[LazySchemaValidation] [bit] NOT NULL,
	[IsSystem] [bit] NOT NULL,
	[IsPublisher] [bit] NOT NULL,
	[IsSubscriber] [bit] NOT NULL,
	[IsDistributor] [bit] NOT NULL,
	[IsNonSqlSubscriber] [bit] NOT NULL,
	[IsRemoteProcTransactionPromotionEnabled] [bit] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_linked_servers_compare] PRIMARY KEY CLUSTERED 
(
	[drsync_linked_servers_compare_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_logins]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[drsync_logins](
	[drsync_logins_OID] [int] IDENTITY(1,1) NOT NULL,
	[servername] [sysname] NULL,
	[login] [sysname] NOT NULL,
	[type] [char](1) NOT NULL,
	[type_desc] [nvarchar](60) NOT NULL,
	[is_disabled] [int] NOT NULL,
	[create_date] [datetime] NOT NULL,
	[modify_date] [datetime] NOT NULL,
	[default_database_name] [sysname] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_logins] PRIMARY KEY CLUSTERED 
(
	[drsync_logins_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_logins_compare]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[drsync_logins_compare](
	[drsync_logins_compare_OID] [int] IDENTITY(1,1) NOT NULL,
	[servername] [sysname] NULL,
	[login] [sysname] NOT NULL,
	[type] [char](1) NOT NULL,
	[type_desc] [nvarchar](60) NOT NULL,
	[is_disabled] [int] NOT NULL,
	[create_date] [datetime] NULL,
	[modify_date] [datetime] NULL,
	[default_database_name] [sysname] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_logins_compare] PRIMARY KEY CLUSTERED 
(
	[drsync_logins_compare_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_logins_dbrole_mappings]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_logins_dbrole_mappings](
	[drsync_logins_dbrole_mappings_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[Database] [sysname] NOT NULL,
	[Login] [sysname] NOT NULL,
	[DBRole] [sysname] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_logins_dbrole_mappings] PRIMARY KEY CLUSTERED 
(
	[drsync_logins_dbrole_mappings_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_logins_dbrole_mappings_compare]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_logins_dbrole_mappings_compare](
	[drsync_logins_dbrole_mappings_compare_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[Database] [sysname] NOT NULL,
	[Login] [sysname] NOT NULL,
	[DBRole] [sysname] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_logins_dbrole_mappings_compare] PRIMARY KEY CLUSTERED 
(
	[drsync_logins_dbrole_mappings_compare_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_logins_server_level_permissions]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_logins_server_level_permissions](
	[drsync_logins_server_level_permissions_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[Login] [sysname] NOT NULL,
	[Principal_Type] [nvarchar](60) NOT NULL,
	[Permission_Grantor] [sysname] NOT NULL,
	[Permission_Name] [nvarchar](128) NOT NULL,
	[Permission_State] [nvarchar](60) NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_logins_server_level_permissions] PRIMARY KEY CLUSTERED 
(
	[drsync_logins_server_level_permissions_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_logins_server_level_permissions_compare]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_logins_server_level_permissions_compare](
	[drsync_logins_server_level_permissions_compare_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[Login] [sysname] NOT NULL,
	[Principal_Type] [nvarchar](60) NOT NULL,
	[Permission_Grantor] [sysname] NOT NULL,
	[Permission_Name] [nvarchar](128) NOT NULL,
	[Permission_State] [nvarchar](60) NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_logins_server_level_permissions_compare] PRIMARY KEY CLUSTERED 
(
	[drsync_logins_server_level_permissions_compare_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_logins_server_roles]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_logins_server_roles](
	[drsync_logins_server_roles_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[Login] [sysname] NOT NULL,
	[ServerRole] [sysname] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_logins_server_roles] PRIMARY KEY CLUSTERED 
(
	[drsync_logins_server_roles_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_logins_server_roles_compare]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_logins_server_roles_compare](
	[drsync_logins_server_roles_compare_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[Login] [sysname] NOT NULL,
	[ServerRole] [sysname] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_logins_server_roles_compare] PRIMARY KEY CLUSTERED 
(
	[drsync_logins_server_roles_compare_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_operators]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_operators](
	[drsync_operators_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[OperatorName] [sysname] NULL,
	[OperatorEmail] [nvarchar](100) NULL,
	[OperatorEnabled] [tinyint] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_operators] PRIMARY KEY CLUSTERED 
(
	[drsync_operators_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_operators_compare]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_operators_compare](
	[drsync_operators_compare_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[OperatorName] [sysname] NULL,
	[OperatorEmail] [nvarchar](100) NULL,
	[OperatorEnabled] [tinyint] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_operators_compare] PRIMARY KEY CLUSTERED 
(
	[drsync_operators_compare_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_ProdJobsDisabled]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_ProdJobsDisabled](
	[drsync_ProdJobsDisabled_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[JobName] [sysname] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_ProdJobsDisabled] PRIMARY KEY CLUSTERED 
(
	[drsync_ProdJobsDisabled_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_sp_configure]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_sp_configure](
	[drsync_sp_configure_OID] [int] IDENTITY(1,1) NOT NULL,
	[servername] [sysname] NULL,
	[name] [nvarchar](35) NOT NULL,
	[minimum] [int] NOT NULL,
	[maximum] [int] NOT NULL,
	[config_value] [int] NOT NULL,
	[run_value] [int] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_sp_configure] PRIMARY KEY CLUSTERED 
(
	[drsync_sp_configure_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_sp_configure_compare]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_sp_configure_compare](
	[drsync_sp_configure_compare_OID] [int] IDENTITY(1,1) NOT NULL,
	[servername] [sysname] NOT NULL,
	[setting] [nvarchar](35) NOT NULL,
	[minimum] [int] NOT NULL,
	[maximum] [int] NOT NULL,
	[config_value] [int] NOT NULL,
	[run_value] [int] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_sp_configure_compare] PRIMARY KEY CLUSTERED 
(
	[drsync_sp_configure_compare_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_SSIS_Packages_msdb]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_SSIS_Packages_msdb](
	[drsync_SSIS_Packages_msdb_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[RootFolder] [sysname] NOT NULL,
	[FullPath] [sysname] NOT NULL,
	[PackageName] [sysname] NOT NULL,
	[Verbuild] [int] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_SSIS_Packages_msdb] PRIMARY KEY CLUSTERED 
(
	[drsync_SSIS_Packages_msdb_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_SSIS_Packages_msdb_compare]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[drsync_SSIS_Packages_msdb_compare](
	[drsync_SSIS_Packages_msdb_compare_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[RootFolder] [sysname] NOT NULL,
	[FullPath] [sysname] NOT NULL,
	[PackageName] [sysname] NOT NULL,
	[Verbuild] [int] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_SSIS_Packages_msdb_compare] PRIMARY KEY CLUSTERED 
(
	[drsync_SSIS_Packages_msdb_compare_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_traceflags]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[drsync_traceflags](
	[drsync_traceflags_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[TraceFlag] [varchar](6) NOT NULL,
	[Status] [bit] NOT NULL,
	[Global] [bit] NOT NULL,
	[Session] [bit] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_traceflags] PRIMARY KEY CLUSTERED 
(
	[drsync_traceflags_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

USE [utildb]
GO

/****** Object:  Table [dbo].[drsync_traceflags_compare]    Script Date: 02/10/2011 05:41:00 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[drsync_traceflags_compare](
	[drsync_traceflags_compare_OID] [int] IDENTITY(1,1) NOT NULL,
	[ServerName] [sysname] NULL,
	[TraceFlag] [varchar](6) NOT NULL,
	[Status] [bit] NOT NULL,
	[Global] [bit] NOT NULL,
	[Session] [bit] NOT NULL,
	[db_recordtimestamp] [dbo].[UDT_RECORDTIMESTAMP] NOT NULL,
 CONSTRAINT [PK_drsync_traceflags_compare] PRIMARY KEY CLUSTERED 
(
	[drsync_traceflags_compare_OID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO


