USE [utildb]
GO

/****** Object:  StoredProcedure [dbo].[DRsync__compare_all_settings_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*******************************************************************************************************************************
	Name		:	dbo.DRsync__compare_all_settings_report

	Purpose		:	Reports differences between production and D/R environments

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	10/04/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync__compare_all_settings_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

EXEC [dbo].[DRsync_sp_configure_diff_settings_report] @ProdServer = @ProdServer, @DRServer = @DRServer;

EXEC [dbo].[DRsync_operators_only_on_one_server_report] @ProdServer = @ProdServer, @DRServer = @DRServer;
EXEC [dbo].[DRsync_operators_diff_settings_report] @ProdServer = @ProdServer, @DRServer = @DRServer;

EXEC [dbo].[DRsync_jobs_only_on_one_server_report] @ProdServer = @ProdServer, @DRServer = @DRServer;
EXEC [dbo].[DRsync_jobs_diff_settings_report] @ProdServer = @ProdServer, @DRServer = @DRServer;
EXEC [dbo].[DRsync_jobschedules_diff_settings_report] @ProdServer = @ProdServer, @DRServer = @DRServer;
EXEC [dbo].[DRsync_jobsteps_diff_settings_report] @ProdServer = @ProdServer, @DRServer = @DRServer;

EXEC [dbo].[DRsync_logins_only_on_one_server_report] @ProdServer = @ProdServer, @DRServer = @DRServer;
EXEC [dbo].[DRsync_logins_diff_settings_report] @ProdServer = @ProdServer, @DRServer = @DRServer;
EXEC [dbo].[DRsync_logins_dbrole_mappings_only_on_one_server_report] @ProdServer = @ProdServer, @DRServer = @DRServer;
EXEC [dbo].[DRsync_logins_dbrole_mappings_diff_settings_report] @ProdServer = @ProdServer, @DRServer = @DRServer;
EXEC [dbo].[DRsync_logins_server_level_permissions_only_on_one_server_report] @ProdServer = @ProdServer, @DRServer = @DRServer;
EXEC [dbo].[DRsync_logins_server_roles_only_on_one_server_report] @ProdServer = @ProdServer, @DRServer = @DRServer;

EXEC [dbo].[DRsync_LinkedServers_only_on_one_server_report] @ProdServer = @ProdServer, @DRServer = @DRServer;
EXEC [dbo].[DRsync_LinkedServers_diff_settings_report] @ProdServer = @ProdServer, @DRServer = @DRServer;

EXEC [dbo].[DRsync_TraceFlags_only_on_one_server_report] @ProdServer = @ProdServer, @DRServer = @DRServer;
EXEC [dbo].[DRsync_TraceFlags_diff_settings_report] @ProdServer = @ProdServer, @DRServer = @DRServer;

EXEC [dbo].[DRsync_databases_only_on_one_server_report] @ProdServer = @ProdServer, @DRServer = @DRServer;

EXEC [dbo].[DRsync_databaseRoles_systemDBs_only_on_one_server_report] @ProdServer = @ProdServer, @DRServer = @DRServer;

EXEC [dbo].[DRsync_dbmailConfig_diff_settings_report] @ProdServer = @ProdServer, @DRServer = @DRServer;

EXEC [dbo].[DRsync_databasePermissions_only_on_one_server_report] @ProdServer = @ProdServer, @DRServer = @DRServer;

EXEC [dbo].[DRsync_SSIS_packages_msdb_only_on_one_server_report] @ProdServer = @ProdServer, @DRServer = @DRServer;
EXEC [dbo].[DRsync_SSIS_packages_msdb_diff_settings_report] @ProdServer = @ProdServer, @DRServer = @DRServer;

------------ / dbo.DRsync__compare_all_settings_report ------------------------------------------------------------



GO

/****** Object:  StoredProcedure [dbo].[DRsync_databasePermissions_only_on_one_server_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*******************************************************************************************************************************
	Name		:	dbo.DRsync_databasePermissions_only_on_one_server_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	12/22/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_databasePermissions_only_on_one_server_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

if (exists ( select *
			 from [utildb].[dbo].[drsync_databasePermissions_compare]) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '________Database Permissions - Only On One Server______________________'
	print '_______________________________________________________________________'
	print ' '

	SELECT 
		LEFT(p.[ServerName], 25) AS [ServerName]
	,	LEFT(p.[Database], 50) AS [Database]
	,	LEFT(p.[Object], 50) AS [Object]
	,	LEFT(p.[Grantee], 25) AS [Grantee]
	,	LEFT(p.[Action], 20) AS [Action]
	FROM 
		[utildb].[dbo].[drsync_databasePermissions_compare] p
	ORDER BY 
		p.[ServerName], p.[Database], p.[Object];
end

------------ / dbo.DRsync_databasePermissions_only_on_one_server_report ------------------------------------------------------------



GO

/****** Object:  StoredProcedure [dbo].[DRsync_databaseRoles_systemDBs_only_on_one_server_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_databaseRoles_systemDBs_only_on_one_server_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/27/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_databaseRoles_systemDBs_only_on_one_server_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

if (exists ( select r.[ServerName], r.[Database], r.[DatabaseRole]
			 from [utildb].[dbo].[drsync_databaseRoles_systemDBs_compare] r) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '________Custom Database Roles (System DBs) - Only On One Server________'
	print '_______________________________________________________________________'
	print ' '

	SELECT 
		LEFT(r.[ServerName], 25) AS [ServerName]
	,	LEFT(r.[Database], 50) AS [Database]
	,	LEFT(r.[DatabaseRole], 50) AS [DatabaseRole]
	FROM 
		[utildb].[dbo].[drsync_databaseRoles_systemDBs_compare] r
	ORDER BY 
		r.[ServerName], r.[Database], r.[DatabaseRole];
end

------------ / dbo.DRsync_databaseRoles_systemDBs_only_on_one_server_report ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_databases_only_on_one_server_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_databases_only_on_one_server_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/22/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_databases_only_on_one_server_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE TABLE #databases
(
	[ServerName] [varchar](25) NULL,
	[Database] [varchar](50) NULL
);

INSERT INTO #databases
(
	[ServerName],
	[Database]
)
SELECT 
	LEFT(a.[ServerName],25) as [ServerName]
,	LEFT(a.[Database],50) as [Database]
FROM [utildb].[dbo].[drsync_databases_compare] a
where 
	a.[ServerName] = @ProdServer 
	and a.[Database] NOT IN (SELECT b.[Database] FROM [utildb].[dbo].[drsync_databases_compare] b WHERE b.[ServerName] = @DRServer)

UNION ALL

SELECT 
	LEFT(a.[ServerName],25) as [ServerName]
,	LEFT(a.[Database],50) as [Database]
FROM [utildb].[dbo].[drsync_databases_compare] a
where 
	a.[ServerName] = @DRServer 
	and a.[Database] NOT IN (SELECT b.[Database] FROM [utildb].[dbo].[drsync_databases_compare] b WHERE b.[ServerName] = @ProdServer);

if (exists ( select d.[ServerName], d.[Database]
			 from #databases d) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Databases - Only On One Server____________________'
	print '_______________________________________________________________________'
	print ' '

	select d.[ServerName], d.[Database]
	from #databases d
	ORDER BY d.[ServerName], d.[Database];
end

DROP TABLE #databases;

------------ / dbo.DRsync_databases_only_on_one_server_report ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_dbmailConfig_diff_settings_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_dbmailConfig_diff_settings_report

	Purpose		:	dbmail configuration settings - paramvalue differences between prod and D/R

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/27/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_dbmailConfig_diff_settings_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE table #dbmailConfig
(
	[ServerName] [varchar](25) NULL, 
	[ParamName] [varchar](50) NULL,
	[ParamValue] [varchar](20) NULL, 
	[Description] [varchar](50) NULL,
	[ServerName2] [varchar](25) NULL,
	[ParamName2] [varchar](50) NULL,
	[ParamValue2] [varchar](20) NULL, 
	[Description2] [varchar](50) NULL
);

INSERT INTO #dbmailConfig
(
	[ServerName]  , 
	[ParamName]  ,
	[ParamValue]  , 
	[Description]  ,
	[ServerName2]  ,
	[ParamName2]  ,
	[ParamValue2] ,
	[Description2] 
)
SELECT 
	LEFT(a.[ServerName],25)
	,LEFT(a.[ParamName],50)
	,a.[ParamValue]
	,LEFT(a.[Description],50) 
	,(case when a.[ServerName] = b.[ServerName] then NULL else left(b.[ServerName],25) end) as [ServerName2]
	,(case when a.[ParamName] = b.[ParamName] then NULL else left(b.[ParamName],50) end) as [ParamName2]
	,(case when a.[ParamValue] = b.[ParamValue] then NULL else b.[ParamValue] end) as [ParamValue2]
	,(case when a.[Description] = b.[Description] then NULL else left(b.[Description],50) end) as [Description2] 
  FROM [utildb].[dbo].[drsync_dbmailConfig_compare] a
  join [utildb].[dbo].[drsync_dbmailConfig_compare] b
  on a.[ParamName] = b.[ParamName]
  where a.[ServerName] = @ProdServer and b.[ServerName] = @DRServer	
  order by a.[ParamName];
  
if (exists ( select c.ServerName, c.[ParamName], c.[ParamValue], c.[ParamValue2]
			 from #dbmailConfig c
			 where c.[ParamValue2] is NOT NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________dbmail Config - Param Value_______________________'
	print '_______________________________________________________________________'
	print ' '

	select c.ServerName, c.[ParamName], c.[ParamValue], c.[ParamValue2] AS [ParamValue DR]
	from #dbmailConfig c
	where c.[ParamValue2] is NOT NULL;
end
		
drop table #dbmailConfig;

------------ / dbo.DRsync_dbmailConfig_diff_settings_report ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_DisableAllBusinessJobsDRServer]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_DisableAllBusinessJobsDRServer

	Purpose		:	Disables all business jobs on D/R Server

	Used in		: 	utildb database, D/R servers

	REVISIONS	:	Marios Philippopoulos	10/18/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_DisableAllBusinessJobsDRServer]
AS

SET NOCOUNT ON;

DECLARE @jobName AS SYSNAME;

create table #jobs_to_disable
(
	name sysname
);

insert into #jobs_to_disable
(
	name
)
SELECT 
	[name] 
FROM 
	msdb.dbo.sysjobs
WHERE 
	[name] NOT LIKE 'DBA%' 
	AND [name] NOT LIKE 'SQL Sentry%'
	AND [name] <> 'syspolicy_purge_history';

WHILE EXISTS (SELECT * FROM #jobs_to_disable)
BEGIN
	SELECT TOP 1 @jobName = [name] FROM #jobs_to_disable;

	EXEC msdb.dbo.sp_update_job @job_name = @jobName, @enabled = 0;

	DELETE #jobs_to_disable WHERE [name] = @jobName;
END

drop table #jobs_to_disable;

------------ / dbo.DRsync_DisableAllBusinessJobsDRServer ------------------------------------------------------------

;
;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_jobs_diff_settings_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_jobs_diff_settings_report

	Purpose		:	

	Used in		: 	utildb database 

	NOTES		:	

	REVISIONS	:	Marios Philippopoulos	09/27/2010 	- Initial Release
					Marios Philippopoulos	10/26/2010  - [OperatorEnabled] NULL
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_jobs_diff_settings_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE table #jobs
(
	[ServerName] [varchar](25) NULL,
	[JobName] [varchar](50) NULL,
	[JobDescription] [varchar](50) NULL,
	[JobNotifyLevelEmail] [int] NOT NULL,
	[JobNotifyLevelEventlog] [int] NOT NULL,
	[JobNotifyLevelNetsend] [int] NOT NULL,
	[JobNotifyLevelPage] [int] NOT NULL,
	[JobStartStepId] [int] NOT NULL,
	[CategoryName] [varchar](50) NOT NULL,
	[OperatorName] [varchar](50) NULL,
	[OperatorEmail] [varchar](50) NULL,
	[OperatorEnabled] [tinyint] NULL,
	[ServerName2] [varchar](25) NULL,
	[JobName2] [varchar](50) NULL,
	[JobDescription2] [varchar](50) NULL,
	[JobNotifyLevelEmail2] [int]   NULL,
	[JobNotifyLevelEventlog2] [int] NULL,
	[JobNotifyLevelNetsend2] [int]  NULL,
	[JobNotifyLevelPage2] [int]  NULL,
	[JobStartStepId2] [int] NULL,
	[CategoryName2] [varchar](50) NULL,
	[OperatorName2] [varchar](50) NULL,
	[OperatorEmail2] [varchar](50) NULL,
	[OperatorEnabled2] [tinyint]  NULL
);

INSERT INTO #jobs
(
	[ServerName]
	,[JobName]
	,[JobDescription]
	,[JobNotifyLevelEmail]
	,[JobNotifyLevelEventlog]
	,[JobNotifyLevelNetsend]
	,[JobNotifyLevelPage]
	,[JobStartStepId]
	,[CategoryName]
	,[OperatorName]
	,[OperatorEmail]
	,[OperatorEnabled]
	,[ServerName2]
	,[JobName2]
	,[JobDescription2]
	,[JobNotifyLevelEmail2]
	,[JobNotifyLevelEventlog2]
	,[JobNotifyLevelNetsend2]
	,[JobNotifyLevelPage2]
	,[JobStartStepId2]
	,[CategoryName2]
	,[OperatorName2]
	,[OperatorEmail2]
	,[OperatorEnabled2]
)
SELECT 
	LEFT(a.[ServerName],25)
	,LEFT(a.[JobName],50)
	,LEFT(a.[JobDescription],50)
	,a.[JobNotifyLevelEmail]
	,a.[JobNotifyLevelEventlog]
	,a.[JobNotifyLevelNetsend]
	,a.[JobNotifyLevelPage]
	,a.[JobStartStepId]
	,LEFT(a.[CategoryName],50)
	,LEFT(a.[OperatorName],50)
	,LEFT(a.[OperatorEmail],50)
	,a.[OperatorEnabled]
	,(case when a.[ServerName] = b.[ServerName] then NULL else left(b.[ServerName],25) end) as [ServerName2]
	,(case when a.[JobName] = b.[JobName] then NULL else left(b.[JobName],50) end) as [JobName2]
	,(case when a.[JobDescription] = b.[JobDescription] then NULL else LEFT(b.[JobDescription],50) end) as [JobDescription2]
	,(case when a.[JobNotifyLevelEmail] = b.[JobNotifyLevelEmail] then NULL else b.[JobNotifyLevelEmail] end) as [JobNotifyLevelEmail2]
	,(case when a.[JobNotifyLevelEventlog] = b.[JobNotifyLevelEventlog] then NULL else b.[JobNotifyLevelEventlog] end) as [JobNotifyLevelEventlog2]	
	,(case when a.[JobNotifyLevelNetsend] = b.[JobNotifyLevelNetsend] then NULL else b.[JobNotifyLevelNetsend] end) as [JobNotifyLevelNetsend2]
	,(case when a.[JobNotifyLevelPage] = b.[JobNotifyLevelPage] then NULL else b.[JobNotifyLevelPage] end) as [JobNotifyLevelPage2]
	,(case when a.[JobStartStepId] = b.[JobStartStepId] then NULL else b.[JobStartStepId] end) as [JobStartStepId2]
	,(case when a.[CategoryName] = b.[CategoryName] then NULL else LEFT(b.[CategoryName],50) end) as [CategoryName2]
	,(case when a.[OperatorName] = b.[OperatorName] then NULL else LEFT(b.[OperatorName],50) end) as [OperatorName2]
	,(case when a.[OperatorEmail] = b.[OperatorEmail] then NULL else LEFT(b.[OperatorEmail],50) end) as [OperatorEmail2]	
	,(case when a.[OperatorEnabled] = b.[OperatorEnabled] then NULL else b.[OperatorEnabled] end) as [OperatorEnabled2]	
  FROM [utildb].[dbo].[drsync_jobs_compare] a
  join [utildb].[dbo].[drsync_jobs_compare] b
  on a.[JobName] = b.[JobName]
  where a.[ServerName] = @ProdServer and b.[ServerName] = @DRServer	
  order by a.[JobName];

if (exists ( select j.ServerName, j.JobName, j.JobName2
			 from #jobs j
			 where j.JobName2 is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Jobs - Job Name__________________________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.JobName2 AS [JobName DR]
	from #jobs j
	where j.JobName2 is not NULL;
end
	
if (exists ( select j.ServerName, j.JobName, j.JobDescription, j.JobDescription2
			 from #jobs j
			 where j.JobDescription2 is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Job Description____________________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.JobDescription, j.JobDescription2 AS [JobDescription DR]
	from #jobs j
	where j.JobDescription2 is not NULL;
end

if (exists ( select j.ServerName, j.JobName, j.JobNotifyLevelEmail, j.JobNotifyLevelEmail2
			 from #jobs j
			 where j.JobNotifyLevelEmail2 is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Job Notify Level Email_____________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.JobNotifyLevelEmail, j.JobNotifyLevelEmail2 AS [JobNotifyLevelEmail DR]
	from #jobs j
	where j.JobNotifyLevelEmail2 is not NULL;
end

if (exists ( select j.ServerName, j.JobName, j.JobNotifyLevelEventlog, j.JobNotifyLevelEventlog2
			 from #jobs j
			 where j.JobNotifyLevelEventlog2 is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Job Notify Level Event log_________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.JobNotifyLevelEventlog, j.JobNotifyLevelEventlog2 AS [JobNotifyLevelEventlog DR]
	from #jobs j
	where j.JobNotifyLevelEventlog2 is not NULL;
end

if (exists ( select j.ServerName, j.JobName, j.JobNotifyLevelNetsend, j.JobNotifyLevelNetsend2
			 from #jobs j
			 where j.JobNotifyLevelNetsend2 is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Job Notify Level Net send__________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.JobNotifyLevelNetsend, j.JobNotifyLevelNetsend2 AS [JobNotifyLevelNetsend DR]
	from #jobs j
	where j.JobNotifyLevelNetsend2 is not NULL;
end

if (exists ( select j.ServerName, j.JobName, j.JobNotifyLevelPage, j.JobNotifyLevelPage2
			 from #jobs j
			 where j.JobNotifyLevelPage2 is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Job Notify Level Page______________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.JobNotifyLevelPage, j.JobNotifyLevelPage2 AS [JobNotifyLevelPage DR]
	from #jobs j
	where j.JobNotifyLevelPage2 is not NULL;
end

if (exists ( select j.ServerName, j.JobName, j.JobStartStepId, j.JobStartStepId2
			 from #jobs j
			 where j.JobStartStepId2 is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Job Start Step Id__________________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.JobStartStepId, j.JobStartStepId2 AS [JobStartStepId DR]
	from #jobs j
	where j.JobStartStepId2 is not NULL;
end

if (exists ( select j.ServerName, j.JobName, j.CategoryName, j.CategoryName2
			 from #jobs j
			 where j.CategoryName2 is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Job Category Name__________________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.CategoryName, j.CategoryName2 AS [CategoryName DR]
	from #jobs j
	where j.CategoryName2 is not NULL;
end

if (exists ( select j.ServerName, j.JobName, j.OperatorName, j.OperatorName2
			 from #jobs j
			 where j.OperatorName2 is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Job Operator Name__________________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.OperatorName, j.OperatorName2 AS [OperatorName DR]
	from #jobs j
	where j.OperatorName2 is not NULL;
end

if (exists ( select j.ServerName, j.JobName, j.OperatorEmail, j.OperatorEmail2
			 from #jobs j
			 where j.OperatorEmail2 is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Job Operator Email_________________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.OperatorEmail, j.OperatorEmail2 AS [OperatorEmail DR]
	from #jobs j
	where j.OperatorEmail2 is not NULL;
end

if (exists ( select j.ServerName, j.JobName, j.OperatorEnabled, j.OperatorEnabled2
			 from #jobs j
			 where j.OperatorEnabled2 is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Job Operator Enabled_______________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.OperatorEnabled, j.OperatorEnabled2 AS [OperatorEnabled DR]
	from #jobs j
	where j.OperatorEnabled2 is not NULL;
end
		
drop table #jobs;

------------ / dbo.DRsync_jobs_diff_settings_report ------------------------------------------------------------

;
;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_jobs_only_on_one_server_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_jobs_only_on_one_server_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/09/2010 	- Initial Release
					Marios Philippopoulos	11/03/2010 	- Excluding jobs in D/R server starting with "__DBA -", "DBA -"
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_jobs_only_on_one_server_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE TABLE #jobs
(
	[ServerName] [varchar](25) NULL,
	[JobName] [varchar](50) NULL
);

INSERT INTO #jobs
(
	[ServerName],
	[JobName]
)
SELECT 
	LEFT(a.[ServerName],25) as [ServerName]
,	LEFT(a.[JobName],50) as [JobName]
FROM [utildb].[dbo].[drsync_jobs_compare] a
where 
	a.[ServerName] = @ProdServer 
	and a.[JobName] NOT IN (SELECT b.[JobName] FROM [utildb].[dbo].[drsync_jobs_compare] b WHERE b.[ServerName] = @DRServer)

UNION ALL

SELECT 
	LEFT(a.[ServerName],25) as [ServerName]
,	LEFT(a.[JobName],50) as [JobName]
FROM [utildb].[dbo].[drsync_jobs_compare] a
where 
	a.[ServerName] = @DRServer 
	and a.[JobName] NOT IN (SELECT b.[JobName] FROM [utildb].[dbo].[drsync_jobs_compare] b WHERE b.[ServerName] = @ProdServer)
	AND a.[JobName] NOT LIKE '__DBA -%' AND a.[JobName] NOT LIKE 'DBA -%';

if (exists ( select j.ServerName, j.JobName
			 from #jobs j) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Only On One Server_________________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName
	from #jobs j
	ORDER BY j.ServerName, j.JobName;
end

DROP TABLE #jobs;

------------ / dbo.DRsync_jobs_only_on_one_server_report ------------------------------------------------------------

;
;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_jobschedules_diff_settings_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_jobschedules_diff_settings_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/07/2010 	- Initial Release
					Marios Philippopoulos	10/27/2010 	- Change in the output column name for D/R setting (from "...2" to "... DR"
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_jobschedules_diff_settings_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE table #jobschedules
(
	[ServerName] [varchar](25) NULL,
	[JobName] [varchar](50) NULL,
	[ScheduleEnabled] [int] NULL,
	[ScheduleActiveStartDate] [int] NULL,
	[ScheduleFreqInterval] [int] NULL,
	[ScheduleFreqRecurrenceFactor] [int] NULL,
	[ScheduleFreqRelativeInterval] [int] NULL,
	[ScheduleFreqSubdayInterval] [int] NULL,
	[ScheduleFreqSubdayType] [int] NULL,
	[ScheduleFreqType] [int] NULL,
	[ScheduleName] [varchar](50) NULL,
	[ServerName2] [varchar](25) NULL,
	[JobName2] [varchar](50) NULL,
	[ScheduleEnabled2] [int] NULL,
	[ScheduleActiveStartDate2] [int] NULL,
	[ScheduleFreqInterval2] [int] NULL,
	[ScheduleFreqRecurrenceFactor2] [int] NULL,
	[ScheduleFreqRelativeInterval2] [int] NULL,
	[ScheduleFreqSubdayInterval2] [int] NULL,
	[ScheduleFreqSubdayType2] [int] NULL,
	[ScheduleFreqType2] [int] NULL,
	[ScheduleName2] [varchar](50) NULL
);

INSERT INTO #jobschedules
(
	[ServerName]
	,[JobName]
	,[ScheduleEnabled]
	,[ScheduleActiveStartDate]
	,[ScheduleFreqInterval]
	,[ScheduleFreqRecurrenceFactor]
	,[ScheduleFreqRelativeInterval]
	,[ScheduleFreqSubdayInterval]
	,[ScheduleFreqSubdayType]
	,[ScheduleFreqType]
	,[ScheduleName]
	,[ServerName2]
	,[JobName2]
	,[ScheduleEnabled2]
	,[ScheduleActiveStartDate2]
	,[ScheduleFreqInterval2]
	,[ScheduleFreqRecurrenceFactor2]
	,[ScheduleFreqRelativeInterval2]
	,[ScheduleFreqSubdayInterval2]
	,[ScheduleFreqSubdayType2]
	,[ScheduleFreqType2]
	,[ScheduleName2]
)
SELECT 
	LEFT(a.[ServerName],25)
	,LEFT(a.[JobName],50)
	,a.[ScheduleEnabled]
	,a.[ScheduleActiveStartDate]
	,a.[ScheduleFreqInterval]
	,a.[ScheduleFreqRecurrenceFactor]
	,a.[ScheduleFreqRelativeInterval]
	,a.[ScheduleFreqSubdayInterval]
	,a.[ScheduleFreqSubdayType]
	,a.[ScheduleFreqType]
	,LEFT(a.[ScheduleName],50)
	,(case when a.[ServerName] = b.[ServerName] then NULL else left(b.[ServerName],25) end) as [ServerName2]
	,(case when a.[JobName] = b.[JobName] then NULL else left(b.[JobName],50) end) as [JobName2]
	,(case when a.[ScheduleEnabled] = b.[ScheduleEnabled] then NULL else b.[ScheduleEnabled] end) as [ScheduleEnabled2]
	,(case when a.[ScheduleActiveStartDate] = b.[ScheduleActiveStartDate] then NULL else b.[ScheduleActiveStartDate] end) as [ScheduleActiveStartDate2]
	,(case when a.[ScheduleFreqInterval] = b.[ScheduleFreqInterval] then NULL else b.[ScheduleFreqInterval] end) as [ScheduleFreqInterval2]
	,(case when a.[ScheduleFreqRecurrenceFactor] = b.[ScheduleFreqRecurrenceFactor] then NULL else b.[ScheduleFreqRecurrenceFactor] end) as [ScheduleFreqRecurrenceFactor2]
	,(case when a.[ScheduleFreqRelativeInterval] = b.[ScheduleFreqRelativeInterval] then NULL else b.[ScheduleFreqRelativeInterval] end) as [ScheduleFreqRelativeInterval2]
	,(case when a.[ScheduleFreqSubdayInterval] = b.[ScheduleFreqSubdayInterval] then NULL else b.[ScheduleFreqSubdayInterval] end) as [ScheduleFreqSubdayInterval2]
	,(case when a.[ScheduleFreqSubdayType] = b.[ScheduleFreqSubdayType] then NULL else b.[ScheduleFreqSubdayType] end) as [ScheduleFreqSubdayType2]
	,(case when a.[ScheduleFreqType] = b.[ScheduleFreqType] then NULL else b.[ScheduleFreqType] end) as [ScheduleFreqType2]
	,(case when a.[ScheduleName] = b.[ScheduleName] then NULL else left(b.[ScheduleName],50) end) as [ScheduleName2]
  FROM [utildb].[dbo].[drsync_jobschedules_compare] a
  join [utildb].[dbo].[drsync_jobschedules_compare] b
  on a.[JobName] = b.[JobName]
  where a.[ServerName] = @ProdServer and b.[ServerName] = @DRServer	
  order by a.[JobName];
	
if (exists ( select j.ServerName, j.JobName, j.[ScheduleEnabled], j.[ScheduleEnabled2]
			 from #jobschedules j
			 where j.[ScheduleEnabled2] is NOT NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Schedule Enabled___________________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.[ScheduleEnabled], j.[ScheduleEnabled2] AS [ScheduleEnabled DR]
	from #jobschedules j
	where j.[ScheduleEnabled2] is NOT NULL;
end

if (exists ( select j.ServerName, j.JobName, j.[ScheduleActiveStartDate], j.[ScheduleActiveStartDate2]
			 from #jobschedules j
			 where j.[ScheduleActiveStartDate2] is NOT NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Schedule Active Start Date_________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.[ScheduleActiveStartDate], j.[ScheduleActiveStartDate2] AS [ScheduleActiveStartDate DR]
	from #jobschedules j
	where j.[ScheduleActiveStartDate2] is NOT NULL;
end

if (exists ( select j.ServerName, j.JobName, j.[ScheduleFreqInterval], j.[ScheduleFreqInterval2]
			 from #jobschedules j
			 where j.[ScheduleFreqInterval2] is NOT NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Schedule Freq Interval_____________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.[ScheduleFreqInterval], j.[ScheduleFreqInterval2] AS [ScheduleFreqInterval DR]
	from #jobschedules j
	where j.[ScheduleFreqInterval2] is NOT NULL;
end

if (exists ( select j.ServerName, j.JobName, j.[ScheduleFreqRecurrenceFactor], j.[ScheduleFreqRecurrenceFactor2] 
			 from #jobschedules j
			 where j.[ScheduleFreqRecurrenceFactor2] is NOT NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Schedule Freq Recurrence Factor____________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.[ScheduleFreqRecurrenceFactor], j.[ScheduleFreqRecurrenceFactor2] AS [ScheduleFreqRecurrenceFactor DR]
	from #jobschedules j
	where j.[ScheduleFreqRecurrenceFactor2] is NOT NULL;
end

if (exists ( select j.ServerName, j.JobName, j.[ScheduleFreqRelativeInterval], j.[ScheduleFreqRelativeInterval2] 
			 from #jobschedules j
			 where j.[ScheduleFreqRelativeInterval2] is NOT NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Schedule Freq Relative Interval____________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.[ScheduleFreqRelativeInterval], j.[ScheduleFreqRelativeInterval2] AS [ScheduleFreqRelativeInterval DR]
	from #jobschedules j
	where j.[ScheduleFreqRelativeInterval2] is NOT NULL;
end

if (exists ( select j.ServerName, j.JobName, j.[ScheduleFreqSubdayInterval], j.[ScheduleFreqSubdayInterval2] 
			 from #jobschedules j
			 where j.[ScheduleFreqSubdayInterval2] is NOT NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Schedule Freq Subday Interval______________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.[ScheduleFreqSubdayInterval], j.[ScheduleFreqSubdayInterval2] AS [ScheduleFreqSubdayInterval DR]
	from #jobschedules j
	where j.[ScheduleFreqSubdayInterval2] is NOT NULL;
end

if (exists ( select j.ServerName, j.JobName, j.[ScheduleFreqSubdayType], j.[ScheduleFreqSubdayType2]
			 from #jobschedules j
			 where j.[ScheduleFreqSubdayType2] is NOT NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Schedule Freq Subday Type__________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.[ScheduleFreqSubdayType], j.[ScheduleFreqSubdayType2] AS [ScheduleFreqSubdayType DR]
	from #jobschedules j
	where j.[ScheduleFreqSubdayType2] is NOT NULL;
end

if (exists ( select j.ServerName, j.JobName, j.[ScheduleFreqType], j.[ScheduleFreqType2]
			 from #jobschedules j
			 where j.[ScheduleFreqType2] is NOT NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Schedule Freq Type_________________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.[ScheduleFreqType], j.[ScheduleFreqType2] AS [ScheduleFreqType DR]
	from #jobschedules j
	where j.[ScheduleFreqType2] is NOT NULL;
end

if (exists ( select j.ServerName, j.JobName, j.[ScheduleName], j.[ScheduleName2]
			 from #jobschedules j
			 where j.[ScheduleName2] is NOT NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Schedule Name______________________________'
	print '_______________________________________________________________________'
	print ' '

	select j.ServerName, j.JobName, j.[ScheduleName], j.[ScheduleName2] AS [ScheduleName DR]
	from #jobschedules j
	where j.[ScheduleName2] is NOT NULL;
end
		
drop table #jobschedules;

------------ / dbo.DRsync_jobschedules_diff_settings_report ------------------------------------------------------------

;
;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_jobsteps_diff_settings_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_jobsteps_diff_settings_report

	Purpose		:	

	Used in		: 	utildb database 

	NOTES		:	

	REVISIONS	:	Marios Philippopoulos	09/07/2010 	- Initial Release
					Marios Philippopoulos	10/27/2010 	- Change in the output column name for D/R setting (from "...2" to "... DR"
					Marios Philippopoulos	11/02/2010	- Exclude job "syspolicy_purge_history"
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_jobsteps_diff_settings_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE table #steps
(
	[ServerName] [varchar](25) NULL,
	[JobName] [varchar](50) NULL,
	[StepId] [int] NULL,
	[StepName] [varchar](50) NULL,
	[StepCommand] [varchar](50) NULL,
	[StepDatabaseName] [sysname] NULL,
	[StepSubsystem] [varchar](40) NULL,
	[StepOutputFileName] [varchar](70) NULL,
	[StepCmdexecSuccessCode] [int] NULL,
	[StepOnFailAction] [tinyint] NULL,
	[StepOnFailStepId] [int] NULL,
	[StepOnSuccessAction] [tinyint] NULL,
	[StepOnSuccessStepId] [int] NULL,
	[StepProxyId] [int] NULL,
	[StepRetryAttempts] [int] NULL,
	[StepRetryInterval] [int] NULL,
	[ServerName2] [sysname] NULL,
	[JobName2] [varchar](50) NULL,
	[StepId2] [int] NULL,
	[StepName2] [varchar](50) NULL,
	[StepCommand2] [varchar](50) NULL,
	[StepDatabaseName2] [sysname] NULL,
	[StepSubsystem2] [varchar](40) NULL,
	[StepOutputFileName2] [varchar](70) NULL,
	[StepCmdexecSuccessCode2] [int] NULL,
	[StepOnFailAction2] [tinyint] NULL,
	[StepOnFailStepId2] [int] NULL,
	[StepOnSuccessAction2] [tinyint] NULL,
	[StepOnSuccessStepId2] [int] NULL,
	[StepProxyId2] [int] NULL,
	[StepRetryAttempts2] [int] NULL,
	[StepRetryInterval2] [int] NULL,
);

INSERT INTO #steps
(
	[ServerName] ,
	[JobName]  ,
	[StepId] ,
	[StepName] ,
	[StepCommand] ,
	[StepDatabaseName] ,
	[StepSubsystem] ,
	[StepOutputFileName] ,
	[StepCmdexecSuccessCode] ,
	[StepOnFailAction] ,
	[StepOnFailStepId] ,
	[StepOnSuccessAction] ,
	[StepOnSuccessStepId] ,
	[StepProxyId] ,
	[StepRetryAttempts] ,
	[StepRetryInterval] ,
	[ServerName2] ,
	[JobName2] ,
	[StepId2] ,
	[StepName2] ,
	[StepCommand2] ,
	[StepDatabaseName2] ,
	[StepSubsystem2] ,
	[StepOutputFileName2] ,
	[StepCmdexecSuccessCode2] ,
	[StepOnFailAction2] ,
	[StepOnFailStepId2] ,
	[StepOnSuccessAction2] ,
	[StepOnSuccessStepId2] ,
	[StepProxyId2] ,
	[StepRetryAttempts2] ,
	[StepRetryInterval2] )
SELECT 
	LEFT(a.[ServerName],25)
	,LEFT(a.[JobName],50)
	,a.[StepId]
	,LEFT(a.[StepName],50)
	,left(a.[StepCommand],50)
	,a.[StepDatabaseName]
	,a.[StepSubsystem]
	,left(a.[StepOutputFileName],70)
	,a.[StepCmdexecSuccessCode]
	,a.[StepOnFailAction]
	,a.[StepOnFailStepId]
	,a.[StepOnSuccessAction]
	,a.[StepOnSuccessStepId]
	,a.[StepProxyId]
	,a.[StepRetryAttempts]
	,a.[StepRetryInterval]
	,(case when a.[ServerName] = b.[ServerName] then NULL else left(b.[ServerName],25) end) as [ServerName2]
	,(case when a.[JobName] = b.[JobName] then NULL else left(b.[JobName],50) end) as [JobName2]
	,(case when a.[StepId] = b.[StepId] then NULL else b.[StepId] end) as [StepId2]
	,(case when a.[StepName] = b.[StepName] then NULL else left(b.[StepName],50) end) as [StepName2]
	,(case when a.[StepCommand] = b.[StepCommand] then NULL else left(b.[StepCommand],50) end) as [StepCommand2]	
	,(case when a.[StepDatabaseName] = b.[StepDatabaseName] then NULL else b.[StepDatabaseName] end) as [StepDatabaseName2]
	,(case when a.[StepSubsystem] = b.[StepSubsystem] then NULL else b.[StepSubsystem] end) as [StepSubsystem2]
	,(case when a.[StepOutputFileName] = b.[StepOutputFileName] then NULL else left(b.[StepOutputFileName],70) end) as [StepOutputFileName2]
	,(case when a.[StepCmdexecSuccessCode] = b.[StepCmdexecSuccessCode] then NULL else b.[StepCmdexecSuccessCode] end) as [StepCmdexecSuccessCode2]
	,(case when a.[StepOnFailAction] = b.[StepOnFailAction] then NULL else b.[StepOnFailAction] end) as [StepOnFailAction2]
	,(case when a.[StepOnFailStepId] = b.[StepOnFailStepId] then NULL else b.[StepOnFailStepId] end) as [StepOnFailStepId2]	
	,(case when a.[StepOnSuccessAction] = b.[StepOnSuccessAction] then NULL else b.[StepOnSuccessAction] end) as [StepOnSuccessAction2]	
	,(case when a.[StepOnSuccessStepId] = b.[StepOnSuccessStepId] then NULL else b.[StepOnSuccessStepId] end) as [StepOnSuccessStepId2]	
	,(case when a.[StepProxyId] = b.[StepProxyId] then NULL else b.[StepProxyId] end) as [StepProxyId2]	
	,(case when a.[StepRetryAttempts] = b.[StepRetryAttempts] then NULL else b.[StepRetryAttempts] end) as [StepRetryAttempts2]	
	,(case when a.[StepRetryInterval] = b.[StepRetryInterval] then NULL else b.[StepRetryInterval] end) as [StepRetryInterval2]	
  FROM [utildb].[dbo].[drsync_jobsteps_compare] a
  join [utildb].[dbo].[drsync_jobsteps_compare] b
  on a.[JobName] = b.[JobName] and a.StepId = b.StepId
  where a.[ServerName] = @ProdServer and b.[ServerName] = @DRServer	
  AND a.[JobName] <> 'syspolicy_purge_history'
  order by a.[JobName];

if (exists ( select s.ServerName, s.JobName, s.StepId, s.StepName, s.StepName2
			 from #steps s
			 where s.StepName2 is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Jobs - Step Name__________________________________'
	print '_______________________________________________________________________'
	print ' '

	select s.ServerName, s.JobName, s.StepId, s.StepName, s.StepName2 AS [StepName DR]
	from #steps s
	where s.StepName2 is not NULL;
end
	
if (exists ( select s.ServerName, s.JobName, s.StepId, s.StepCommand, s.StepCommand2
			 from #steps s
			 where s.StepCommand2 is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Step Command_______________________________'
	print '_______________________________________________________________________'
	print ' '

	select s.ServerName, s.JobName, s.StepId
	from #steps s
	where s.StepCommand2 is not NULL;
end

if (exists ( select s.ServerName, s.JobName, s.StepId, s.[StepDatabaseName], s.[StepDatabaseName2]
			 from #steps s
			 where s.[StepDatabaseName2] is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Step Database Name_________________________'
	print '_______________________________________________________________________'
	print ' '

	select s.ServerName, s.JobName, s.StepId, s.[StepDatabaseName], s.[StepDatabaseName2] AS [StepDatabaseName DR]
	from #steps s
	where s.[StepDatabaseName2] is not NULL;
end
	
if (exists ( select s.ServerName, s.JobName, s.StepId, s.[StepSubsystem], s.[StepSubsystem2]
			 from #steps s
			 where s.[StepSubsystem2] is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Step Subsystem_____________________________'
	print '_______________________________________________________________________'
	print ' '
	
	select s.ServerName, s.JobName, s.StepId, s.[StepSubsystem], s.[StepSubsystem2] AS [StepSubsystem DR]
	from #steps s
	where s.[StepSubsystem2] is not NULL;
end
	
if (exists ( select s.ServerName, s.JobName, s.StepId, s.[StepOutputFileName], s.[StepOutputFileName2]
			 from #steps s
			 where s.[StepOutputFileName2] is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Step OutputFile____________________________'
	print '_______________________________________________________________________'
	print ' '
	
	select s.ServerName, s.JobName, s.StepId, s.[StepOutputFileName], s.[StepOutputFileName2] AS [StepOutputFileName DR]
	from #steps s
	where s.[StepOutputFileName2] is not NULL;
end
	
if (exists ( select s.ServerName, s.JobName, s.StepId, s.[StepCmdexecSuccessCode], s.[StepCmdexecSuccessCode2]
			 from #steps s
			 where s.[StepCmdexecSuccessCode2] is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Step CmdexecSuccessCode____________________'
	print '_______________________________________________________________________'
	print ' '
	
	select s.ServerName, s.JobName, s.StepId, s.[StepCmdexecSuccessCode], s.[StepCmdexecSuccessCode2] AS [StepCmdexecSuccessCode DR]
	from #steps s
	where s.[StepCmdexecSuccessCode2] is not NULL;
end
	
if (exists ( select s.ServerName, s.JobName, s.StepId, s.[StepOnFailAction], s.[StepOnFailAction2]
			 from #steps s
			 where s.[StepOnFailAction2] is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Step StepOnFailAction______________________'
	print '_______________________________________________________________________'
	print ' '
	
	select s.ServerName, s.JobName, s.StepId, s.[StepOnFailAction], s.[StepOnFailAction2] AS [StepOnFailAction DR]
	from #steps s
	where s.[StepOnFailAction2] is not NULL;
end

if (exists ( select s.ServerName, s.JobName, s.StepId, s.[StepOnFailStepId], s.[StepOnFailStepId2]
			 from #steps s
			 where s.[StepOnFailStepId2] is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Step StepOnFailStepId______________________'
	print '_______________________________________________________________________'
	print ' '
	
	select s.ServerName, s.JobName, s.StepId, s.[StepOnFailStepId], s.[StepOnFailStepId2] AS [StepOnFailStepId DR]
	from #steps s
	where s.[StepOnFailStepId2] is not NULL;
end
	
if (exists ( select s.ServerName, s.JobName, s.StepId, s.[StepOnSuccessAction], s.[StepOnSuccessAction2]
			 from #steps s
			 where s.[StepOnSuccessAction2] is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Step StepOnSuccessAction___________________'
	print '_______________________________________________________________________'
	print ' '
	
	select s.ServerName, s.JobName, s.StepId, s.[StepOnSuccessAction], s.[StepOnSuccessAction2] AS [StepOnSuccessAction DR]
	from #steps s
	where s.[StepOnSuccessAction2] is not NULL;
end

if (exists ( select s.ServerName, s.JobName, s.StepId, s.[StepOnSuccessStepId], s.[StepOnSuccessStepId2]
			 from #steps s
			 where s.[StepOnSuccessStepId2] is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Step StepOnSuccessStepId___________________'
	print '_______________________________________________________________________'
	print ' '
	
	select s.ServerName, s.JobName, s.StepId, s.[StepOnSuccessStepId], s.[StepOnSuccessStepId2] AS [StepOnSuccessStepId DR]
	from #steps s
	where s.[StepOnSuccessStepId2] is not NULL;
end
	
if (exists ( select s.ServerName, s.JobName, s.StepId, s.[StepProxyId], s.[StepProxyId2]
			 from #steps s
			 where s.[StepProxyId2] is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Step StepProxyId___________________________'
	print '_______________________________________________________________________'
	print ' '
	
	select s.ServerName, s.JobName, s.StepId, s.[StepProxyId], s.[StepProxyId2] AS [StepProxyId DR]
	from #steps s
	where s.[StepProxyId2] is not NULL;
end
	
if (exists ( select s.ServerName, s.JobName, s.StepId, s.[StepRetryAttempts], s.[StepRetryAttempts2]
			 from #steps s
			 where s.[StepRetryAttempts2] is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Step StepRetryAttempts_____________________'
	print '_______________________________________________________________________'
	print ' '
	
	select s.ServerName, s.JobName, s.StepId, s.[StepRetryAttempts], s.[StepRetryAttempts2] AS [StepRetryAttempts DR]
	from #steps s
	where s.[StepRetryAttempts2] is not NULL;
end
	
if (exists ( select s.ServerName, s.JobName, s.StepId, s.[StepRetryInterval], s.[StepRetryInterval2]
			 from #steps s
			 where s.[StepRetryInterval2] is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Jobs - Step StepRetryInterval_____________________'
	print '_______________________________________________________________________'
	print ' '
	
	select s.ServerName, s.JobName, s.StepId, s.[StepRetryInterval], s.[StepRetryInterval2] AS [StepRetryInterval DR]
	from #steps s
	where s.[StepRetryInterval2] is not NULL;
end
		
drop table #steps;

------------ / dbo.DRsync_jobsteps_diff_settings_report ------------------------------------------------------------

;
;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_LinkedServers_diff_settings_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_LinkedServers_diff_settings_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/21/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_LinkedServers_diff_settings_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE table #linkedservers
(
	[ServerName] [varchar](25) NULL,
	[LinkedServerName] [varchar](50) NULL,
	[Product] [varchar](25) NULL,
	[Provider] [varchar](25) NULL,
	[DataSource] [Nvarchar](30) NULL,
	[Location] [Nvarchar](30) NULL,
	[ProviderString] [Nvarchar](30) NULL,
	[Catalog] [varchar](50) NULL,
	[ConnectTimeout] [int] NULL,
	[QueryTimeout] [int] NULL,
	[IsRemoteLoginEnabled] [bit] NULL,
	[IsRPC-OutEnabled] [bit] NULL,
	[IsDataAccessEnabled] [bit] NULL,
	[IsCollationCompatible] [bit] NULL,
	[UsesRemoteCollation] [bit] NULL,
	[CollationName] [varchar](50) NULL,
	[LazySchemaValidation] [bit] NULL,
	[IsSystem] [bit] NULL,
	[IsPublisher] [bit] NULL,
	[IsSubscriber] [bit] NULL,
	[IsDistributor] [bit] NULL,
	[IsNonSqlSubscriber] [bit] NULL,
	[IsRemoteProcTransactionPromotionEnabled] [bit] NULL,	
	[ServerName2] [varchar](25) NULL,
	[LinkedServerName2] [varchar](50) NULL,
	[Product2] [varchar](25) NULL,
	[Provider2] [varchar](25) NULL,
	[DataSource2] [Nvarchar](30) NULL,
	[Location2] [Nvarchar](30) NULL,
	[ProviderString2] [Nvarchar](30) NULL,
	[Catalog2] [varchar](50) NULL,
	[ConnectTimeout2] [int] NULL,
	[QueryTimeout2] [int] NULL,
	[IsRemoteLoginEnabled2] [bit] NULL,
	[IsRPC-OutEnabled2] [bit] NULL,
	[IsDataAccessEnabled2] [bit] NULL,
	[IsCollationCompatible2] [bit] NULL,
	[UsesRemoteCollation2] [bit] NULL,
	[CollationName2] [varchar](50) NULL,
	[LazySchemaValidation2] [bit] NULL,
	[IsSystem2] [bit] NULL,
	[IsPublisher2] [bit] NULL,
	[IsSubscriber2] [bit] NULL,
	[IsDistributor2] [bit] NULL,
	[IsNonSqlSubscriber2] [bit] NULL,
	[IsRemoteProcTransactionPromotionEnabled2] [bit] NULL
);

INSERT INTO #linkedservers
(
	[ServerName]  ,
	[LinkedServerName]  ,
	[Product]  ,
	[Provider]  ,
	[DataSource]  ,
	[Location] ,
	[ProviderString]  ,
	[Catalog]  ,
	[ConnectTimeout]  ,
	[QueryTimeout]  ,
	[IsRemoteLoginEnabled] ,
	[IsRPC-OutEnabled] ,
	[IsDataAccessEnabled]  ,
	[IsCollationCompatible]  ,
	[UsesRemoteCollation]  ,
	[CollationName]  ,
	[LazySchemaValidation]  ,
	[IsSystem]  ,
	[IsPublisher]  ,
	[IsSubscriber]  ,
	[IsDistributor]  ,
	[IsNonSqlSubscriber]  ,
	[IsRemoteProcTransactionPromotionEnabled] ,	
	[ServerName2]  ,
	[LinkedServerName2]  ,
	[Product2]  ,
	[Provider2]  ,
	[DataSource2]  ,
	[Location2]  ,
	[ProviderString2]  ,
	[Catalog2]  ,
	[ConnectTimeout2]  ,
	[QueryTimeout2]  ,
	[IsRemoteLoginEnabled2] ,
	[IsRPC-OutEnabled2] ,
	[IsDataAccessEnabled2]  ,
	[IsCollationCompatible2]  ,
	[UsesRemoteCollation2]  ,
	[CollationName2]  ,
	[LazySchemaValidation2]  ,
	[IsSystem2]  ,
	[IsPublisher2]  ,
	[IsSubscriber2]  ,
	[IsDistributor2]  ,
	[IsNonSqlSubscriber2]  ,
	[IsRemoteProcTransactionPromotionEnabled2]
)
SELECT 
	LEFT(a.[ServerName],25)
	,LEFT(a.[LinkedServerName],50)
	,LEFT(a.[Product],25)
	,LEFT(a.[Provider],25)
	,LEFT(a.[DataSource],30)
	,LEFT(a.[Location],30)
	,LEFT(a.[ProviderString],30)
	,LEFT(a.[Catalog],50)
	,a.[ConnectTimeout]
	,a.[QueryTimeout]
	,a.[IsRemoteLoginEnabled]
	,a.[IsRPC-OutEnabled]
	,a.[IsDataAccessEnabled] 
	,a.[IsCollationCompatible] 
	,a.[UsesRemoteCollation] 
	,LEFT(a.[CollationName],50)
	,a.[LazySchemaValidation] 
	,a.[IsSystem]  
	,a.[IsPublisher]  
	,a.[IsSubscriber]   
	,a.[IsDistributor]   
	,a.[IsNonSqlSubscriber]   
	,a.[IsRemoteProcTransactionPromotionEnabled]  		
	,(case when a.[ServerName] = b.[ServerName] then NULL else left(b.[ServerName],25) end) as [ServerName2]
	,(case when a.[LinkedServerName] = b.[LinkedServerName] then NULL else LEFT(b.[LinkedServerName],50) end) as [LinkedServerName2]
	,(case when a.[Product] = b.[Product] then NULL else LEFT(b.[Product],25) end) as [Product2]	
	,(case when a.[Provider] = b.[Provider] then NULL else LEFT(b.[Provider],25) end) as [Provider2]	
	,(case when a.[DataSource] = b.[DataSource] then NULL else LEFT(b.[DataSource],30) end) as [DataSource2]	
	,(case when a.[Location] = b.[Location] then NULL else LEFT(b.[Location],30) end) as [Location2]	
	,(case when a.[ProviderString] = b.[ProviderString] then NULL else LEFT(b.[ProviderString],30) end) as [ProviderString2]	
	,(case when a.[Catalog] = b.[Catalog] then NULL else LEFT(b.[Catalog],50) end) as [Catalog2]
	,(case when a.[ConnectTimeout] = b.[ConnectTimeout] then NULL else b.[ConnectTimeout] end) as [ConnectTimeout2]	
	,(case when a.[QueryTimeout] = b.[QueryTimeout] then NULL else b.[QueryTimeout] end) as [QueryTimeout2]	
	,(case when a.[IsRemoteLoginEnabled] = b.[IsRemoteLoginEnabled] then NULL else b.[IsRemoteLoginEnabled] end) as [IsRemoteLoginEnabled2]	
	,(case when a.[IsRPC-OutEnabled] = b.[IsRPC-OutEnabled] then NULL else b.[IsRPC-OutEnabled] end) as [IsRPC-OutEnabled2]	
	,(case when a.[IsDataAccessEnabled] = b.[IsDataAccessEnabled] then NULL else b.[IsDataAccessEnabled] end) as [IsDataAccessEnabled2]	
	,(case when a.[IsCollationCompatible] = b.[IsCollationCompatible] then NULL else b.[IsCollationCompatible] end) as [IsCollationCompatible2]	
	,(case when a.[UsesRemoteCollation] = b.[UsesRemoteCollation] then NULL else b.[UsesRemoteCollation] end) as [UsesRemoteCollation2]	
	,(case when a.[CollationName] = b.[CollationName] then NULL else LEFT(b.[CollationName],50) end) as [CollationName2]
	,(case when a.[LazySchemaValidation] = b.[LazySchemaValidation] then NULL else b.[LazySchemaValidation] end) as [LazySchemaValidation2]
	,(case when a.[IsSystem] = b.[IsSystem] then NULL else b.[IsSystem] end) as [IsSystem2]
	,(case when a.[IsPublisher] = b.[IsPublisher] then NULL else b.[IsPublisher] end) as [IsPublisher2]
	,(case when a.[IsSubscriber] = b.[IsSubscriber] then NULL else b.[IsSubscriber] end) as [IsSubscriber2]
	,(case when a.[IsDistributor] = b.[IsDistributor] then NULL else b.[IsDistributor] end) as [IsDistributor2]
	,(case when a.[IsNonSqlSubscriber] = b.[IsNonSqlSubscriber] then NULL else b.[IsNonSqlSubscriber] end) as [IsNonSqlSubscriber2]
	,(case when a.[IsRemoteProcTransactionPromotionEnabled] = b.[IsRemoteProcTransactionPromotionEnabled] then NULL else b.[IsRemoteProcTransactionPromotionEnabled] end) as [IsRemoteProcTransactionPromotionEnabled2]
FROM [utildb].[dbo].[drsync_linked_servers_compare] a
INNER JOIN [utildb].[dbo].[drsync_linked_servers_compare] b
ON a.[LinkedServerName] = b.[LinkedServerName]
WHERE a.[ServerName] = @ProdServer AND b.[ServerName] = @DRServer	
ORDER BY a.[LinkedServerName];

if (exists ( select l.[ServerName], l.[LinkedServerName], l.[Provider], l.[Provider2]
			 from #linkedservers l
			 where l.[Provider2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Linked Servers - Provider_________________________'
	print '_______________________________________________________________________'
	print ' '

	select l.[ServerName], l.[LinkedServerName], l.[Provider], l.[Provider2] as [Provider DR]
	from #linkedservers l
	where l.[Provider2] is not NULL;
end
	
if (exists ( select l.[ServerName], l.[LinkedServerName], l.[DataSource], l.[DataSource2]
			 from #linkedservers l
			 where l.[DataSource2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Linked Servers - Data Source______________________'
	print '_______________________________________________________________________'
	print ' '

	select l.[ServerName], l.[LinkedServerName], l.[DataSource], l.[DataSource2] as [DataSource DR]
	from #linkedservers l
	where l.[DataSource2] is not NULL;
end

if (exists ( select l.[ServerName], l.[LinkedServerName], l.[Catalog], l.[Catalog2]
			 from #linkedservers l
			 where l.[Catalog2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Linked Servers - Catalog__________________________'
	print '_______________________________________________________________________'
	print ' '

	select l.[ServerName], l.[LinkedServerName], l.[Catalog], l.[Catalog2] as [Catalog DR]
	from #linkedservers l
	where l.[Catalog2] is not NULL;
end

if (exists ( select l.[ServerName], l.[LinkedServerName], l.[ConnectTimeout], l.[ConnectTimeout2]
			 from #linkedservers l
			 where l.[ConnectTimeout2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Linked Servers - Connect Timeout__________________'
	print '_______________________________________________________________________'
	print ' '

	select l.[ServerName], l.[LinkedServerName], l.[ConnectTimeout], l.[ConnectTimeout2] as [ConnectTimeout DR]
	from #linkedservers l
	where l.[ConnectTimeout2] is not NULL;
end

if (exists ( select l.[ServerName], l.[LinkedServerName], l.[QueryTimeout], l.[QueryTimeout2]
			 from #linkedservers l
			 where l.[QueryTimeout2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Linked Servers - Query Timeout____________________'
	print '_______________________________________________________________________'
	print ' '

	select l.[ServerName], l.[LinkedServerName], l.[QueryTimeout], l.[QueryTimeout2] as [QueryTimeout DR]
	from #linkedservers l
	where l.[QueryTimeout2] is not NULL;
end

if (exists ( select l.[ServerName], l.[LinkedServerName], l.[IsRemoteLoginEnabled], l.[IsRemoteLoginEnabled2]
			 from #linkedservers l
			 where l.[IsRemoteLoginEnabled2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Linked Servers - Is Remote Login Enabled__________'
	print '_______________________________________________________________________'
	print ' '

	select l.[ServerName], l.[LinkedServerName], l.[IsRemoteLoginEnabled], l.[IsRemoteLoginEnabled2] as [IsRemoteLoginEnabled DR]
	from #linkedservers l
	where l.[IsRemoteLoginEnabled2] is not NULL;
end

if (exists ( select l.[ServerName], l.[LinkedServerName], l.[IsRPC-OutEnabled], l.[IsRPC-OutEnabled2]
			 from #linkedservers l
			 where l.[IsRPC-OutEnabled2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Linked Servers - Is RPC-Out Enabled_______________'
	print '_______________________________________________________________________'
	print ' '

	select l.[ServerName], l.[LinkedServerName], l.[IsRPC-OutEnabled], l.[IsRPC-OutEnabled2] as [IsRPC-OutEnabled DR]
	from #linkedservers l
	where l.[IsRPC-OutEnabled2] is not NULL;
end

if (exists ( select l.[ServerName], l.[LinkedServerName], l.[IsDataAccessEnabled], l.[IsDataAccessEnabled2]
			 from #linkedservers l
			 where l.[IsDataAccessEnabled2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Linked Servers - Is Data-Access Enabled___________'
	print '_______________________________________________________________________'
	print ' '

	select l.[ServerName], l.[LinkedServerName], l.[IsDataAccessEnabled], l.[IsDataAccessEnabled2] as [IsDataAccessEnabled DR]
	from #linkedservers l
	where l.[IsDataAccessEnabled2] is not NULL;
end

if (exists ( select l.[ServerName], l.[LinkedServerName], l.[IsCollationCompatible], l.[IsCollationCompatible2]
			 from #linkedservers l
			 where l.[IsCollationCompatible2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Linked Servers - Is Collation Compatible__________'
	print '_______________________________________________________________________'
	print ' '

	select l.[ServerName], l.[LinkedServerName], l.[IsCollationCompatible], l.[IsCollationCompatible2] as [IsCollationCompatible DR]
	from #linkedservers l
	where l.[IsCollationCompatible2] is not NULL;
end

if (exists ( select l.[ServerName], l.[LinkedServerName], l.[UsesRemoteCollation], l.[UsesRemoteCollation2]
			 from #linkedservers l
			 where l.[UsesRemoteCollation2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Linked Servers - Uses Remote Collation____________'
	print '_______________________________________________________________________'
	print ' '

	select l.[ServerName], l.[LinkedServerName], l.[UsesRemoteCollation], l.[UsesRemoteCollation2] as [UsesRemoteCollation DR]
	from #linkedservers l
	where l.[UsesRemoteCollation2] is not NULL;
end

if (exists ( select l.[ServerName], l.[LinkedServerName], l.[CollationName], l.[CollationName2]
			 from #linkedservers l
			 where l.[CollationName2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Linked Servers - Collation Name___________________'
	print '_______________________________________________________________________'
	print ' '

	select l.[ServerName], l.[LinkedServerName], l.[CollationName], l.[CollationName2] as [CollationName DR]
	from #linkedservers l
	where l.[CollationName2] is not NULL;
end

if (exists ( select l.[ServerName], l.[LinkedServerName], l.[IsRemoteProcTransactionPromotionEnabled], l.[IsRemoteProcTransactionPromotionEnabled2]
			 from #linkedservers l
			 where l.[IsRemoteProcTransactionPromotionEnabled2] is not NULL ) )
begin
	print ' '
	print '_____________________________________________________________________________'
	print '_________Linked Servers - IsRemoteProcTransactionPromotionEnabled____________'
	print '_____________________________________________________________________________'
	print ' '

	select l.[ServerName], l.[LinkedServerName], l.[IsRemoteProcTransactionPromotionEnabled], l.[IsRemoteProcTransactionPromotionEnabled2] as [IsRemoteProcTransactionPromotionEnabled DR]
	from #linkedservers l
	where l.[IsRemoteProcTransactionPromotionEnabled2] is not NULL;
end
		
drop table #linkedservers;

------------ / dbo.DRsync_LinkedServers_diff_settings_report ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_LinkedServers_only_on_one_server_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_LinkedServers_only_on_one_server_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/21/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_LinkedServers_only_on_one_server_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE TABLE #linkedservers
(
	[ServerName] [varchar](25) NULL,
	[LinkedServerName] [varchar](50) NULL
);

INSERT INTO #linkedservers
(
	[ServerName],
	[LinkedServerName]
)
SELECT 
	LEFT(a.[ServerName],25) as [ServerName]
,	LEFT(a.[LinkedServerName],50) as [LinkedServerName]
FROM [utildb].[dbo].[drsync_linked_servers_compare] a
where 
	a.[ServerName] = @ProdServer 
	and a.[LinkedServerName] NOT IN (SELECT b.[LinkedServerName] FROM [utildb].[dbo].[drsync_linked_servers_compare] b WHERE b.[ServerName] = @DRServer)

UNION ALL

SELECT 
	LEFT(a.[ServerName],25) as [ServerName]
,	LEFT(a.[LinkedServerName],50) as [LinkedServerName]
FROM [utildb].[dbo].[drsync_linked_servers_compare] a
where 
	a.[ServerName] = @DRServer 
	and a.[LinkedServerName] NOT IN (SELECT b.[LinkedServerName] FROM [utildb].[dbo].[drsync_linked_servers_compare] b WHERE b.[ServerName] = @ProdServer);

if (exists ( select l.[ServerName], l.[LinkedServerName]
			 from #linkedservers l) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Linked Servers - Only On One Server_______________'
	print '_______________________________________________________________________'
	print ' '

	select l.[ServerName], l.[LinkedServerName]
	from #linkedservers l
	ORDER BY l.[ServerName], l.[LinkedServerName];
end

DROP TABLE #linkedservers;

------------ / dbo.DRsync_LinkedServers_only_on_one_server_report ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_logins_dbrole_mappings_diff_settings_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_logins_dbrole_mappings_diff_settings_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/13/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_logins_dbrole_mappings_diff_settings_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE table #mappings
(
	[ServerName] [varchar](25) NULL,
	[Database] [varchar](50) NULL,
	[Login] [varchar](50) NULL,
	[DBRole] [varchar](50) NULL,
	[ServerName2] [varchar](25) NULL,
	[Database2] [varchar](50) NULL,
	[Login2] [varchar](50) NULL,
	[DBRole2] [varchar](50) NULL
);

INSERT INTO #mappings
(
	[ServerName] ,
	[Database] ,
	[Login] ,
	[DBRole] ,
	[ServerName2] ,
	[Database2] ,
	[Login2] ,
	[DBRole2]
)
SELECT 
	LEFT(a.[ServerName],25)
	,LEFT(a.[Database],50) 
	,LEFT(a.[Login],50) 
	,LEFT(a.[DBRole],50) 
	,(case when a.[ServerName] = b.[ServerName] then NULL else LEFT(b.[ServerName],25) end) as [ServerName2]
	,(case when a.[Database] = b.[Database] then NULL else LEFT(b.[Database],50) end) as [Database2]
	,(case when a.[Login] = b.[Login] then NULL else LEFT(b.[Login],50) end) as [Login2]
	,(case when a.[DBRole] = b.[DBRole] then NULL else LEFT(b.[DBRole],50) end) as [DBRole2]
  FROM [utildb].[dbo].drsync_logins_dbrole_mappings_compare a
  join [utildb].[dbo].drsync_logins_dbrole_mappings_compare b
  on a.[Login] = b.[Login]
  where a.[ServerName] = @ProdServer and b.[ServerName] = @DRServer	
  order by a.[Database], a.[Login], a.[DBRole], b.[DBRole];

if (exists ( select m.[ServerName], m.[Login], m.[Database], m.[Database2]
			 from #mappings m
			 where m.[Database2] is not NULL and m.[Database2] NOT LIKE '%snapshot%' ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Logins - Database Mappings________________________'
	print '_______________________________________________________________________'
	print ' '

	select m.[ServerName], m.[Login], m.[Database], m.[Database2] as [Database DR]
	from #mappings m
	where m.[Database2] is not NULL and m.[Database2] NOT LIKE '%snapshot%';
end
	
if (exists ( select m.[ServerName], m.[Login], m.[DBRole], m.[DBRole2]
			 from #mappings m
			 where m.[DBRole2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Logins - DBRole Mappings__________________________'
	print '_______________________________________________________________________'
	print ' '

	select m.[ServerName], m.[Login], m.[Database], m.[DBRole], m.[DBRole2] as [DBRole DR]
	from #mappings m
	where m.[DBRole2] is not NULL;
end
		
drop table #mappings;

------------ / dbo.DRsync_logins_dbrole_mappings_diff_settings_report ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_logins_dbrole_mappings_only_on_one_server_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_logins_dbrole_mappings_only_on_one_server_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/14/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_logins_dbrole_mappings_only_on_one_server_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;
	
if (exists ( select * from [utildb].[dbo].[drsync_logins_dbrole_mappings_compare] ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Login-DBRole Mappings - Only On One Server________'
	print '_______________________________________________________________________'
	print ' '

	SELECT 
		LEFT([ServerName],25) AS [ServerName]
		,LEFT([Database],50) AS [Database]
		,LEFT([Login],50) AS [Login]
		,LEFT([DBRole],50) AS [DBRole]
	FROM 
		[utildb].[dbo].[drsync_logins_dbrole_mappings_compare];
end

------------ / dbo.DRsync_logins_dbrole_mappings_only_on_one_server_report ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_logins_diff_settings_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_logins_diff_settings_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/10/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_logins_diff_settings_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE table #logins
(
	[servername] [varchar](25) NULL,
	[login] [varchar](50) NULL,
	[type] [char](1) NULL,
	[type_desc] [nvarchar](60) NULL,
	[is_disabled] [int] NULL,
	[create_date] [datetime] NULL,
	[modify_date] [datetime] NULL,
	[default_database_name] [varchar](50) NULL,
	[servername2] [varchar](25) NULL,
	[login2] [varchar](50) NULL,
	[type2] [char](1) NULL,
	[type_desc2] [nvarchar](60) NULL,
	[is_disabled2] [int] NULL,
	[create_date2] [datetime] NULL,
	[modify_date2] [datetime] NULL,
	[default_database_name2] [varchar](50) NULL
);

INSERT INTO #logins
(
	[servername]  ,
	[login]  ,
	[type]  ,
	[type_desc]  ,
	[is_disabled]  ,
	[create_date]  ,
	[modify_date]   ,
	[default_database_name]   ,
	[servername2]  ,
	[login2]  ,
	[type2]  ,
	[type_desc2]  ,
	[is_disabled2]  ,
	[create_date2]  ,
	[modify_date2] ,
	[default_database_name2]
)
SELECT 
	LEFT(a.[servername],25)
	,LEFT(a.[login],50) 
	,a.[type]
	,a.[type_desc]
	,a.[is_disabled]  
	,a.[create_date] 
	,a.[modify_date] 
	,LEFT(a.[default_database_name],50) 
	,(case when a.[servername] = b.[servername] then NULL else left(b.[servername],25) end) as [servername2]
	,(case when a.[login] = b.[login] then NULL else LEFT(b.[login],50) end) as [login2]
	,(case when a.[type] = b.[type] then NULL else b.[type] end) as [type2]	
	,(case when a.[type_desc] = b.[type_desc] then NULL else b.[type_desc] end) as [type_desc2]	
	,(case when a.[is_disabled] = b.[is_disabled] then NULL else b.[is_disabled] end) as [is_disabled2]	
	,(case when a.[create_date] = b.[create_date] then NULL else b.[create_date] end) as [create_date2]	
	,(case when a.[modify_date] = b.[modify_date] then NULL else b.[modify_date] end) as [modify_date2]	
	,(case when a.[default_database_name] = b.[default_database_name] then NULL else left(b.[default_database_name],50) end) as [default_database_name2]	
  FROM [utildb].[dbo].[drsync_logins_compare] a
  join [utildb].[dbo].[drsync_logins_compare] b
  on a.[login] = b.[login]
  where a.[servername] = @ProdServer and b.[servername] = @DRServer	
  order by a.[login];

if (exists ( select l.[servername], l.[login], l.[is_disabled], l.[is_disabled2]
			 from #logins l
			 where l.[is_disabled2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Logins - Is_Disabled______________________________'
	print '_______________________________________________________________________'
	print ' '

	select l.[servername], l.[login], l.[is_disabled], l.[is_disabled2] as [is_disabled DR]
	from #logins l
	where l.[is_disabled2] is not NULL;
end
	
if (exists ( select l.[servername], l.[login], l.[default_database_name], l.[default_database_name2]
			 from #logins l
			 where l.[default_database_name2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Logins - default_database_name____________________'
	print '_______________________________________________________________________'
	print ' '

	select l.[servername], l.[login], l.[default_database_name], l.[default_database_name2] as [default_database_name DR]
	from #logins l
	where l.[default_database_name2] is not NULL;
end
		
drop table #logins;

------------ / dbo.DRsync_logins_diff_settings_report ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_logins_only_on_one_server_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_logins_only_on_one_server_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/10/2010 	- Initial Release
					Marios Philippopoulos	11/02/2010	- Exclude login [NT SERVICE\ClusSvc] from consideration
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_logins_only_on_one_server_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE TABLE #logins
(
	[servername] [varchar](25) NULL,
	[login] [varchar](50) NULL
);

INSERT INTO #logins
(
	[servername],
	[login]
)
SELECT 
	LEFT(a.[servername],25) as [servername]
,	LEFT(a.[login],50) as [login]
FROM [utildb].[dbo].[drsync_logins_compare] a
where 
	a.[servername] = @ProdServer 
	and a.[login] NOT IN (SELECT b.[login] FROM [utildb].[dbo].[drsync_logins_compare] b WHERE b.[servername] = @DRServer)
	AND a.[login] <> 'NT SERVICE\ClusSvc'

UNION ALL

SELECT 
	LEFT(a.[servername],25) as [servername]
,	LEFT(a.[login],50) as [login]
FROM [utildb].[dbo].[drsync_logins_compare] a
where 
	a.[servername] = @DRServer 
	and a.[login] NOT IN (SELECT b.[login] FROM [utildb].[dbo].[drsync_logins_compare] b WHERE b.[servername] = @ProdServer);

if (exists ( select l.[servername], l.[login]
			 from #logins l) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Logins - Only On One Server_______________________'
	print '_______________________________________________________________________'
	print ' '

	select l.[servername], l.[login]
	from #logins l
	order by l.[servername], l.[login];
end

DROP TABLE #logins;

------------ / dbo.DRsync_logins_only_on_one_server_report ------------------------------------------------------------

;
;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_logins_server_level_permissions_only_on_one_server_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_logins_server_level_permissions_only_on_one_server_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/15/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_logins_server_level_permissions_only_on_one_server_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;
	
if (exists ( select * from [utildb].[dbo].[drsync_logins_server_level_permissions_compare] ) )
begin
	print ' '	
	print '________________________________________________________________________________________________'
	print '_____________________Logins - Server-Level Permissions - Only On One Server_____________________'
	print '________________________________________________________________________________________________'
	print ' '

	SELECT 
		LEFT([ServerName],25) AS [ServerName] 
		,LEFT([Login],50) AS [Login]
		,LEFT([Principal_Type],25) AS [Principal_Type]
		,LEFT([Permission_Grantor],50) AS [Permission_Grantor]
		,LEFT([Permission_Name],25) AS [Permission_Name]
		,LEFT([Permission_State],10) AS [Permission_State]
	FROM 
		[utildb].[dbo].[drsync_logins_server_level_permissions_compare];
end

------------ / dbo.DRsync_logins_server_level_permissions_only_on_one_server_report ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_logins_server_roles_only_on_one_server_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_logins_server_roles_only_on_one_server_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/15/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_logins_server_roles_only_on_one_server_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;
	
if (exists ( select * from [utildb].[dbo].[drsync_logins_server_roles_compare] ) )
begin
	print ' '	
	print '____________________________________________________________________________________'
	print '_____________________Logins - Server Roles - Only On One Server_____________________'
	print '____________________________________________________________________________________'
	print ' '

	SELECT 
		LEFT([ServerName],25) AS [ServerName] 
		,LEFT([Login],50) AS [Login]
		,LEFT([ServerRole],25) AS [ServerRole]
	FROM 
		[utildb].[dbo].[drsync_logins_server_roles_compare];
end

------------ / dbo.DRsync_logins_server_roles_only_on_one_server_report ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_operators_diff_settings_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_operators_diff_settings_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/10/2010 	- Initial Release
					Marios Philippopoulos	09/11/2010 	- Switched columns [OperatorEnabled], [OperatorEnabled2] to NULLable
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_operators_diff_settings_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE table #operators
(
	[ServerName] [varchar](25) NULL,
	[OperatorName] [varchar](50) NULL,
	[OperatorEmail] [Nvarchar](50) NULL,
	[OperatorEnabled] [tinyint] NULL,
	[ServerName2] [varchar](25) NULL,
	[OperatorName2] [varchar](50) NULL,
	[OperatorEmail2] [Nvarchar](50) NULL,
	[OperatorEnabled2] [tinyint] NULL
);

INSERT INTO #operators
(
	[ServerName]
	,[OperatorName]
	,[OperatorEmail]
	,[OperatorEnabled]
	,[ServerName2]
	,[OperatorName2]
	,[OperatorEmail2]
	,[OperatorEnabled2]
)
SELECT 
	LEFT(a.[ServerName],25)
	,LEFT(a.[OperatorName],50)
	,LEFT(a.[OperatorEmail],50)
	,a.[OperatorEnabled]
	,(case when a.[ServerName] = b.[ServerName] then NULL else left(b.[ServerName],25) end) as [ServerName2]
	,(case when a.[OperatorName] = b.[OperatorName] then NULL else LEFT(b.[OperatorName],50) end) as [OperatorName2]
	,(case when a.[OperatorEmail] = b.[OperatorEmail] then NULL else LEFT(b.[OperatorEmail],50) end) as [OperatorEmail2]	
	,(case when a.[OperatorEnabled] = b.[OperatorEnabled] then NULL else b.[OperatorEnabled] end) as [OperatorEnabled2]	
  FROM [utildb].[dbo].[drsync_operators_compare] a
  join [utildb].[dbo].[drsync_operators_compare] b
  on a.[OperatorName] = b.[OperatorName]
  where a.[ServerName] = @ProdServer and b.[ServerName] = @DRServer	
  order by a.[OperatorName];

if (exists ( select o.ServerName, o.[OperatorName], o.[OperatorEmail], o.[OperatorEmail2]
			 from #operators o
			 where o.[OperatorEmail2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Operators - Operator Email________________________'
	print '_______________________________________________________________________'
	print ' '

	select o.ServerName, o.[OperatorName], o.[OperatorEmail], o.[OperatorEmail2] as [OperatorEmail DR]
	from #operators o
	where o.[OperatorEmail2] is not NULL;
end
	
if (exists ( select o.ServerName, o.[OperatorName], o.[OperatorEnabled], o.[OperatorEnabled2]
			 from #operators o
			 where o.[OperatorEnabled2] is not NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Operators - Operator Enabled______________________'
	print '_______________________________________________________________________'
	print ' '

	select o.ServerName, o.[OperatorName], o.[OperatorEnabled], o.[OperatorEnabled2] AS [OperatorEnabled DR]
	from #operators o
	where o.[OperatorEnabled2] is not NULL;
end
		
drop table #operators;

------------ / dbo.DRsync_operators_diff_settings_report ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_operators_only_on_one_server_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_operators_only_on_one_server_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/10/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_operators_only_on_one_server_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE TABLE #operators
(
	[ServerName] [varchar](25) NULL,
	[OperatorName] [varchar](50) NULL
);

INSERT INTO #operators
(
	[ServerName],
	[OperatorName]
)
SELECT 
	LEFT(a.[ServerName],25) as [ServerName]
,	LEFT(a.[OperatorName],50) as [OperatorName]
FROM [utildb].[dbo].[drsync_operators] a
where 
	a.[ServerName] = @ProdServer 
	and a.[OperatorName] NOT IN (SELECT b.[OperatorName] FROM [utildb].[dbo].[drsync_operators] b WHERE b.[ServerName] = @DRServer)

UNION ALL

SELECT 
	LEFT(a.[ServerName],25) as [ServerName]
,	LEFT(a.[OperatorName],50) as [OperatorName]
FROM [utildb].[dbo].[drsync_operators] a
where 
	a.[ServerName] = @DRServer 
	and a.[OperatorName] NOT IN (SELECT b.[OperatorName] FROM [utildb].[dbo].[drsync_operators] b WHERE b.[ServerName] = @ProdServer);

if (exists ( select o.ServerName, o.[OperatorName]
			 from #operators o) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Operators - Only On One Server____________________'
	print '_______________________________________________________________________'
	print ' '

	select o.ServerName, o.[OperatorName]
	from #operators o
	ORDER BY o.ServerName, o.[OperatorName];
end

DROP TABLE #operators;

------------ / dbo.DRsync_operators_only_on_one_server_report ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	10/01/2010 	- Initial Release
					Marios Philippopoulos	12/22/2010 	- Added call to DRsync_populate_databasePermissions
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate]
AS

SET NOCOUNT ON;

EXEC [dbo].[DRsync_populate_ProdJobsDisabled];
EXEC [dbo].[DRsync_populate_jobs];
EXEC [dbo].[DRsync_populate_jobschedules];
EXEC [dbo].[DRsync_populate_jobsteps];
EXEC [dbo].[DRsync_populate_operators];
EXEC [dbo].[DRsync_populate_logins];
EXEC [dbo].[DRsync_populate_logins_dbrole_mappings];
EXEC [dbo].[DRsync_populate_logins_server_level_permissions];
EXEC [dbo].[DRsync_populate_logins_server_roles];
EXEC [dbo].[DRsync_populate_linked_servers];
EXEC [dbo].[DRsync_populate_traceflags];
EXEC [dbo].[DRsync_populate_databases];
EXEC [dbo].[DRsync_populate_databaseRoles_systemDBs];
EXEC [dbo].[DRsync_populate_dbmailConfig];
EXEC [dbo].[DRsync_populate_databasePermissions];
EXEC [dbo].[DRsync_populate_SSIS_packages_msdb];

------------ / dbo.DRsync_populate ------------------------------------------------------------



GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_databasePermissions]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_databasePermissions

	Purpose		:	Populates table drsync_databasePermissions

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	12/21/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_databasePermissions]
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_databasePermissions];

EXEC master.dbo.sp_Msforeachdb '
USE [?];

IF ''[?]'' IN 
(
	SELECT 
		QUOTENAME(d.name)  
	FROM 
		sys.databases d
	INNER JOIN 
		sys.database_mirroring m
	ON 
		d.database_id = m.database_id
	WHERE 
		m.mirroring_state IS NULL
		AND d.source_database_id IS NULL
)
BEGIN
	INSERT INTO [utildb].[dbo].[drsync_databasePermissions]
	( 
		[Database] 
		,[Object]
		,[Grantee]
		,[Action]
	)
	SELECT 
		''[?]''
	,	object_name(P.major_id) AS [Object]
	,	R1.[name] AS Grantee
	,	P.permission_name AS [Action]
	FROM 
		sys.database_permissions P
	INNER JOIN 
		sys.database_principals R1
	ON	
		P.grantee_principal_id = R1.principal_id
	INNER JOIN 
		sys.database_principals R2
	ON	
		P.grantor_principal_id = R2.principal_id
	WHERE
		object_name(P.major_id) IS NOT NULL;
END
';

UPDATE 
	[utildb].[dbo].[drsync_databasePermissions]
SET 
	[ServerName] = @@SERVERNAME;

------------ / dbo.DRsync_populate_databasePermissions ------------------------------------------------------------



GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_databasePermissions_compare]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_databasePermissions_compare

	Purpose		:	Populates table drsync_databasePermissions_compare

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	12/21/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_databasePermissions_compare]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

truncate table [utildb].[dbo].[drsync_databasePermissions_compare];

insert into [utildb].[dbo].[drsync_databasePermissions_compare]
(
	[ServerName]  ,
	[Database]  ,
	[Object]  ,
	[Grantee]  ,
	[Action]
)
select @ProdServer AS ServerName, * from
	(select	
		[Database]  ,
		[Object]  ,
		[Grantee]  ,
		[Action]
	from [utildb].[dbo].[drsync_databasePermissions] where [ServerName] = @ProdServer
	except 
	select
		[Database]  ,
		[Object]  ,
		[Grantee]  ,
		[Action]
	from [utildb].[dbo].[drsync_databasePermissions] where [ServerName] = @DRServer) x
UNION ALL
select @DRServer AS ServerName, * from
	(select	
		[Database]  ,
		[Object]  ,
		[Grantee]  ,
		[Action]
	from [utildb].[dbo].[drsync_databasePermissions] where [ServerName] = @DRServer
	except 
	select	
		[Database]  ,
		[Object]  ,
		[Grantee]  ,
		[Action]
	from [utildb].[dbo].[drsync_databasePermissions] where [ServerName] = @ProdServer) x

------------ / dbo.DRsync_populate_databasePermissions_compare ------------------------------------------------------------



GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_databaseRoles_systemDBs]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_databaseRoles_systemDBs

	Purpose		:	Populates table drsync_jobs

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/23/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_databaseRoles_systemDBs]
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_databaseRoles_systemDBs];

EXEC master.dbo.sp_Msforeachdb '
USE [?];

CREATE TABLE #roles
(
	[DatabaseRole]	SYSNAME 
);

INSERT INTO #roles
(
	[DatabaseRole]
)
SELECT 
	p.[name] 
FROM 
	sys.database_principals p
WHERE 
	type = ''R'';

IF ''[?]'' IN (''[master]'',''[msdb]'')
BEGIN
	INSERT INTO [utildb].[dbo].[drsync_databaseRoles_systemDBs]
	( 
		[Database] 
		,[DatabaseRole]
	)
	SELECT 
		''[?]''
	,	r.[DatabaseRole]  
	FROM 
		#roles r;
END

DROP TABLE #roles;
';

UPDATE 
	[utildb].[dbo].[drsync_databaseRoles_systemDBs]
SET 
	[ServerName] = @@SERVERNAME;

------------ / dbo.DRsync_populate_databaseRoles_systemDBs ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_databaseRoles_systemDBs_compare]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_databaseRoles_systemDBs_compare

	Purpose		:	Populates table drsync_databaseRoles_systemDBs_compare

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/23/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_databaseRoles_systemDBs_compare]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

truncate table [utildb].[dbo].[drsync_databaseRoles_systemDBs_compare];

insert into [utildb].[dbo].[drsync_databaseRoles_systemDBs_compare]
(
	   [ServerName]
      ,[Database]
      ,[DatabaseRole]
)
select @ProdServer AS servername, * from
	(select	
		[Database]
		,[DatabaseRole]
	from [utildb].[dbo].[drsync_databaseRoles_systemDBs] where [ServerName] = @ProdServer
	except 
	select	
		[Database]
		,[DatabaseRole]
	from [utildb].[dbo].[drsync_databaseRoles_systemDBs] where [ServerName] = @DRServer) x
union all
select @DRServer AS servername, * from
	(select		
		[Database]
		,[DatabaseRole]
	from [utildb].[dbo].[drsync_databaseRoles_systemDBs] where [ServerName] = @DRServer
	except 
	select		
		[Database]
		,[DatabaseRole]
	from [utildb].[dbo].[drsync_databaseRoles_systemDBs] where [ServerName] = @ProdServer) x

------------ / dbo.DRsync_populate_databaseRoles_systemDBs_compare ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_databases]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_databases

	Purpose		:	Populates table drsync_jobs

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/22/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_databases]
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_databases];

INSERT INTO [utildb].[dbo].[drsync_databases]
( 
	[Database]
)
SELECT
	d.name
FROM 
	sys.databases d
WHERE
	d.source_database_id IS NULL -- no snapshots
ORDER BY 
	d.name;

UPDATE 
	[utildb].[dbo].[drsync_databases]
SET 
	[ServerName] = @@SERVERNAME;

------------ / dbo.DRsync_populate_databases ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_databases_compare]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_databases_compare

	Purpose		:	Populates table drsync_databases_compare

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/22/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_databases_compare]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

truncate table [utildb].[dbo].[drsync_databases_compare];

insert into [utildb].[dbo].[drsync_databases_compare]
(
	   [ServerName]
      ,[Database]
)
select @ProdServer AS servername, * from
	(select	
		[Database]
	from [utildb].[dbo].[drsync_databases] where servername = @ProdServer
	except 
	select	
		[Database]
	from [utildb].[dbo].[drsync_databases] where servername = @DRServer) x
union all
select @DRServer AS servername, * from
	(select		
		[Database]
	from [utildb].[dbo].[drsync_databases] where servername = @DRServer
	except 
	select		
		[Database]
	from [utildb].[dbo].[drsync_databases] where servername = @ProdServer) x

------------ / dbo.DRsync_populate_databases_compare ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_dbmailConfig]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_dbmailConfig

	Purpose		:	Populates table drsync_dbmailConfig 

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/27/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_dbmailConfig]
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_dbmailConfig];

INSERT INTO [utildb].[dbo].[drsync_dbmailConfig]
( 
	[ParamName]
	,[ParamValue]
	,[Description]
)
SELECT 
	[paramname]
	,[paramvalue]
	,[description]
FROM 
	[msdb].[dbo].[sysmail_configuration];

UPDATE 
	[utildb].[dbo].[drsync_dbmailConfig]
SET 
	[ServerName] = @@SERVERNAME;

------------ / dbo.DRsync_populate_dbmailConfig ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_dbmailConfig_compare]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_dbmailConfig_compare

	Purpose		:	Populates table drsync_dbmailConfig_compare

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/27/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_dbmailConfig_compare]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

truncate table [utildb].[dbo].[drsync_dbmailConfig_compare];

insert into [utildb].[dbo].[drsync_dbmailConfig_compare]
(
	[ServerName]
	,[ParamName]
	,[ParamValue]
	,[Description]
)
select @ProdServer AS ServerName, * from
	(select	
		[ParamName]
		,[ParamValue]
		,[Description]
	from [utildb].[dbo].[drsync_dbmailConfig] where [ServerName] = @ProdServer
	except 
	select
		[ParamName]
		,[ParamValue]
		,[Description]
	from [utildb].[dbo].[drsync_dbmailConfig] where [ServerName] = @DRServer) x
UNION ALL
select @DRServer AS ServerName, * from
	(select	
		[ParamName]
		,[ParamValue]
		,[Description]
	from [utildb].[dbo].[drsync_dbmailConfig] where [ServerName] = @DRServer
	except 
	select	
		[ParamName]
		,[ParamValue]
		,[Description]
	from [utildb].[dbo].[drsync_dbmailConfig] where [ServerName] = @ProdServer) x

------------ / dbo.DRsync_populate_dbmailConfig_compare ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_jobs]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO




/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_jobs

	Purpose		:	Populates table drsync_jobs

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/09/2010 	- Initial Release
					Marios Philippopoulos	10/14/2010	- LEFT JOIN ON msdb.dbo.sysoperators
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_jobs]
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_jobs];

INSERT INTO [utildb].[dbo].[drsync_jobs]
( 
	[JobName]  ,
	[JobEnabled]  ,
	[JobDescription]  ,
	[JobNotifyLevelEmail]  ,
	[JobNotifyLevelEventlog]  ,
	[JobNotifyLevelNetsend]  ,
	[JobNotifyLevelPage]  ,
	[JobStartStepId]  ,
	[CategoryName]  ,
	[OperatorName]  ,
	[OperatorEmail]  ,
	[OperatorEnabled] 
)
select
	j.name as [job name]
,	j.[enabled] as [job enabled]
,	j.[description]
,	j.notify_level_email
,	j.notify_level_eventlog
,	j.notify_level_netsend
,	j.notify_level_page
,	j.start_step_id
,	c.name as [category name]
,	o.name as [operator_name]
,	o.email_address as [operator_email]
,	o.[enabled] as [operator_enabled]
from msdb.dbo.sysjobs j 
join msdb.dbo.syscategories c
on j.category_id = c.category_id
left join msdb.dbo.sysoperators o
on j.notify_email_operator_id = o.id
order by j.name;

UPDATE [utildb].[dbo].[drsync_jobs]
SET [servername] = @@SERVERNAME;

------------ / dbo.DRsync_populate_jobs ------------------------------------------------------------

;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_jobs_compare]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_jobs_compare

	Purpose		:	Populates table drsync_jobs_compare

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/08/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_jobs_compare]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

truncate table [utildb].[dbo].[drsync_jobs_compare];

insert into [utildb].[dbo].[drsync_jobs_compare]
(
	   [ServerName]
      ,[JobName]
      ,[JobDescription]
      ,[JobNotifyLevelEmail]
      ,[JobNotifyLevelEventlog]
      ,[JobNotifyLevelNetsend]
      ,[JobNotifyLevelPage]
      ,[JobStartStepId]
      ,[CategoryName]
      ,[OperatorName]
      ,[OperatorEmail]
      ,[OperatorEnabled]
)
select @ProdServer AS servername, * from
	(select	[JobName]
      ,[JobDescription]
      ,[JobNotifyLevelEmail]
      ,[JobNotifyLevelEventlog]
      ,[JobNotifyLevelNetsend]
      ,[JobNotifyLevelPage]
      ,[JobStartStepId]
      ,[CategoryName]
      ,[OperatorName]
      ,[OperatorEmail]
      ,[OperatorEnabled]
	from [utildb].[dbo].[drsync_jobs] where servername = @ProdServer
	except 
	select	[JobName] 
      ,[JobDescription]
      ,[JobNotifyLevelEmail]
      ,[JobNotifyLevelEventlog]
      ,[JobNotifyLevelNetsend]
      ,[JobNotifyLevelPage]
      ,[JobStartStepId]
      ,[CategoryName]
      ,[OperatorName]
      ,[OperatorEmail]
      ,[OperatorEnabled]
	from [utildb].[dbo].[drsync_jobs] where servername = @DRServer) x
union all
select @DRServer AS servername, * from
	(select	[JobName] 
      ,[JobDescription]
      ,[JobNotifyLevelEmail]
      ,[JobNotifyLevelEventlog]
      ,[JobNotifyLevelNetsend]
      ,[JobNotifyLevelPage]
      ,[JobStartStepId]
      ,[CategoryName]
      ,[OperatorName]
      ,[OperatorEmail]
      ,[OperatorEnabled]
	from [utildb].[dbo].[drsync_jobs] where servername = @DRServer
	except 
	select	[JobName] 
      ,[JobDescription]
      ,[JobNotifyLevelEmail]
      ,[JobNotifyLevelEventlog]
      ,[JobNotifyLevelNetsend]
      ,[JobNotifyLevelPage]
      ,[JobStartStepId]
      ,[CategoryName]
      ,[OperatorName]
      ,[OperatorEmail]
      ,[OperatorEnabled]
	from [utildb].[dbo].[drsync_jobs] where servername = @ProdServer) x

------------ / dbo.DRsync_populate_jobs_compare ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_jobschedules]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_jobschedules

	Purpose		:	Populates table drsync_jobschedules

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/08/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_jobschedules]
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_jobschedules];

INSERT INTO [utildb].[dbo].[drsync_jobschedules]
( 
	[JobName]  ,
	[ScheduleEnabled]  ,
	[ScheduleActiveStartDate]  ,
	[ScheduleFreqInterval]  ,
	[ScheduleFreqRecurrenceFactor]  ,
	[ScheduleFreqRelativeInterval]  ,
	[ScheduleFreqSubdayInterval]  ,
	[ScheduleFreqSubdayType]  ,
	[ScheduleFreqType]  ,
	[ScheduleName]  
)
select
	j.name as [job name]
,	sch.[enabled] as [schedule enabled] 
,	sch.active_start_date as [sch_active_start_date]
,	sch.freq_interval as [sch_freq_interval]
,	sch.freq_recurrence_factor as [sch_freq_recurrence_factor]
,	sch.freq_relative_interval as [sch_freq_relative_interval]
,	sch.freq_subday_interval as [sch_freq_subday_interval]
,	sch.freq_subday_type as [sch_freq_subday_type]
,	sch.freq_type as [sch_freq_type]
,	sch.name as [sch_name]
from msdb.dbo.sysjobs j 
join msdb.dbo.sysjobschedules jsch
on j.job_id = jsch.job_id
join msdb.dbo.sysschedules sch
on jsch.schedule_id = sch.schedule_id 
order by j.name;

UPDATE [utildb].[dbo].[drsync_jobschedules]
SET [servername] = @@SERVERNAME;

------------ / dbo.DRsync_populate_jobschedules ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_jobschedules_compare]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_jobschedules_compare

	Purpose		:	Populates table drsync_jobschedules_compare

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/08/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_jobschedules_compare]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

truncate table [utildb].[dbo].[drsync_jobschedules_compare];

insert into [utildb].[dbo].[drsync_jobschedules_compare]
(
	   [ServerName]
      ,[JobName]
      ,[ScheduleEnabled]
      ,[ScheduleActiveStartDate]
      ,[ScheduleFreqInterval]
      ,[ScheduleFreqRecurrenceFactor]
      ,[ScheduleFreqRelativeInterval]
      ,[ScheduleFreqSubdayInterval]
      ,[ScheduleFreqSubdayType]
      ,[ScheduleFreqType]
      ,[ScheduleName]
)
select @ProdServer AS servername, * from
	(select	[JobName]
      ,[ScheduleEnabled]
      ,[ScheduleActiveStartDate]
      ,[ScheduleFreqInterval]
      ,[ScheduleFreqRecurrenceFactor]
      ,[ScheduleFreqRelativeInterval]
      ,[ScheduleFreqSubdayInterval]
      ,[ScheduleFreqSubdayType]
      ,[ScheduleFreqType]
      ,[ScheduleName]
	from [utildb].[dbo].[drsync_jobschedules] where servername = @ProdServer
	except 
	select	[JobName]
      ,[ScheduleEnabled]
      ,[ScheduleActiveStartDate]
      ,[ScheduleFreqInterval]
      ,[ScheduleFreqRecurrenceFactor]
      ,[ScheduleFreqRelativeInterval]
      ,[ScheduleFreqSubdayInterval]
      ,[ScheduleFreqSubdayType]
      ,[ScheduleFreqType]
      ,[ScheduleName]
	from [utildb].[dbo].[drsync_jobschedules] where servername = @DRServer) x
union all
select @DRServer AS servername, * from
	(select	[JobName] 
      ,[ScheduleEnabled]
      ,[ScheduleActiveStartDate]
      ,[ScheduleFreqInterval]
      ,[ScheduleFreqRecurrenceFactor]
      ,[ScheduleFreqRelativeInterval]
      ,[ScheduleFreqSubdayInterval]
      ,[ScheduleFreqSubdayType]
      ,[ScheduleFreqType]
      ,[ScheduleName]
	from [utildb].[dbo].[drsync_jobschedules] where servername = @DRServer
	except 
	select	[JobName] 
      ,[ScheduleEnabled]
      ,[ScheduleActiveStartDate]
      ,[ScheduleFreqInterval]
      ,[ScheduleFreqRecurrenceFactor]
      ,[ScheduleFreqRelativeInterval]
      ,[ScheduleFreqSubdayInterval]
      ,[ScheduleFreqSubdayType]
      ,[ScheduleFreqType]
      ,[ScheduleName]
	from [utildb].[dbo].[drsync_jobschedules] where servername = @ProdServer) x

------------ / dbo.DRsync_populate_jobschedules_compare ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_jobsteps]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_jobsteps

	Purpose		:	Populates table drsync_jobsteps

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/09/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_jobsteps]
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_jobsteps];

INSERT INTO [utildb].[dbo].[drsync_jobsteps]
( 
	[JobName]  ,
	[StepId]  ,
	[StepName]  ,
	[StepCommand]  ,
	[StepDatabaseName]  ,
	[StepSubsystem]  ,
	[StepOutputFileName]  ,
	[StepCmdexecSuccessCode]  ,
	[StepOnFailAction]  ,
	[StepOnFailStepId]  ,
	[StepOnSuccessAction]  ,
	[StepOnSuccessStepId]  ,
	[StepProxyId]  ,
	[StepRetryAttempts]  ,
	[StepRetryInterval] 
)
select
	j.name as [job name]
,	s.step_id
,	s.step_name
,	s.command
,	s.database_name
,	s.subsystem
,	s.output_file_name
,	s.cmdexec_success_code
,	s.on_fail_action
,	s.on_fail_step_id
,	s.on_success_action
,	s.on_success_step_id
,	s.proxy_id
,	s.retry_attempts
,	s.retry_interval
from msdb.dbo.sysjobs j
join msdb.dbo.sysjobsteps s
on j.job_id = s.job_id
order by j.name, s.step_id;

UPDATE [utildb].[dbo].[drsync_jobsteps]
SET [servername] = @@SERVERNAME;

------------ / dbo.DRsync_populate_jobsteps ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_jobsteps_compare]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_jobsteps_compare

	Purpose		:	Populates table drsync_jobschedules_compare

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/08/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_jobsteps_compare]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

truncate table [utildb].[dbo].[drsync_jobsteps_compare];

insert into [utildb].[dbo].[drsync_jobsteps_compare]
(
	   [ServerName]
      ,[JobName]
      ,[StepId]
      ,[StepName]
      ,[StepCommand]
      ,[StepDatabaseName]
      ,[StepSubsystem]
      ,[StepOutputFileName]
      ,[StepCmdexecSuccessCode]
      ,[StepOnFailAction]
      ,[StepOnFailStepId]
      ,[StepOnSuccessAction]
      ,[StepOnSuccessStepId]
      ,[StepProxyId]
      ,[StepRetryAttempts]
      ,[StepRetryInterval]
)
select @ProdServer AS servername, * from
	(select	[JobName]
      ,[StepId]
      ,[StepName]
      ,[StepCommand]
      ,[StepDatabaseName]
      ,[StepSubsystem]
      ,[StepOutputFileName]
      ,[StepCmdexecSuccessCode]
      ,[StepOnFailAction]
      ,[StepOnFailStepId]
      ,[StepOnSuccessAction]
      ,[StepOnSuccessStepId]
      ,[StepProxyId]
      ,[StepRetryAttempts]
      ,[StepRetryInterval]
	from [utildb].[dbo].[drsync_jobsteps] where servername = @ProdServer
	except 
	select	[JobName]
      ,[StepId]
      ,[StepName]
      ,[StepCommand]
      ,[StepDatabaseName]
      ,[StepSubsystem]
      ,[StepOutputFileName]
      ,[StepCmdexecSuccessCode]
      ,[StepOnFailAction]
      ,[StepOnFailStepId]
      ,[StepOnSuccessAction]
      ,[StepOnSuccessStepId]
      ,[StepProxyId]
      ,[StepRetryAttempts]
      ,[StepRetryInterval]
	from [utildb].[dbo].[drsync_jobsteps] where servername = @DRServer) x
union all
select @DRServer AS servername, * from
	(select	[JobName] 
      ,[StepId]
      ,[StepName]
      ,[StepCommand]
      ,[StepDatabaseName]
      ,[StepSubsystem]
      ,[StepOutputFileName]
      ,[StepCmdexecSuccessCode]
      ,[StepOnFailAction]
      ,[StepOnFailStepId]
      ,[StepOnSuccessAction]
      ,[StepOnSuccessStepId]
      ,[StepProxyId]
      ,[StepRetryAttempts]
      ,[StepRetryInterval]
	from [utildb].[dbo].[drsync_jobsteps] where servername = @DRServer
	except 
	select	[JobName] 
      ,[StepId]
      ,[StepName]
      ,[StepCommand]
      ,[StepDatabaseName]
      ,[StepSubsystem]
      ,[StepOutputFileName]
      ,[StepCmdexecSuccessCode]
      ,[StepOnFailAction]
      ,[StepOnFailStepId]
      ,[StepOnSuccessAction]
      ,[StepOnSuccessStepId]
      ,[StepProxyId]
      ,[StepRetryAttempts]
      ,[StepRetryInterval]
	from [utildb].[dbo].[drsync_jobsteps] where servername = @ProdServer) x

------------ / dbo.DRsync_populate_jobsteps_compare ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_linked_servers]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_linked_servers

	Purpose		:	Populates table drsync_linked_servers

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/14/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_linked_servers]
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_linked_servers];

INSERT INTO [utildb].[dbo].[drsync_linked_servers]
( 
	[LinkedServerName]
	,[Product]
	,[Provider]
	,[DataSource]
	,[Location]
	,[ProviderString]
	,[Catalog]
	,[ConnectTimeout]
	,[QueryTimeout]
	,[IsRemoteLoginEnabled]
	,[IsRPC-OutEnabled]
	,[IsDataAccessEnabled]
	,[IsCollationCompatible]
	,[UsesRemoteCollation]
	,[CollationName]
	,[LazySchemaValidation]
	,[IsSystem]
	,[IsPublisher]
	,[IsSubscriber]
	,[IsDistributor]
	,[IsNonSqlSubscriber]
	,[IsRemoteProcTransactionPromotionEnabled]
)
SELECT 
	s.name AS [LinkedServerName]
,	s.product
,	s.provider
,	s.data_source
,	s.location
,	s.provider_string
,	s.[catalog]
,	s.connect_timeout
,	s.query_timeout
,	s.is_remote_login_enabled
,	s.is_rpc_out_enabled
,	s.is_data_access_enabled
,	s.is_collation_compatible
,	s.uses_remote_collation
,	s.collation_name
,	s.lazy_schema_validation
,	s.is_system
,	s.is_publisher
,	s.is_subscriber
,	s.is_distributor
,	s.is_nonsql_subscriber
,	s.is_remote_proc_transaction_promotion_enabled
FROM 
	sys.servers s
WHERE 
	s.is_linked = 1;

UPDATE [utildb].[dbo].[drsync_linked_servers]
SET [ServerName] = @@SERVERNAME;

------------ / dbo.DRsync_populate_linked_servers ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_linked_servers_compare]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_linked_servers_compare

	Purpose		:	Populates table drsync_linked_servers_compare

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/21/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_linked_servers_compare]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

truncate table [utildb].[dbo].[drsync_linked_servers_compare];

insert into [utildb].[dbo].[drsync_linked_servers_compare]
(
	[ServerName]
	,[LinkedServerName]
	,[Product]
	,[Provider]
	,[DataSource]
	,[Location]
	,[ProviderString]
	,[Catalog]
	,[ConnectTimeout]
	,[QueryTimeout]
	,[IsRemoteLoginEnabled]
	,[IsRPC-OutEnabled]
	,[IsDataAccessEnabled]
	,[IsCollationCompatible]
	,[UsesRemoteCollation]
	,[CollationName]
	,[LazySchemaValidation]
	,[IsSystem]
	,[IsPublisher]
	,[IsSubscriber]
	,[IsDistributor]
	,[IsNonSqlSubscriber]
	,[IsRemoteProcTransactionPromotionEnabled]
)
select @ProdServer AS ServerName, * from
	(select	
		[LinkedServerName]
		,[Product]
		,[Provider]
		,[DataSource]
		,[Location]
		,[ProviderString]
		,[Catalog]
		,[ConnectTimeout]
		,[QueryTimeout]
		,[IsRemoteLoginEnabled]
		,[IsRPC-OutEnabled]
		,[IsDataAccessEnabled]
		,[IsCollationCompatible]
		,[UsesRemoteCollation]
		,[CollationName]
		,[LazySchemaValidation]
		,[IsSystem]
		,[IsPublisher]
		,[IsSubscriber]
		,[IsDistributor]
		,[IsNonSqlSubscriber]
		,[IsRemoteProcTransactionPromotionEnabled]
	from [utildb].[dbo].[drsync_linked_servers] where [ServerName] = @ProdServer
	except 
	select
		[LinkedServerName]
		,[Product]
		,[Provider]
		,[DataSource]
		,[Location]
		,[ProviderString]
		,[Catalog]
		,[ConnectTimeout]
		,[QueryTimeout]
		,[IsRemoteLoginEnabled]
		,[IsRPC-OutEnabled]
		,[IsDataAccessEnabled]
		,[IsCollationCompatible]
		,[UsesRemoteCollation]
		,[CollationName]
		,[LazySchemaValidation]
		,[IsSystem]
		,[IsPublisher]
		,[IsSubscriber]
		,[IsDistributor]
		,[IsNonSqlSubscriber]
		,[IsRemoteProcTransactionPromotionEnabled]
	from [utildb].[dbo].[drsync_linked_servers] where [ServerName] = @DRServer) x
UNION ALL
select @DRServer AS ServerName, * from
	(select	
		[LinkedServerName]
		,[Product]
		,[Provider]
		,[DataSource]
		,[Location]
		,[ProviderString]
		,[Catalog]
		,[ConnectTimeout]
		,[QueryTimeout]
		,[IsRemoteLoginEnabled]
		,[IsRPC-OutEnabled]
		,[IsDataAccessEnabled]
		,[IsCollationCompatible]
		,[UsesRemoteCollation]
		,[CollationName]
		,[LazySchemaValidation]
		,[IsSystem]
		,[IsPublisher]
		,[IsSubscriber]
		,[IsDistributor]
		,[IsNonSqlSubscriber]
		,[IsRemoteProcTransactionPromotionEnabled]
	from [utildb].[dbo].[drsync_linked_servers] where [ServerName] = @DRServer
	except 
	select	
		[LinkedServerName]
		,[Product]
		,[Provider]
		,[DataSource]
		,[Location]
		,[ProviderString]
		,[Catalog]
		,[ConnectTimeout]
		,[QueryTimeout]
		,[IsRemoteLoginEnabled]
		,[IsRPC-OutEnabled]
		,[IsDataAccessEnabled]
		,[IsCollationCompatible]
		,[UsesRemoteCollation]
		,[CollationName]
		,[LazySchemaValidation]
		,[IsSystem]
		,[IsPublisher]
		,[IsSubscriber]
		,[IsDistributor]
		,[IsNonSqlSubscriber]
		,[IsRemoteProcTransactionPromotionEnabled]
	from [utildb].[dbo].[drsync_linked_servers] where [ServerName] = @ProdServer) x

------------ / dbo.DRsync_populate_linked_servers_compare ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_logins]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_logins

	Purpose		:	Populates table drsync_logins

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/10/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_logins]
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_logins];

INSERT INTO [utildb].[dbo].[drsync_logins]
( 
	[login]
	,[type]
	,[type_desc]
	,[is_disabled]
	,[create_date]
	,[modify_date]
	,[default_database_name]
)
SELECT 
	p.name
,	p.type
,	p.type_desc
,	p.is_disabled
,	p.create_date
,	p.modify_date
,	p.default_database_name
FROM sys.server_principals p
WHERE
	p.name NOT LIKE '##%'
	AND p.name <> 'sa'
	AND p.name <> 'NT AUTHORITY\SYSTEM'
	AND p.name NOT LIKE 'NT SERVICE%'
	AND p.[type] <> 'R';

UPDATE [utildb].[dbo].[drsync_logins]
SET [servername] = @@SERVERNAME;

------------ / dbo.DRsync_populate_logins ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_logins_compare]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_logins_compare

	Purpose		:	Populates table drsync_logins_compare

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/10/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_logins_compare]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

truncate table [utildb].[dbo].[drsync_logins_compare];

insert into [utildb].[dbo].[drsync_logins_compare]
(
	   [servername]
      ,[login]
      ,[type]
      ,[type_desc]
      ,[is_disabled]
      ,[default_database_name]
)
select @ProdServer AS servername, * from
	(select	[login]
      ,[type]
      ,[type_desc]
      ,[is_disabled]
      ,[default_database_name]
	from [utildb].[dbo].[drsync_logins] where [servername] = @ProdServer
	except 
	select	[login]
      ,[type]
      ,[type_desc]
      ,[is_disabled]
      ,[default_database_name]
	from [utildb].[dbo].[drsync_logins] where [servername] = @DRServer) x
union all
select @DRServer AS servername, * from
	(select	[login]
      ,[type]
      ,[type_desc]
      ,[is_disabled]
      ,[default_database_name]
	from [utildb].[dbo].[drsync_logins] where [servername] = @DRServer
	except 
	select	[login]
      ,[type]
      ,[type_desc]
      ,[is_disabled]
      ,[default_database_name]
	from [utildb].[dbo].[drsync_logins] where [servername] = @ProdServer) x

------------ / dbo.DRsync_populate_logins_compare ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_logins_dbrole_mappings]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_logins_dbrole_mappings

	Purpose		:	Populates table drsync_logins_dbrole_mappings - master and msdb databases only

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/13/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_logins_dbrole_mappings]
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_logins_dbrole_mappings];

EXEC master.dbo.sp_Msforeachdb '
USE [?];

CREATE TABLE #roleMembers
(
	[DBRole]		SYSNAME
,	[MemberName]	SYSNAME
,	[MemberSID]		VARBINARY(85)
);

INSERT INTO #roleMembers
(
	[DBRole] 
,	[MemberName] 
,	[MemberSID]
)
EXEC sp_helprolemember;

IF ''[?]'' IN (''[master]'',''[msdb]'')
BEGIN
	INSERT INTO [utildb].[dbo].[drsync_logins_dbrole_mappings]
	( 
		[Database]
		,[Login]
		,[DBRole]
	)
	SELECT 
		''[?]''
	,	[MemberName]
	,	[DBRole]  
	FROM 
		#roleMembers r
	WHERE
		r.[MemberName] <> ''dbo''
		AND r.[MemberName] NOT LIKE ''##%'';
END

DROP TABLE #roleMembers;
';

UPDATE [utildb].[dbo].[drsync_logins_dbrole_mappings]
SET [ServerName] = @@SERVERNAME;

------------ / dbo.DRsync_populate_logins_dbrole_mappings ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_logins_dbrole_mappings_compare]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_logins_dbrole_mappings_compare

	Purpose		:	Populates table drsync_logins_compare

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/10/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_logins_dbrole_mappings_compare]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

truncate table [utildb].[dbo].[drsync_logins_dbrole_mappings_compare];

insert into [utildb].[dbo].[drsync_logins_dbrole_mappings_compare]
(
	   [ServerName]
      ,[Database]
      ,[Login]
      ,[DBRole]
)
select @ProdServer AS ServerName, * from
	(select	[Database]
      ,[Login]
      ,[DBRole]
	from [utildb].[dbo].[drsync_logins_dbrole_mappings] where [ServerName] = @ProdServer
	except 
	select	[Database]
      ,[Login]
      ,[DBRole]
	from [utildb].[dbo].[drsync_logins_dbrole_mappings] where [ServerName] = @DRServer) x
union all
select @DRServer AS ServerName, * from
	(select	[Database]
      ,[Login]
      ,[DBRole]
	from [utildb].[dbo].[drsync_logins_dbrole_mappings] where [ServerName] = @DRServer
	except 
	select	[Database]
      ,[Login]
      ,[DBRole]
	from [utildb].[dbo].[drsync_logins_dbrole_mappings] where [ServerName] = @ProdServer) x

------------ / dbo.DRsync_populate_logins_dbrole_mappings_compare ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_logins_server_level_permissions]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_logins_server_level_permissions

	Purpose		:	Populates table drsync_jobs

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/14/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_logins_server_level_permissions]
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_logins_server_level_permissions];

INSERT INTO [utildb].[dbo].[drsync_logins_server_level_permissions]
( 
	[Login]
	,[Principal_Type]
	,[Permission_Grantor]
	,[Permission_Name]
	,[Permission_State]
)
SELECT  
	[srvprin].[name] [server_principal], 
	[srvprin].[type_desc] [principal_type], 
	[srvprin2].[name] [grantor],
	[srvperm].[permission_name], 
	[srvperm].[state_desc]  
FROM 
	[sys].[server_permissions] srvperm 
INNER JOIN [sys].[server_principals] srvprin 
    ON [srvperm].[grantee_principal_id] = [srvprin].[principal_id] 
INNER JOIN [sys].[server_principals] srvprin2
    ON [srvperm].[grantor_principal_id] = [srvprin2].[principal_id] 
WHERE 
	[srvprin].[type] IN ('S', 'U', 'G') 
	AND [srvprin].[name] NOT LIKE '##%'
	AND [srvperm].[permission_name] <> 'CONNECT SQL'
ORDER BY 
	[server_principal], [permission_name]; 

UPDATE [utildb].[dbo].[drsync_logins_server_level_permissions]
SET [ServerName] = @@SERVERNAME;

------------ / dbo.DRsync_populate_logins_server_level_permissions ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_logins_server_level_permissions_compare]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_logins_server_level_permissions_compare

	Purpose		:	Populates table drsync_logins_server_level_permissions_compare

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/15/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_logins_server_level_permissions_compare]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

truncate table [utildb].[dbo].[drsync_logins_server_level_permissions_compare];

insert into [utildb].[dbo].[drsync_logins_server_level_permissions_compare]
(
	[ServerName]
	,[Login]
	,[Principal_Type]
	,[Permission_Grantor]
	,[Permission_Name]
	,[Permission_State]
)
select @ProdServer AS ServerName, * from
	(select	
		[Login]
		,[Principal_Type]
		,[Permission_Grantor]
		,[Permission_Name]
		,[Permission_State]
	from [utildb].[dbo].[drsync_logins_server_level_permissions] where [ServerName] = @ProdServer
	except 
	select
		[Login]
		,[Principal_Type]
		,[Permission_Grantor]
		,[Permission_Name]
		,[Permission_State]
	from [utildb].[dbo].[drsync_logins_server_level_permissions] where [ServerName] = @DRServer) x
union all
select @DRServer AS ServerName, * from
	(select	
		[Login]
		,[Principal_Type]
		,[Permission_Grantor]
		,[Permission_Name]
		,[Permission_State]
	from [utildb].[dbo].[drsync_logins_server_level_permissions] where [ServerName] = @DRServer
	except 
	select	
		[Login]
		,[Principal_Type]
		,[Permission_Grantor]
		,[Permission_Name]
		,[Permission_State]
	from [utildb].[dbo].[drsync_logins_server_level_permissions] where [ServerName] = @ProdServer) x

------------ / dbo.DRsync_populate_logins_server_level_permissions_compare ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_logins_server_roles]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_logins_server_roles

	Purpose		:	Populates table drsync_jobs

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/15/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_logins_server_roles]
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_logins_server_roles];

INSERT INTO [utildb].[dbo].[drsync_logins_server_roles]
( 
	[Login]
,	[ServerRole]
)
SELECT
	SP.name AS [Login]
,	SR.name AS [ServerRole]
FROM 
	sys.server_principals SP 
INNER JOIN 
	sys.server_role_members SRM
ON 
	SP.principal_id = SRM.member_principal_id 
INNER JOIN  
	(	SELECT [name], principal_id 
		FROM sys.server_principals
		WHERE type_desc = 'SERVER_ROLE'	) as SR
ON 
	SRM.role_principal_id = SR.principal_id
WHERE
	SP.name NOT LIKE '##%'
	AND SP.name <> 'sa'
	AND SP.name <> 'NT AUTHORITY\SYSTEM'
	AND SP.name NOT LIKE 'NT SERVICE%';

UPDATE 
	[utildb].[dbo].[drsync_logins_server_roles]
SET 
	[ServerName] = @@SERVERNAME;

------------ / dbo.DRsync_populate_logins_server_roles ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_logins_server_roles_compare]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_logins_server_roles_compare

	Purpose		:	Populates table drsync_logins_server_roles_compare

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/15/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_logins_server_roles_compare]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

truncate table [utildb].[dbo].[drsync_logins_server_roles_compare];

insert into [utildb].[dbo].[drsync_logins_server_roles_compare]
(
	[ServerName]
	,[Login]
	,[ServerRole]
)
select @ProdServer AS ServerName, * from
	(select	
		[Login]
		,[ServerRole]
	from [utildb].[dbo].[drsync_logins_server_roles] where [ServerName] = @ProdServer
	except 
	select
		[Login]
		,[ServerRole]
	from [utildb].[dbo].[drsync_logins_server_roles] where [ServerName] = @DRServer) x
UNION ALL
select @DRServer AS ServerName, * from
	(select	
		[Login]
		,[ServerRole]
	from [utildb].[dbo].[drsync_logins_server_roles] where [ServerName] = @DRServer
	except 
	select	
		[Login]
		,[ServerRole]
	from [utildb].[dbo].[drsync_logins_server_roles] where [ServerName] = @ProdServer) x

------------ / dbo.DRsync_populate_logins_server_roles_compare ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_operators]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_operators

	Purpose		:	Populates table drsync_operators

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/10/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_operators]
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_operators];

INSERT INTO [utildb].[dbo].[drsync_operators]
( 
	[OperatorName]
	,[OperatorEmail]
	,[OperatorEnabled]
)
select
	o.name  
,	o.email_address  
,	o.[enabled] 
from msdb.dbo.sysoperators o 
order by o.name;

UPDATE [utildb].[dbo].[drsync_operators]
SET [ServerName] = @@SERVERNAME;

------------ / dbo.DRsync_populate_operators ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_operators_compare]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_operators_compare

	Purpose		:	Populates table drsync_operators

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/21/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_operators_compare]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

truncate table [utildb].[dbo].[drsync_operators_compare];

insert into [utildb].[dbo].[drsync_operators_compare]
(
	   [ServerName]
      ,[OperatorName]
      ,[OperatorEmail]
      ,[OperatorEnabled]
)
select @ProdServer AS servername, * from
	(select	[OperatorName]
      ,[OperatorEmail]
      ,[OperatorEnabled]
	from [utildb].[dbo].[drsync_operators] where [ServerName] = @ProdServer
	except 
	select	[OperatorName]
      ,[OperatorEmail]
      ,[OperatorEnabled]
	from [utildb].[dbo].[drsync_operators] where [ServerName] = @DRServer) x
union all
select @DRServer AS servername, * from
	(select	[OperatorName]
      ,[OperatorEmail]
      ,[OperatorEnabled]
	from [utildb].[dbo].[drsync_operators] where [ServerName] = @DRServer
	except 
	select	[OperatorName]
      ,[OperatorEmail]
      ,[OperatorEnabled]
	from [utildb].[dbo].[drsync_operators] where [ServerName] = @ProdServer) x

------------ / dbo.DRsync_populate_operators_compare ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_ProdJobsDisabled]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_ProdJobsDisabled

	Purpose		:	Populates table drsync_ProdJobsDisabled

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/20/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_ProdJobsDisabled]
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_ProdJobsDisabled];

INSERT INTO [utildb].[dbo].[drsync_ProdJobsDisabled]
( 
	[JobName]
)
SELECT 
	[name] 
FROM 
	msdb.dbo.sysjobs
where 
	[enabled] = 0;

UPDATE [utildb].[dbo].[drsync_ProdJobsDisabled]
SET [ServerName] = @@SERVERNAME;

------------ / dbo.DRsync_populate_ProdJobsDisabled ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_sp_configure_compare]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_sp_configure_compare

	Purpose		:	Populates table sp_configure_compare

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/08/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_sp_configure_compare]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

truncate table [utildb].[dbo].[drsync_sp_configure_compare];

insert into [utildb].[dbo].[drsync_sp_configure_compare]
(
	[servername]  ,
	[setting]  ,
	[minimum]  ,
	[maximum]  ,
	[config_value]  ,
	[run_value] 
)
select @ProdServer AS servername, * from
	(select	[name] as setting
			,[minimum]
			,[maximum]
			,[config_value]
			,[run_value] 
	from [utildb].[dbo].[drsync_sp_configure] where servername = @ProdServer
	except 
	select	[name] as setting
			,[minimum]
			,[maximum]
			,[config_value]
			,[run_value]  
	from [utildb].[dbo].[drsync_sp_configure] where servername = @DRServer) x
union all
select @DRServer AS servername, * from
	(select	[name] as setting
			,[minimum]
			,[maximum]
			,[config_value]
			,[run_value] 
	from [utildb].[dbo].[drsync_sp_configure] where servername = @DRServer
	except 
	select	[name] as setting
			,[minimum]
			,[maximum]
			,[config_value]
			,[run_value]  
	from [utildb].[dbo].[drsync_sp_configure] where servername = @ProdServer) x


------------ / dbo.DRsync_populate_sp_configure_compare ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_SSIS_packages_msdb]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*******************************************************************************************************************************
	Name			:		dbo.DRsync_populate_SSIS_packages_msdb

	Purpose			:		Populates table drsync_SSIS_Packages_msdb

	Used in			: 		utildb database 
	
	Code taken from	:		http://blog.hoegaerden.be/2010/01/10/list-all-ssis-packages-deployed-on-your-integration-server/

	REVISIONS		:		Marios Philippopoulos	01/27/2011 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_SSIS_packages_msdb]
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_SSIS_Packages_msdb];

;WITH ChildFolders
AS
(
    SELECT 
		PARENT.parentfolderid, 
		PARENT.folderid, 
		PARENT.foldername,
        CAST('' AS SYSNAME) AS RootFolder,
        CAST(PARENT.foldername AS VARCHAR(MAX)) AS FullPath,
        0 AS Lvl
    FROM 
		msdb.dbo.sysssispackagefolders PARENT
    WHERE PARENT.parentfolderid IS NULL
    UNION ALL
    SELECT 
		CHILD.parentfolderid, 
		CHILD.folderid, 
		CHILD.foldername,
        CASE ChildFolders.Lvl
            WHEN 0 THEN CHILD.foldername
            ELSE ChildFolders.RootFolder
        END AS RootFolder,
        CAST(ChildFolders.FullPath + '/' + CHILD.foldername AS VARCHAR(MAX))
            AS FullPath,
        ChildFolders.Lvl + 1 AS Lvl
    FROM msdb.dbo.sysssispackagefolders CHILD
        INNER JOIN ChildFolders 
        ON ChildFolders.folderid = CHILD.parentfolderid
)
INSERT INTO [utildb].[dbo].[drsync_SSIS_Packages_msdb]
( 
	[RootFolder] 
	,[FullPath]
	,[PackageName]
	,[Verbuild]
)
SELECT 
	F.RootFolder, 
	F.FullPath, 
	P.name as PackageName,
    P.verbuild
FROM 
	ChildFolders F
    INNER JOIN msdb.dbo.sysssispackages P 
    ON P.folderid = F.folderid
WHERE 
	F.RootFolder <> 'Data Collector'
ORDER BY 
	F.FullPath ASC, P.name ASC;

UPDATE 
	[utildb].[dbo].[drsync_SSIS_Packages_msdb]
SET 
	[ServerName] = @@SERVERNAME;

------------ / dbo.DRsync_populate_SSIS_packages_msdb ------------------------------------------------------------


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_SSIS_packages_msdb_compare]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*******************************************************************************************************************************
	Name			:		dbo.DRsync_populate_SSIS_packages_msdb_compare

	Purpose			:		Populates table drsync_SSIS_Packages_msdb_compare

	Used in			: 		utildb database 

	REVISIONS		:		Marios Philippopoulos	01/27/2011 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_SSIS_packages_msdb_compare]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_SSIS_Packages_msdb_compare];

INSERT INTO [utildb].[dbo].[drsync_SSIS_Packages_msdb_compare]
(
	[ServerName]
,	[RootFolder] 
,	[FullPath]
,	[PackageName]
,	[Verbuild]
)
SELECT @ProdServer AS ServerName, * FROM
(	
	SELECT
		[RootFolder] 
	,	[FullPath]
	,	[PackageName]
	,	[Verbuild]
	FROM [utildb].[dbo].[drsync_SSIS_Packages_msdb] WHERE [ServerName] = @ProdServer
	EXCEPT
	SELECT
		[RootFolder] 
	,	[FullPath]
	,	[PackageName]
	,	[Verbuild]
	FROM [utildb].[dbo].[drsync_SSIS_Packages_msdb] WHERE [ServerName] = @DRServer 
) X
UNION ALL
SELECT @DRServer AS ServerName, * FROM
(
	SELECT
		[RootFolder] 
	,	[FullPath]
	,	[PackageName]
	,	[Verbuild]
	FROM [utildb].[dbo].[drsync_SSIS_Packages_msdb] WHERE [ServerName] = @DRServer
	EXCEPT
	SELECT
		[RootFolder] 
	,	[FullPath]
	,	[PackageName]
	,	[Verbuild]
	FROM [utildb].[dbo].[drsync_SSIS_Packages_msdb] WHERE [ServerName] = @ProdServer 
) X;

------------ / dbo.DRsync_populate_SSIS_packages_msdb_compare ------------------------------------------------------------


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_traceflags]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_traceflags

	Purpose		:	Populates table drsync_jobs

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/21/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_traceflags]
AS

SET NOCOUNT ON;

TRUNCATE TABLE [utildb].[dbo].[drsync_traceflags];

INSERT INTO [utildb].[dbo].[drsync_traceflags]
( 
	[TraceFlag] ,
	[Status]  ,
	[Global]  ,
	[Session]
)
EXEC ('DBCC TRACESTATUS(-1)');

UPDATE [utildb].[dbo].[drsync_traceflags]
SET [ServerName] = @@SERVERNAME;

------------ / dbo.DRsync_populate_traceflags ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_populate_traceflags_compare]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_populate_traceflags_compare

	Purpose		:	Populates table drsync_traceflags_compare

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/21/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_populate_traceflags_compare]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

truncate table [utildb].[dbo].[drsync_traceflags_compare];

insert into [utildb].[dbo].[drsync_traceflags_compare]
(
	   [ServerName]
      ,[TraceFlag]
      ,[Status]
      ,[Global]
      ,[Session]
)
select @ProdServer AS servername, * from
	(select	
		[TraceFlag]
		,[Status]
		,[Global]
		,[Session]
	from [utildb].[dbo].[drsync_traceflags] where [ServerName] = @ProdServer
	except 
	select	
		[TraceFlag]
		,[Status]
		,[Global]
		,[Session]
	from [utildb].[dbo].[drsync_traceflags] where [ServerName] = @DRServer) x
union all
select @DRServer AS servername, * from
	(select	
		[TraceFlag]
		,[Status]
		,[Global]
		,[Session]
	from [utildb].[dbo].[drsync_traceflags] where [ServerName] = @DRServer
	except 
	select	
		[TraceFlag]
		,[Status]
		,[Global]
		,[Session]
	from [utildb].[dbo].[drsync_traceflags] where [ServerName] = @ProdServer) x

------------ / dbo.DRsync_populate_traceflags_compare ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_sp_configure_diff_settings_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_sp_configure_diff_settings_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/07/2010 	- Initial Release
					Marios Philippopoulos	10/27/2010 	- Change in the output column name for D/R setting (from "...2" to "... DR"
					Marios Philippopoulos	10/27/2010 	- Exclude "max server memory (MB)", "min server memory (MB)" settings
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_sp_configure_diff_settings_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE table #sp_config
(
	[ServerName] [varchar](25) NULL, 
	[setting] [varchar](35) NULL,
	[minimum] [int] NULL,
	[maximum] [int] NULL,
	[config_value] [int] NULL,
	[run_value] [int] NULL,
	[ServerName2] [varchar](25) NULL,
	[setting2] [varchar](35) NULL,
	[minimum2] [int] NULL,
	[maximum2] [int] NULL,
	[config_value2] [int] NULL,
	[run_value2] [int] NULL
);

INSERT INTO #sp_config
(
	[servername]
	,[setting]
	,[minimum]
	,[maximum]
	,[config_value]
	,[run_value]
	,[servername2]
	,[setting2]
	,[minimum2]
	,[maximum2]
	,[config_value2]
	,[run_value2]
)
SELECT 
	LEFT(a.[ServerName],25)
	,a.[setting]
	,a.[minimum]
	,a.[maximum]
	,a.[config_value]
	,a.[run_value]
	,(case when a.[ServerName] = b.[ServerName] then NULL else left(b.[ServerName],25) end) as [ServerName2]
	,(case when a.[setting] = b.[setting] then NULL else b.[setting] end) as [setting2]
	,(case when a.[minimum] = b.[minimum] then NULL else b.[minimum] end) as [minimum2]
	,(case when a.[maximum] = b.[maximum] then NULL else b.[maximum] end) as [maximum2]
	,(case when a.[config_value] = b.[config_value] then NULL else b.[config_value] end) as [config_value2]
	,(case when a.[run_value] = b.[run_value] then NULL else b.[run_value] end) as [run_value2]
  FROM [utildb].[dbo].[drsync_sp_configure_compare] a
  join [utildb].[dbo].[drsync_sp_configure_compare] b
  on a.[setting] = b.[setting]
  where a.[ServerName] = @ProdServer and b.[ServerName] = @DRServer
  AND a.[setting] NOT IN ('max server memory (MB)', 'min server memory (MB)')
  order by a.[setting];
  
if (exists ( select c.ServerName, c.[setting], c.[config_value], c.[config_value2]
			 from #sp_config c
			 where c.[config_value2] is NOT NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________sp_configure - config value_______________________'
	print '_______________________________________________________________________'
	print ' '

	select c.ServerName, c.[setting], c.[config_value], c.[config_value2] AS [config_value DR]
	from #sp_config c
	where c.[config_value2] is NOT NULL;
end
	
if (exists ( select c.ServerName, c.[setting], c.[run_value], c.[run_value2]
			 from #sp_config c
			 where c.[run_value2] is NOT NULL ) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________sp_configure - run_value__________________________'
	print '_______________________________________________________________________'
	print ' '

	select c.ServerName, c.[setting], c.[run_value], c.[run_value2] AS [run_value DR]
	from #sp_config c
	where c.[run_value2] is NOT NULL;
end
		
drop table #sp_config;

------------ / dbo.DRsync_sp_configure_diff_settings_report ------------------------------------------------------------

;
;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_SSIS_packages_msdb_diff_settings_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*******************************************************************************************************************************
	Name		:	dbo.DRsync_SSIS_packages_msdb_diff_settings_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	01/27/2011 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_SSIS_packages_msdb_diff_settings_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE table #packages
(
	[ServerName] [varchar](25) NULL,
	[RootFolder] [varchar](25) NULL,
	[FullPath] [varchar](25) NULL,
	[PackageName] [varchar](50) NULL,
	[Verbuild] [int] NULL,
	[RootFolder2] [varchar](25) NULL,
	[FullPath2] [varchar](25) NULL,
	[Verbuild2] [int] NULL
);

INSERT INTO #packages
(
	[ServerName],
	[RootFolder],
	[FullPath],
	[PackageName],
	[Verbuild],
	[RootFolder2],
	[FullPath2],
	[Verbuild2]
)
SELECT 
	LEFT(a.[ServerName],25) as [ServerName]
,	LEFT(a.[RootFolder],25) as [RootFolder]
,	LEFT(a.[FullPath],25) as [FullPath]
,	LEFT(a.[PackageName],50) as [PackageName]
,	a.[Verbuild]
	,(case when a.[RootFolder] = b.[RootFolder] then NULL else LEFT(b.[RootFolder],25) end) as [RootFolder2]
	,(case when a.[FullPath] = b.[FullPath] then NULL else LEFT(b.[FullPath],25) end) as [FullPath2]
	,(case when a.[Verbuild] = b.[Verbuild] then NULL else b.[Verbuild] end) as [Verbuild2]	
  FROM [utildb].[dbo].[drsync_SSIS_Packages_msdb_compare] a
  inner join [utildb].[dbo].[drsync_SSIS_Packages_msdb_compare] b
  on a.[PackageName] = b.[PackageName]
  where a.[servername] = @ProdServer and b.[servername] = @DRServer	
  order by a.[PackageName];

if (exists ( select *
			 from #packages p
			 where p.[RootFolder2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_______SSIS Packages (msdb) - RootFolder_______________________________'
	print '_______________________________________________________________________'
	print ' '

	select p.[ServerName], p.[PackageName], p.[RootFolder], p.[RootFolder2] as [RootFolder DR]
	from #packages p
	where p.[RootFolder2] is not NULL;
end
	
if (exists ( select *
			 from #packages p
			 where p.[FullPath2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_______SSIS Packages (msdb) - FullPath_________________________________'
	print '_______________________________________________________________________'
	print ' '

	select p.[ServerName], p.[PackageName], p.[FullPath], p.[FullPath2] as [FullPath DR]
	from #packages p
	where p.[FullPath2] is not NULL;
end

if (exists ( select *
			 from #packages p
			 where p.[Verbuild2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_______SSIS Packages (msdb) - Verbuild_________________________________'
	print '_______________________________________________________________________'
	print ' '

	select p.[ServerName], p.[PackageName], p.[Verbuild], p.[Verbuild2] as [Verbuild DR]
	from #packages p
	where p.[Verbuild2] is not NULL;
end
		
drop table #packages;

------------ / dbo.DRsync_SSIS_packages_msdb_diff_settings_report ------------------------------------------------------------


GO

/****** Object:  StoredProcedure [dbo].[DRsync_SSIS_packages_msdb_only_on_one_server_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


/*******************************************************************************************************************************
	Name		:	dbo.DRsync_SSIS_packages_msdb_only_on_one_server_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	01/27/2011 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_SSIS_packages_msdb_only_on_one_server_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE TABLE #packages
(
	[ServerName] [varchar](25) NULL,
	[RootFolder] [varchar](25) NULL,
	[FullPath] [varchar](25) NULL,
	[PackageName] [varchar](50) NULL,
	[Verbuild] [int] NULL
);

INSERT INTO #packages
(
	[ServerName],
	[RootFolder],
	[FullPath],
	[PackageName],
	[Verbuild]
)
SELECT
	LEFT(a.[ServerName],25) as [ServerName]
,	LEFT(a.[RootFolder],25) as [RootFolder]
,	LEFT(a.[FullPath],25) as [FullPath]
,	LEFT(a.[PackageName],50) as [PackageName]
,	[Verbuild]
FROM [utildb].[dbo].[drsync_SSIS_Packages_msdb_compare] a
where 
	a.[ServerName] = @ProdServer 
	and a.[PackageName] NOT IN (SELECT b.[PackageName] FROM [utildb].[dbo].[drsync_SSIS_Packages_msdb_compare] b WHERE b.[ServerName] = @DRServer)

UNION ALL

SELECT
	LEFT(a.[ServerName],25) as [ServerName]
,	LEFT(a.[RootFolder],25) as [RootFolder]
,	LEFT(a.[FullPath],25) as [FullPath]
,	LEFT(a.[PackageName],50) as [PackageName]
,	[Verbuild]
FROM [utildb].[dbo].[drsync_SSIS_Packages_msdb_compare] a
where 
	a.[ServerName] = @DRServer 
	and a.[PackageName] NOT IN (SELECT b.[PackageName] FROM [utildb].[dbo].[drsync_SSIS_Packages_msdb_compare] b WHERE b.[ServerName] = @ProdServer);

if (exists ( select *
			 from #packages) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '________SSIS Packages (msdb) - Only On One Server______________________'
	print '_______________________________________________________________________'
	print ' '

	SELECT 
		LEFT(p.[ServerName], 25) AS [ServerName]
	,	LEFT(p.[RootFolder], 25) as [RootFolder]
	,	LEFT(p.[FullPath], 25) as [FullPath]
	,	LEFT(p.[PackageName], 50) AS [PackageName]
	,	[Verbuild]
	FROM 
		#packages p
	ORDER BY 
		p.[ServerName], p.[RootFolder], p.[FullPath], p.[PackageName];
end

DROP TABLE #packages;

------------ / dbo.DRsync_SSIS_packages_msdb_only_on_one_server_report ------------------------------------------------------------


GO

/****** Object:  StoredProcedure [dbo].[DRsync_TraceFlags_diff_settings_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_TraceFlags_diff_settings_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/21/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_TraceFlags_diff_settings_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE table #traceflags
(
	[ServerName] [varchar](25) NULL,
	[TraceFlag] [varchar](6) NULL,
	[Status] [bit] NULL,
	[Global] [bit] NULL,
	[Session] [bit] NULL,	
	[ServerName2] [varchar](25) NULL, 
	[TraceFlag2] [varchar](6) NULL,
	[Status2] [bit] NULL,
	[Global2] [bit] NULL,
	[Session2] [bit] NULL
);

INSERT INTO #traceflags
(
	[ServerName] ,
	[TraceFlag] ,
	[Status] ,
	[Global] ,
	[Session] ,	
	[ServerName2] , 
	[TraceFlag2] ,
	[Status2] ,
	[Global2] ,
	[Session2] 
)
SELECT 
	LEFT(a.[ServerName],25) 
	,a.[TraceFlag]
	,a.[Status]
	,a.[Global]
	,a.[Session]	
	,(case when a.[ServerName] = b.[ServerName] then NULL else left(b.[ServerName],25) end) as [ServerName2] 
	,(case when a.[TraceFlag] = b.[TraceFlag] then NULL else b.[TraceFlag] end) as [TraceFlag2]	
	,(case when a.[Status] = b.[Status] then NULL else b.[Status] end) as [Status2]	
	,(case when a.[Global] = b.[Global] then NULL else b.[Global] end) as [Global2]	
	,(case when a.[Session] = b.[Session] then NULL else b.[Session] end) as [Session2]
FROM [utildb].[dbo].[drsync_traceflags_compare] a
INNER JOIN [utildb].[dbo].[drsync_traceflags_compare] b
ON a.[TraceFlag] = b.[TraceFlag]
WHERE a.[ServerName] = @ProdServer AND b.[ServerName] = @DRServer	
ORDER BY a.[TraceFlag];

if (exists ( select t.[ServerName], t.[TraceFlag], t.[Status], t.[Status2]
			 from #traceflags t
			 where t.[Status2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Trace Flags - Status______________________________'
	print '_______________________________________________________________________'
	print ' '

	select t.[ServerName], t.[TraceFlag], t.[Status], t.[Status2] as [Status DR]
	from #traceflags t
	where t.[Status2] is not NULL;
end
	
if (exists ( select t.[ServerName], t.[TraceFlag], t.[Global], t.[Global2]
			 from #traceflags t
			 where t.[Global2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Trace Flags - Global______________________________'
	print '_______________________________________________________________________'
	print ' '

	select t.[ServerName], t.[TraceFlag], t.[Global], t.[Global2] as [Global DR]
	from #traceflags t
	where t.[Global2] is not NULL;
end

if (exists ( select t.[ServerName], t.[TraceFlag], t.[Session], t.[Session2]
			 from #traceflags t
			 where t.[Session2] is not NULL ) )
begin
	print ' '
	print '_______________________________________________________________________'
	print '_____________________Trace Flags - Session______________________________'
	print '_______________________________________________________________________'
	print ' '

	select t.[ServerName], t.[TraceFlag], t.[Session], t.[Session2] as [Session DR]
	from #traceflags t
	where t.[Session2] is not NULL;
end
		
drop table #traceflags;

------------ / dbo.DRsync_TraceFlags_diff_settings_report ------------------------------------------------------------


;


GO

/****** Object:  StoredProcedure [dbo].[DRsync_TraceFlags_only_on_one_server_report]    Script Date: 02/10/2011 05:56:15 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





/*******************************************************************************************************************************
	Name		:	dbo.DRsync_TraceFlags_only_on_one_server_report

	Purpose		:	

	Used in		: 	utildb database 

	REVISIONS	:	Marios Philippopoulos	09/21/2010 	- Initial Release
*********************************************************************************************************************************/

CREATE PROCEDURE [dbo].[DRsync_TraceFlags_only_on_one_server_report]
	@ProdServer SYSNAME
,	@DRServer SYSNAME
AS

SET NOCOUNT ON;

CREATE TABLE #traceflags
(
	[ServerName] [varchar](25) NULL,
	[TraceFlag] [varchar](6) NULL
);

INSERT INTO #traceflags
(
	[ServerName],
	[TraceFlag]
)
SELECT 
	LEFT(a.[ServerName],25) as [ServerName]
,	a.[TraceFlag]
FROM [utildb].[dbo].[drsync_traceflags_compare] a
where 
	a.[ServerName] = @ProdServer 
	and a.[TraceFlag] NOT IN (SELECT b.[TraceFlag] FROM [utildb].[dbo].[drsync_traceflags_compare] b WHERE b.[ServerName] = @DRServer)

UNION ALL

SELECT 
	LEFT(a.[ServerName],25) as [ServerName]
,	a.[TraceFlag]
FROM [utildb].[dbo].[drsync_traceflags_compare] a
where 
	a.[ServerName] = @DRServer 
	and a.[TraceFlag] NOT IN (SELECT b.[TraceFlag] FROM [utildb].[dbo].[drsync_traceflags_compare] b WHERE b.[ServerName] = @ProdServer);

if (exists ( select t.[ServerName], t.[TraceFlag]
			 from #traceflags t) )
begin
	print ' '	
	print '_______________________________________________________________________'
	print '_____________________Trace Flags - Only On One Server__________________'
	print '_______________________________________________________________________'
	print ' '

	select t.[ServerName], t.[TraceFlag]
	from #traceflags t
	ORDER BY t.[ServerName], t.[TraceFlag];
end

DROP TABLE #traceflags;

------------ / dbo.DRsync_TraceFlags_only_on_one_server_report ------------------------------------------------------------


;


GO

