USE [master]
GO
EXECUTE [dbo].[sp_configure] 'clr enabled', 1;
GO
RECONFIGURE;
GO
CREATE ASYMMETRIC KEY [key_clr_http_request] FROM EXECUTABLE FILE = 'C:\ClrHttpRequest.dll';
GO
CREATE LOGIN [lgn_clr_http_request] FROM ASYMMETRIC KEY [key_clr_http_request];
GO
GRANT UNSAFE ASSEMBLY TO [lgn_clr_http_request];
GO

CREATE DATABASE [db_clr_http_request]
GO
USE [db_clr_http_request]
GO
CREATE USER [usr_clr_http_request] FOR LOGIN [lgn_clr_http_request];
GO
CREATE ASSEMBLY [ClrHttpRequest] FROM 'C:\ClrHttpRequest.dll' WITH PERMISSION_SET=UNSAFE;
GO
CREATE FUNCTION [dbo].[clr_http_request] (@requestMethod NVARCHAR(MAX), @url NVARCHAR(MAX), @parameters NVARCHAR(MAX), @headers NVARCHAR(MAX), @timeout INT, @autoDecompress BIT, @convertResponseToBase64 BIT)
RETURNS XML AS EXTERNAL NAME [ClrHttpRequest].[UserDefinedFunctions].[clr_http_request];
GO

/* -- clean up
USE [db_clr_http_request]
GO
DROP FUNCTION [dbo].[clr_http_request];
DROP ASSEMBLY [ClrHttpRequest];
DROP USER [usr_clr_http_request];
GO

USE [master]
GO
DROP LOGIN [lgn_clr_http_request];
DROP ASYMMETRIC KEY [key_clr_http_request];
DROP DATABASE [db_clr_http_request];
GO
*/