USE [MonitorDB]
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE name = 'Mail_Results_Check_Backups' and type = 'P')
EXEC ('CREATE PROC [dbo].[Mail_Results_Check_Backups] AS PRINT ''STUB VERSION'' ')
GO

ALTER PROCEDURE [dbo].[Mail_Results_Check_Backups]
      @recipients   VARCHAR(MAX) = 'someone@company.com'
    , @profile_name SYSNAME      = '<your_mail_profile>'
AS
  -- This SP runs following the SP 'Check_Backups' and will send an email notification for possible follow-up.
  
IF EXISTS (SELECT 1                    
           FROM   Monitordb.dbo.Backup_Check 
           WHERE  CHARINDEX('!', [Backupdays_Full]) > 0
              OR  CHARINDEX('!', [BackupDays_Diff]) > 0 
              OR  CHARINDEX('!', [BackupDays_Log])  > 0
           )
BEGIN      -- If a condition for possible follow-up is detected, send email alert
 DECLARE   @subject VARCHAR(200)
         , @body    NVARCHAR(MAX)
         , @xml     NVARCHAR(MAX)
 SELECT    @subject = 'SQL Backup warnings'
 SET       @body    = '<html><body>  
               <p><font size="2" face="monaco">  
               (This mail was sent by the procedure ''' + DB_NAME() + '.' + OBJECT_SCHEMA_NAME (@@PROCID) + '.' + OBJECT_NAME(@@PROCID) + ''') <BR><BR>
               This table lists database backup situations that might require follow-up, and is based on values retrieved by the SP ''' + DB_NAME() + '.dbo.Check_Backups''. <BR><BR>
               Records with an exclamation mark (!) in the three last columns should be investigated.<BR><BR>
               ''Young'' database may also show up because the required number of backups has not yet been reached. <BR>
               <table border=1 cellpadding="5">
               <p><font size="2" face="monaco">
               <tr>               
               <th>Server</th> <th>Database</th> <th>Created</th> <th>Fulls</th> <th>Diffs</th> <th>Logs</th> <th>Last<br/>Full</th> <th>Last<br/>Diff</th> <th>Last<br/>Log</th> <th>Days<br/>/Full</th> <th>Days<br/>/Diff</th> <th>Days<br/>/Log</th> </tr>'
 SELECT  @xml = CAST( 
                (SELECT  LEFT(Server_Name,30)                         AS 'td',''  -- SQL Server
                       , LEFT(Database_Name,30)                       AS 'td',''  -- Database
                       , CONVERT(CHAR(11),Create_Date,20)             AS 'td',''  -- Created
                       , ISNULL(Fulls,0)                              AS 'td',''  -- SQL Full backups
                       , ISNULL(Diffs,0)                              AS 'td',''  -- SQL Differential backups
                       , ISNULL(Logs,0)                               AS 'td',''  -- SQL Log backups
                       , ISNULL(CONVERT(CHAR(16),Last_Full,20),'--')  AS 'td',''  -- Last_Full
                       , ISNULL(CONVERT(CHAR(16),Last_Diff,20),'--')  AS 'td',''  -- Last_Diff
                       , ISNULL(CONVERT(CHAR(16),Last_Log, 20),'--')  AS 'td',''  -- Last_Log
                       , ISNULL([BackupDays_Full],0)                  AS 'td',''  -- # Days on which full backups were made + (!) in case of a warning or warning
                       , ISNULL([BackupDays_Diff],0)                  AS 'td',''  -- # Days on which diff backups were made or warning
                       , ISNULL([BackupDays_Log],0)                   AS 'td',''  -- # Days on which log backups were made or warning
                 FROM    Monitordb.dbo.Backup_Check 
                 WHERE   CHARINDEX('!', [Backupdays_Full]) > 0
                    OR   CHARINDEX('!', [BackupDays_Diff]) > 0 
                    OR   CHARINDEX('!', [BackupDays_Log])  > 0
                 ORDER BY Server_Name, Database_Name
                 FOR XML PATH('tr'), ELEMENTS ) 
                 AS NVARCHAR(MAX))

 SET @body = @body + @xml +'</p></table>
             By default, each database must meet the following criteria over the past week:<BR>
               - At least 1 full backup, AND <BR>
               - At least 1 differential or full backup on each of the other days, AND <BR>
               - At lease 1 log backup on each day <BR><BR></body></html>'

 EXEC msdb.dbo.sp_send_dbmail
      @profile_name =  @profile_name
    , @recipients   =  @recipients
    , @subject      =  @subject
    , @body         =  @body
    , @body_format  =  'HTML'

END




GO


