USE [Monitordb]
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE name = 'List_Remote_Databases' and type = 'P')
EXEC ('CREATE PROC [dbo].[List_Remote_Databases] AS PRINT ''STUB VERSION'' ')
GO

ALTER PROC [dbo].[List_Remote_Databases]
   @Server_Name SYSNAME = @@SERVERNAME
AS

/* Create procedure to record the names of all active databases on a linked server in a local holding table */

SET NOCOUNT ON
DELETE [remote_databases] 
WHERE  [server_name] = @Server_Name
 
DECLARE @cmd NVARCHAR(500)
SELECT  @cmd = N'
 INSERT INTO [MonitorDB].[dbo].[Remote_Databases]
   SELECT ''' + @Server_Name + ''', [name]
   FROM   [' + @Server_Name + '].master.sys.databases 
   WHERE  database_id > 4 
     AND  state = 0'
  -- PRINT @cmd   -- For debug purposes
EXEC sp_executesql @cmd     -- Execute this command against @Server_Name

GO

